#include "osl/record/compactBoard.h"
#include "osl/record/csaString.h"
#include "osl/state/simpleState.h"
#include <string>

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class CompactBoardTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( CompactBoardTest );
  CPPUNIT_TEST( testBase64Encode );
  CPPUNIT_TEST( testBase64Decode );
  CPPUNIT_TEST( testisEqual );
  CPPUNIT_TEST_SUITE_END();
 public:
  void testBase64Encode();
  void testBase64Decode();
  void testisEqual();
};

CPPUNIT_TEST_SUITE_REGISTRATION( CompactBoardTest );

using namespace osl;

void CompactBoardTest::testBase64Encode(){
  const SimpleState state(HIRATE);
  const record::CompactBoard cb(state);
  const std::string ret = cb.toBase64();
  const std::string answer = "__sAEf_6ABMACgAXAAsAGf_8ACH__gAi__oAIwAKACcADwAoAAwAKf_9ADH_-gAzAAoANwANADn_-QBB__oAQwAKAEcACQBJ__gAUf_6AFMACgBXAAgAWf_5AGH_-gBjAAoAZwAJAGn__QBx__oAcwAKAHcADQB5__wAgf__AIL_-gCDAAoAhwAOAIgADACJ__sAkf_6AJMACgCXAAsAmQAAAAA=";
  CPPUNIT_ASSERT_EQUAL(answer, ret);
}

void CompactBoardTest::testBase64Decode(){
  const std::string str = "__sAEf_6ABMACgAXAAsAGf_8ACH__gAi__oAIwAKACcADwAoAAwAKf_9ADH_-gAzAAoANwANADn_-QBB__oAQwAKAEcACQBJ__gAUf_6AFMACgBXAAgAWf_5AGH_-gBjAAoAZwAJAGn__QBx__oAcwAKAHcADQB5__wAgf__AIL_-gCDAAoAhwAOAIgADACJ__sAkf_6AJMACgCXAAsAmQAAAAA=";
  const record::CompactBoard cb = record::CompactBoard::fromBase64(str);

  const SimpleState answer(HIRATE);
  const SimpleState state = cb.getState();
  CPPUNIT_ASSERT_EQUAL(answer, state);
}

void CompactBoardTest::testisEqual()
{
  NumEffectState state1;
  const Move m76fu(Square(7,7),Square(7,6),PAWN,PTYPE_EMPTY,false,BLACK);
  state1.makeMove(m76fu);

  NumEffectState state2(CsaString(
			 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
			 "P2 * -HI *  *  *  *  * -KA * \n"
			 "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
			 "P4 *  *  *  *  *  *  *  *  * \n"
			 "P5 *  *  *  *  *  *  *  *  * \n"
			 "P6 *  * +FU *  *  *  *  *  * \n"
			 "P7+FU+FU * +FU+FU+FU+FU+FU+FU\n"
			 "P8 * +KA *  *  *  *  * +HI * \n"
			 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
			 "-\n").getInitialState());
  
  const record::CompactBoard cb1(state1);
  const record::CompactBoard cb2(state2);
  CPPUNIT_ASSERT(cb1 == cb2);
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

