/* offset.h
 */
#ifndef OSL_OFFSET_H
#define OSL_OFFSET_H

#include "osl/player.h"
#include "osl/misc/loki.h"
#include <iosfwd>

namespace osl 
{
  /**
   * 座標の差分
   */
  class Offset
  {
  public:
    enum {
      OFFSET_MIN=-0x100,
      ONBOARD_OFFSET_MIN=-0x88,
      OFFSET_ZERO=0,
      ONBOARD_OFFSET_MAX=0x88,
      OFFSET_MAX=0x100,
      ONBOARD_OFFSET_SIZE=0x88*2+1
    };
    static const int BOARD_HEIGHT=16;
  private:
    int offset;
    explicit Offset(int o) : offset(o)
    {
    }
  public:
    static const Offset makeDirect(int value) { return Offset(value); }
    int intValue() const { return offset; }
  public:
    static int makeOffset(int dx,int dy) { return dx*BOARD_HEIGHT + dy; }
    Offset(int dx,int dy) : offset(makeOffset(dx,dy))
    {
    }
    Offset() : offset(OFFSET_ZERO)
    {
    }
    static const Offset ZERO() { return Offset(OFFSET_ZERO); }
    int
#ifdef __GNUC__
	__attribute__ ((pure))
#endif
    dx() const;
    int
#ifdef __GNUC__
	__attribute__ ((pure))
#endif
    dy() const;
    unsigned int index() const { return offset - OFFSET_MIN; }

    Offset& operator+=(Offset other)
    {
      offset += other.offset;
      return *this;
    }
    Offset& operator-=(Offset other){
      offset -= other.offset;
      return *this;
    }
    const Offset operator+(Offset other) const 
    {
      Offset result(*this);
      return result += other;
    }
    const Offset operator-(const Offset other) const
    {
      Offset result(*this);
      return result -= other;
    }
    const Offset operator*(const int mult) const {
      return static_cast<Offset>(static_cast<int>(offset)*mult);
    }
    const Offset operator-() const { return Offset(-offset); }
#if 0
    inline Offset operator*(const Offset off1,const Offset off2){
      return static_cast<Offset>(static_cast<int>(off1)*static_cast<int>(off2));
    }
#endif
  private:
    const Offset blackOffset(Int2Type<BLACK>) const { return *this; }
    const Offset blackOffset(Int2Type<WHITE>) const { return -(*this); }
  public:
    /**
     * Player P からみた offset を黒番のものに変更する
     */
    template <Player P>
    const Offset blackOffset() const { return blackOffset(Int2Type<P>()); }

    bool zero() const { return offset == OFFSET_ZERO; }
  };

  /**
   * @obsolete
   */
  inline Offset newOffset(int dx,int dy){
    return Offset(dx,dy);
  }

  inline bool operator==(Offset l, Offset r)
  {
    return l.intValue() == r.intValue();
  }
  inline bool operator!=(Offset l, Offset r)
  {
    return ! (l == r);
  }
  inline bool operator<(Offset l, Offset r)
  {
    return l.intValue() < r.intValue();
  }
  

  std::ostream& operator<<(std::ostream&, Offset);

} // namespace osl

#endif /* OSL_OFFSET_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
