# $Id: time.rb,v 0.2 2002/08/07 13:10:16 nobu Exp $

require 'optparse'

begin
  require 'time'
rescue LoadError
  require 'parsedate'
  OptionParser.accept(Time) do |s|
    if s
      begin
	s = Time::mktime(*ParseDate::parsedate(s)[0...6])
      rescue
	raise OptionParser::InvalidArgument, s
      end
    end
    s
  end
else
  OptionParser.accept(Time) do |s|
    if s
      begin
	s = Time.httpdate(s)
      rescue
	begin
	  s = Time.parse(s)
	rescue
	  raise OptionParser::InvalidArgument, s
	end
      end
    end
    s
  end
end
