/*
 * nss_sshsock: NSS module for providing NSS services from a remote
 * ssh server over a SSH socket.
 *
 * Copyright (C) 2011 Scott Balneaves <sbalneav@ltsp.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define MINUID 500
#define MINGID 500
#define CHUNKSIZ 1024

#define SOCKENV "NSS_SSHSOCK_SOCKET"
#define HOSTENV "NSS_SSHSOCK_HOST"

int fgets_nonl (char *s, int size, FILE *stream);
FILE *sshopen (char *remote);
void sshclose (FILE *p);
void delimit_array (char **array, char *buffer, const char *delim);
char **split (char *buffer, const char *delim);
int sanity_check (char **socket, char **host);
