#!/usr/bin/ruby -Ks
#require 'reqnora'
require 'web/common'
require 'web/interface'
require 'web/cookie'
require 'web/response'

def noratest(req,rsp)
  rsp.content_type = 'text/html; charset=Shift_JIS'
  
  rsp.write <<-EOS
  <html>
  <head>
  <title>Nora Test</title>
  </head>
  <body>
  <h1>Nora Test</h1>
  EOS

  # attr
  rsp << "<table border>"
  rsp << "<tr><td>method</td><td>#{Web::escapeHTML(req.method)}</td></tr>"
  rsp << "<tr><td>query_string</td><td>#{Web::escapeHTML(req.query_string)}</td></tr>"
  rsp << "<tr><td>script_name</td><td>#{Web::escapeHTML(req.script_name)}</td></tr>"
  rsp << "<tr><td>path_info</td><td>#{Web::escapeHTML(req.path_info)}</td></tr>"
  rsp << "<tr><td>host</td><td>#{Web::escapeHTML(req.host.to_s)}</td></tr>"
  rsp << "<tr><td>remote_addr</td><td>#{Web::escapeHTML(req.remote_addr.to_s)}</td></tr>"
  rsp << "<tr><td>remote_host</td><td>#{Web::escapeHTML(req.remote_host.to_s)}</td></tr>"
  rsp << "<tr><td>remote_ident</td><td>#{Web::escapeHTML(req.remote_ident || '')}</td></tr>"
  rsp << "<tr><td>remote_user</td><td>#{Web::escapeHTML(req.remote_user || '')}</td></tr>"
  rsp << "</table>"
  
  # query
  rsp << "<h2>query</h2>"
  rsp << "<table border>"
  req.query.each {|key,value|
    rsp << "<tr><td>#{Web::escapeHTML(key)}</td><td>#{Web::escapeHTML(value.inspect)}</td></tr>"
  }
  rsp << "</table>"
  
  # form
  rsp << "<h2>form</h2>"
  rsp << "<table border>"
  req.form.each {|key,value|
    rsp << "<tr><td>#{Web::escapeHTML(key)}</td><td>#{Web::escapeHTML(value.inspect)}</td></tr>"
  }
  rsp << "</table>"
  
  rsp << "<h2>Web::Request</h2>"
  rsp << "<p>" << Web::escapeHTML(req.inspect) << "</p>"
  
  rsp.write <<-EOS
  </body>
  </html>
  EOS
  rsp
end

api = Web::Interface::AUTO.new
api.each {|req|
  rsp = Web::Response.new
  rsp = noratest(req,rsp)
  api.response req, rsp
}
