#!/usr/local/bin/ruby
require 'pstore'

n = (ARGV.shift || 1000).to_i
m = (ARGV.shift || 10).to_i

def countup(ps)
  ps.transaction {
    count = ps['count'] || 0
    count = count + 1
    ps['count'] = count
  }
end

# JEgNA
ps = PStore.new('counter')
ps.transaction {
  ps['count'] = 0
}

# 10vZX1000JEg
m.times do
  fork do
    ps = PStore.new('counter')
    n.times do |n|
      countup(ps)
    end
    puts "done"
  end
end

m.times do
  Process.wait
end

ps = PStore.new('counter')
ps.transaction {
  count = ps['count']
  if count==n*m
    puts "OK: #{count}"
  else
    puts "NG: #{count}"
  end
}
