/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package test.mx4j.tools.adaptor.rmi.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.loading.MLet;

/**
 * @version $Revision: 1.4 $
 */
public class TestMarshalling
{
   public void testStandardArgumentOperation(ClassLoader toolsClassLoader) throws Exception
   {
      ObjectName adaptorName = new ObjectName("Adaptor:type=JRMP");
      ObjectName mletName = new ObjectName("MLet:type=mbean");
      ObjectName mbeanName = new ObjectName("MBean:type=marshal");

      MBeanServer server = MBeanServerFactory.newMBeanServer();

      try
      {
         Object adaptor = toolsClassLoader.loadClass("mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor").newInstance();
         server.registerMBean(adaptor, adaptorName);

         String jndi = "jrmp";
         Method method = adaptor.getClass().getMethod("setJNDIName", new Class[]{String.class});
         method.invoke(adaptor, new Object[]{jndi});

         method = adaptor.getClass().getMethod("start", new Class[0]);
         method.invoke(adaptor, new Object[0]);

         MLet mlet = new MLet(new URL[0], getClass().getClassLoader());
         server.registerMBean(mlet, mletName);

         server.createMBean("test.mx4j.tools.adaptor.rmi.support.Marshal", mbeanName, mletName);

         Object connector = toolsClassLoader.loadClass("mx4j.tools.connector.rmi.jrmp.JRMPConnector").newInstance();
         method = connector.getClass().getMethod("connect", new Class[]{String.class, Hashtable.class});
         method.invoke(connector, new Object[]{jndi, null});

         method = connector.getClass().getMethod("getRemoteMBeanServer", new Class[0]);
         Object remote = method.invoke(connector, new Object[0]);

         method = remote.getClass().getMethod("invoke", new Class[]{ObjectName.class, String.class, Object[].class, String[].class});
         method.setAccessible(true);
         String arg = "argument";
         method.invoke(remote, new Object[]{mbeanName, "normal", new Object[]{arg}, new String[]{String.class.getName()}});
      }
      finally
      {
         try
         {
            server.unregisterMBean(adaptorName);
            server.unregisterMBean(mletName);
            server.unregisterMBean(mbeanName);
         }
         catch (Exception ignored)
         {
         }
      }
   }

   public void testCustomReturnValueOperation(ClassLoader toolsClassLoader) throws Exception
   {
      ObjectName adaptorName = new ObjectName("Adaptor:type=JRMP");
      ObjectName mletName = new ObjectName("MLet:type=mbean");
      ObjectName mbeanName = new ObjectName("MBean:type=marshal");

      MBeanServer server = MBeanServerFactory.newMBeanServer();

      try
      {
         Object adaptor = toolsClassLoader.loadClass("mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor").newInstance();
         server.registerMBean(adaptor, adaptorName);

         String jndi = "jrmp";
         Method method = adaptor.getClass().getMethod("setJNDIName", new Class[]{String.class});
         method.invoke(adaptor, new Object[]{jndi});

         method = adaptor.getClass().getMethod("start", new Class[0]);
         method.invoke(adaptor, new Object[0]);

         MLet mlet = new MLet(new URL[0], getClass().getClassLoader());
         server.registerMBean(mlet, mletName);

         server.createMBean("test.mx4j.tools.adaptor.rmi.support.Marshal", mbeanName, mletName);

         Object connector = toolsClassLoader.loadClass("mx4j.tools.connector.rmi.jrmp.JRMPConnector").newInstance();
         method = connector.getClass().getMethod("connect", new Class[]{String.class, Hashtable.class});
         method.invoke(connector, new Object[]{jndi, null});

         method = connector.getClass().getMethod("getRemoteMBeanServer", new Class[0]);
         Object remote = method.invoke(connector, new Object[0]);

         method = remote.getClass().getMethod("invoke", new Class[]{ObjectName.class, String.class, Object[].class, String[].class});
         method.setAccessible(true);
         Object result = method.invoke(remote, new Object[]{mbeanName, "returning", new Object[0], new String[0]});
         System.out.println("RESULT = " + result);
      }
      finally
      {
         try
         {
            server.unregisterMBean(adaptorName);
            server.unregisterMBean(mletName);
            server.unregisterMBean(mbeanName);
         }
         catch (Exception ignored)
         {
         }
      }
   }


   public void testCustomArgumentOperation(ClassLoader toolsClassLoader) throws Exception
   {
      ObjectName adaptorName = new ObjectName("Adaptor:type=JRMP");
      ObjectName mletName = new ObjectName("MLet:type=mbean");
      ObjectName mbeanName = new ObjectName("MBean:type=marshal");

      MBeanServer server = MBeanServerFactory.newMBeanServer();

      try
      {
         Object adaptor = toolsClassLoader.loadClass("mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor").newInstance();
         server.registerMBean(adaptor, adaptorName);

         String jndi = "jrmp";
         Method method = adaptor.getClass().getMethod("setJNDIName", new Class[]{String.class});
         method.invoke(adaptor, new Object[]{jndi});

         method = adaptor.getClass().getMethod("start", new Class[0]);
         method.invoke(adaptor, new Object[0]);

         MLet mlet = new MLet(new URL[0], getClass().getClassLoader());
         server.registerMBean(mlet, mletName);

         server.createMBean("test.mx4j.tools.adaptor.rmi.support.Marshal", mbeanName, mletName);

         Object connector = toolsClassLoader.loadClass("mx4j.tools.connector.rmi.jrmp.JRMPConnector").newInstance();
         method = connector.getClass().getMethod("connect", new Class[]{String.class, Hashtable.class});
         method.invoke(connector, new Object[]{jndi, null});

         method = connector.getClass().getMethod("getRemoteMBeanServer", new Class[0]);
         Object remote = method.invoke(connector, new Object[0]);

         method = remote.getClass().getMethod("invoke", new Class[]{ObjectName.class, String.class, Object[].class, String[].class});
         method.setAccessible(true);
         Argument arg = new Argument();
         Object result = method.invoke(remote, new Object[]{mbeanName, "operation", new Object[]{arg}, new String[]{Argument.class.getName()}});
         System.out.println("RESULT = " + result);
      }
      finally
      {
         try
         {
            server.unregisterMBean(adaptorName);
            server.unregisterMBean(mletName);
            server.unregisterMBean(mbeanName);
         }
         catch (Exception ignored)
         {
         }
      }
   }

   public void testGetCustomAttribute(ClassLoader toolsClassLoader) throws Exception
   {
      ObjectName adaptorName = new ObjectName("Adaptor:type=JRMP");
      ObjectName mletName = new ObjectName("MLet:type=mbean");
      ObjectName mbeanName = new ObjectName("MBean:type=marshal");

      MBeanServer server = MBeanServerFactory.newMBeanServer();

      try
      {
         Object adaptor = toolsClassLoader.loadClass("mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor").newInstance();
         server.registerMBean(adaptor, adaptorName);

         String jndi = "jrmp";
         Method method = adaptor.getClass().getMethod("setJNDIName", new Class[]{String.class});
         method.invoke(adaptor, new Object[]{jndi});

         method = adaptor.getClass().getMethod("start", new Class[0]);
         method.invoke(adaptor, new Object[0]);

         MLet mlet = new MLet(new URL[0], getClass().getClassLoader());
         server.registerMBean(mlet, mletName);

         server.createMBean("test.mx4j.tools.adaptor.rmi.support.Marshal", mbeanName, mletName);

         Object connector = toolsClassLoader.loadClass("mx4j.tools.connector.rmi.jrmp.JRMPConnector").newInstance();
         method = connector.getClass().getMethod("connect", new Class[]{String.class, Hashtable.class});
         method.invoke(connector, new Object[]{jndi, null});

         method = connector.getClass().getMethod("getRemoteMBeanServer", new Class[0]);
         Object remote = method.invoke(connector, new Object[0]);

         method = remote.getClass().getMethod("getAttribute", new Class[]{ObjectName.class, String.class});
         method.setAccessible(true);
         Object result = method.invoke(remote, new Object[]{mbeanName, "Argument"});
         System.out.println("RESULT = " + result);
      }
      finally
      {
         try
         {
            server.unregisterMBean(adaptorName);
            server.unregisterMBean(mletName);
            server.unregisterMBean(mbeanName);
         }
         catch (Exception ignored)
         {
         }
      }
   }

   public void testGetCustomAttributes(ClassLoader toolsClassLoader) throws Exception
   {
      ObjectName adaptorName = new ObjectName("Adaptor:type=JRMP");
      ObjectName mletName = new ObjectName("MLet:type=mbean");
      ObjectName mbeanName = new ObjectName("MBean:type=marshal");

      MBeanServer server = MBeanServerFactory.newMBeanServer();

      try
      {
         Object adaptor = toolsClassLoader.loadClass("mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor").newInstance();
         server.registerMBean(adaptor, adaptorName);

         String jndi = "jrmp";
         Method method = adaptor.getClass().getMethod("setJNDIName", new Class[]{String.class});
         method.invoke(adaptor, new Object[]{jndi});

         method = adaptor.getClass().getMethod("start", new Class[0]);
         method.invoke(adaptor, new Object[0]);

         MLet mlet = new MLet(new URL[0], getClass().getClassLoader());
         server.registerMBean(mlet, mletName);

         server.createMBean("test.mx4j.tools.adaptor.rmi.support.Marshal", mbeanName, mletName);

         Object connector = toolsClassLoader.loadClass("mx4j.tools.connector.rmi.jrmp.JRMPConnector").newInstance();
         method = connector.getClass().getMethod("connect", new Class[]{String.class, Hashtable.class});
         method.invoke(connector, new Object[]{jndi, null});

         method = connector.getClass().getMethod("getRemoteMBeanServer", new Class[0]);
         Object remote = method.invoke(connector, new Object[0]);

         method = remote.getClass().getMethod("getAttributes", new Class[]{ObjectName.class, String[].class});
         method.setAccessible(true);
         Object result = method.invoke(remote, new Object[]{mbeanName, new String[]{"Argument"}});
         System.out.println("RESULT = " + result);
      }
      finally
      {
         try
         {
            server.unregisterMBean(adaptorName);
            server.unregisterMBean(mletName);
            server.unregisterMBean(mbeanName);
         }
         catch (Exception ignored)
         {
         }
      }
   }

   public void testSetCustomAttribute(ClassLoader toolsClassLoader) throws Exception
   {
      ObjectName adaptorName = new ObjectName("Adaptor:type=JRMP");
      ObjectName mletName = new ObjectName("MLet:type=mbean");
      ObjectName mbeanName = new ObjectName("MBean:type=marshal");

      MBeanServer server = MBeanServerFactory.newMBeanServer();

      try
      {
         Object adaptor = toolsClassLoader.loadClass("mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor").newInstance();
         server.registerMBean(adaptor, adaptorName);

         String jndi = "jrmp";
         Method method = adaptor.getClass().getMethod("setJNDIName", new Class[]{String.class});
         method.invoke(adaptor, new Object[]{jndi});

         method = adaptor.getClass().getMethod("start", new Class[0]);
         method.invoke(adaptor, new Object[0]);

         MLet mlet = new MLet(new URL[0], getClass().getClassLoader());
         server.registerMBean(mlet, mletName);

         server.createMBean("test.mx4j.tools.adaptor.rmi.support.Marshal", mbeanName, mletName);

         Object connector = toolsClassLoader.loadClass("mx4j.tools.connector.rmi.jrmp.JRMPConnector").newInstance();
         method = connector.getClass().getMethod("connect", new Class[]{String.class, Hashtable.class});
         method.invoke(connector, new Object[]{jndi, null});

         method = connector.getClass().getMethod("getRemoteMBeanServer", new Class[0]);
         Object remote = method.invoke(connector, new Object[0]);

         method = remote.getClass().getMethod("setAttribute", new Class[]{ObjectName.class, Attribute.class});
         method.setAccessible(true);
         Attribute arg = new Attribute("Argument", new Argument());
         method.invoke(remote, new Object[]{mbeanName, arg});
      }
      finally
      {
         try
         {
            server.unregisterMBean(adaptorName);
            server.unregisterMBean(mletName);
            server.unregisterMBean(mbeanName);
         }
         catch (Exception ignored)
         {
         }
      }
   }

   public void testSetCustomAttributes(ClassLoader toolsClassLoader) throws Exception
   {
      ObjectName adaptorName = new ObjectName("Adaptor:type=JRMP");
      ObjectName mletName = new ObjectName("MLet:type=mbean");
      ObjectName mbeanName = new ObjectName("MBean:type=marshal");

      MBeanServer server = MBeanServerFactory.newMBeanServer();

      try
      {
         Object adaptor = toolsClassLoader.loadClass("mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor").newInstance();
         server.registerMBean(adaptor, adaptorName);

         String jndi = "jrmp";
         Method method = adaptor.getClass().getMethod("setJNDIName", new Class[]{String.class});
         method.invoke(adaptor, new Object[]{jndi});

         method = adaptor.getClass().getMethod("start", new Class[0]);
         method.invoke(adaptor, new Object[0]);

         MLet mlet = new MLet(new URL[0], getClass().getClassLoader());
         server.registerMBean(mlet, mletName);

         server.createMBean("test.mx4j.tools.adaptor.rmi.support.Marshal", mbeanName, mletName);

         Object connector = toolsClassLoader.loadClass("mx4j.tools.connector.rmi.jrmp.JRMPConnector").newInstance();
         method = connector.getClass().getMethod("connect", new Class[]{String.class, Hashtable.class});
         method.invoke(connector, new Object[]{jndi, null});

         method = connector.getClass().getMethod("getRemoteMBeanServer", new Class[0]);
         Object remote = method.invoke(connector, new Object[0]);

         method = remote.getClass().getMethod("setAttributes", new Class[]{ObjectName.class, AttributeList.class});
         method.setAccessible(true);
         Attribute arg = new Attribute("Argument", new Argument());
         AttributeList list = new AttributeList();
         list.add(arg);
         Object result = method.invoke(remote, new Object[]{mbeanName, list});
         System.out.println("RESULT = " + result);
      }
      finally
      {
         try
         {
            server.unregisterMBean(adaptorName);
            server.unregisterMBean(mletName);
            server.unregisterMBean(mbeanName);
         }
         catch (Exception ignored)
         {
         }
      }
   }

   public void testCreateMBeanWithRepository(ClassLoader toolsClassLoader) throws Exception
   {
      ObjectName adaptorName = new ObjectName("Adaptor:type=JRMP");
      ObjectName mletName = new ObjectName("MLet:type=mbean");
      ObjectName mbeanName = new ObjectName("MBean:type=marshal");

      MBeanServer server = MBeanServerFactory.newMBeanServer();

      try
      {
         Object adaptor = toolsClassLoader.loadClass("mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor").newInstance();
         server.registerMBean(adaptor, adaptorName);

         String jndi = "jrmp";
         Method method = adaptor.getClass().getMethod("setJNDIName", new Class[]{String.class});
         method.invoke(adaptor, new Object[]{jndi});

         method = adaptor.getClass().getMethod("start", new Class[0]);
         method.invoke(adaptor, new Object[0]);

         MLet mlet = new MLet(new URL[0], getClass().getClassLoader());
         server.registerMBean(mlet, mletName);

         Object connector = toolsClassLoader.loadClass("mx4j.tools.connector.rmi.jrmp.JRMPConnector").newInstance();
         method = connector.getClass().getMethod("connect", new Class[]{String.class, Hashtable.class});
         method.invoke(connector, new Object[]{jndi, null});

         method = connector.getClass().getMethod("getRemoteMBeanServer", new Class[0]);
         Object remote = method.invoke(connector, new Object[0]);

         method = remote.getClass().getMethod("createMBean", new Class[]{String.class, ObjectName.class});
         method.setAccessible(true);
         Object result = method.invoke(remote, new Object[]{"test.mx4j.tools.adaptor.rmi.support.Marshal", mbeanName});
         System.out.println("RESULT = " + result);
      }
      finally
      {
         try
         {
            server.unregisterMBean(adaptorName);
            server.unregisterMBean(mletName);
            server.unregisterMBean(mbeanName);
         }
         catch (Exception ignored)
         {
         }
      }
   }

   public void testCreateMBeanWithNullLoader(ClassLoader toolsClassLoader) throws Exception
   {
      ObjectName adaptorName = new ObjectName("Adaptor:type=JRMP");
      ObjectName mletName = new ObjectName("MLet:type=mbean");
      ObjectName mbeanName = new ObjectName("MBean:type=marshal");

      MBeanServer server = MBeanServerFactory.newMBeanServer();

      try
      {
         Object adaptor = toolsClassLoader.loadClass("mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor").newInstance();
         server.registerMBean(adaptor, adaptorName);

         String jndi = "jrmp";
         Method method = adaptor.getClass().getMethod("setJNDIName", new Class[]{String.class});
         method.invoke(adaptor, new Object[]{jndi});

         method = adaptor.getClass().getMethod("start", new Class[0]);
         method.invoke(adaptor, new Object[0]);

         MLet mlet = new MLet(new URL[0], getClass().getClassLoader());
         server.registerMBean(mlet, mletName);

         Object connector = toolsClassLoader.loadClass("mx4j.tools.connector.rmi.jrmp.JRMPConnector").newInstance();
         method = connector.getClass().getMethod("connect", new Class[]{String.class, Hashtable.class});
         method.invoke(connector, new Object[]{jndi, null});

         method = connector.getClass().getMethod("getRemoteMBeanServer", new Class[0]);
         Object remote = method.invoke(connector, new Object[0]);

         method = remote.getClass().getMethod("createMBean", new Class[]{String.class, ObjectName.class, ObjectName.class});
         method.setAccessible(true);
         try
         {
            method.invoke(remote, new Object[]{"test.mx4j.tools.adaptor.rmi.support.Marshal", mbeanName, null});
            throw new Exception();
         }
         catch (InvocationTargetException x)
         {
            boolean ok = false;
            Throwable t = x.getTargetException();
            if (t instanceof ReflectionException)
            {
               Exception xx = ((ReflectionException)t).getTargetException();
               if (xx instanceof ClassNotFoundException) ok = true;
            }
            if (!ok) throw x;
         }
      }
      finally
      {
         try
         {
            server.unregisterMBean(adaptorName);
            server.unregisterMBean(mletName);
            server.unregisterMBean(mbeanName);
         }
         catch (Exception ignored)
         {
         }
      }
   }

   public void testCreateMBeanWithLoader(ClassLoader toolsClassLoader) throws Exception
   {
      ObjectName adaptorName = new ObjectName("Adaptor:type=JRMP");
      ObjectName mletName = new ObjectName("MLet:type=mbean");
      ObjectName mbeanName = new ObjectName("MBean:type=marshal");

      MBeanServer server = MBeanServerFactory.newMBeanServer();

      try
      {
         Object adaptor = toolsClassLoader.loadClass("mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor").newInstance();
         server.registerMBean(adaptor, adaptorName);

         String jndi = "jrmp";
         Method method = adaptor.getClass().getMethod("setJNDIName", new Class[]{String.class});
         method.invoke(adaptor, new Object[]{jndi});

         method = adaptor.getClass().getMethod("start", new Class[0]);
         method.invoke(adaptor, new Object[0]);

         MLet mlet = new MLet(new URL[0], getClass().getClassLoader());
         server.registerMBean(mlet, mletName);

         Object connector = toolsClassLoader.loadClass("mx4j.tools.connector.rmi.jrmp.JRMPConnector").newInstance();
         method = connector.getClass().getMethod("connect", new Class[]{String.class, Hashtable.class});
         method.invoke(connector, new Object[]{jndi, null});

         method = connector.getClass().getMethod("getRemoteMBeanServer", new Class[0]);
         Object remote = method.invoke(connector, new Object[0]);

         method = remote.getClass().getMethod("createMBean", new Class[]{String.class, ObjectName.class, ObjectName.class});
         method.setAccessible(true);
         Object result = method.invoke(remote, new Object[]{"test.mx4j.tools.adaptor.rmi.support.Marshal", mbeanName, mletName});
         System.out.println("RESULT = " + result);
      }
      finally
      {
         try
         {
            server.unregisterMBean(adaptorName);
            server.unregisterMBean(mletName);
            server.unregisterMBean(mbeanName);
         }
         catch (Exception ignored)
         {
         }
      }
   }
}
