/*
 * MusicBrainz -- The Internet music metadatabase
 *
 * Copyright (C) 2006 Lukas Lalinsky
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * $Id: relation.cpp 8466 2006-09-05 08:59:44Z luks $
 */
 
#include <string>
#include <musicbrainz3/model.h>

using namespace std;
using namespace MusicBrainz;

const string Relation::TO_ARTIST = NS_MMD_1 + "Artist"; 
const string Relation::TO_RELEASE = NS_MMD_1 + "Release"; 
const string Relation::TO_TRACK = NS_MMD_1 + "Track"; 
const string Relation::TO_URL = NS_MMD_1 + "Url"; 

class Relation::RelationPrivate
{
public:
	RelationPrivate()
		{}
	
	std::string type;
	std::string targetType;
	std::string targetId;
	Direction direction;
	Attributes attributes;
	std::string beginDate;
	std::string endDate;
	Entity *target;
};

Relation::Relation(const std::string &relationType,
				   const std::string &targetType,
				   const std::string &targetId,
				   const Direction direction,
				   const std::vector<std::string> &attributes,
				   const std::string &beginDate,
				   const std::string &endDate,
				   Entity *target)
{
	d = new RelationPrivate();
	
	d->type = relationType;
	d->targetType = targetType;
	d->targetId = targetId;
	d->direction = direction;
	d->attributes = attributes;
	d->beginDate = beginDate;
	d->endDate = endDate;
	d->target = target;
}

Relation::~Relation()
{
	if (d->target)
		delete d->target;
	
	delete d;
}

string
Relation::getType() const
{
	return d->type;
}

void
Relation::setType(const string &value)
{
	d->type = value;
}

string
Relation::getTargetId() const
{
	return d->targetId;
}

void
Relation::setTargetId(const string &value)
{
	d->targetId = value;
}

Relation::Direction
Relation::getDirection() const
{
	return d->direction;
}

void
Relation::setDirection(const Relation::Direction value)
{
	d->direction = value;
}

string
Relation::getTargetType() const
{
	return d->targetType;
}

void
Relation::setTargetType(const string &value)
{
	d->targetType = value;
}

Entity *
Relation::getTarget() const
{
	return d->target;
}

void
Relation::setTarget(Entity *value)
{
	d->target = value;
}

Relation::Attributes &
Relation::getAttributes()
{
	return d->attributes;
}

void
Relation::addAttribute(const string &value)
{
	d->attributes.push_back(value);
}

string
Relation::getBeginDate() const
{
	return d->beginDate;
}

void
Relation::setBeginDate(const string &value)
{
	d->beginDate = value;
}

string
Relation::getEndDate() const
{
	return d->endDate;
}

void
Relation::setEndDate(const string &value)
{
	d->endDate = value;
} 

int
Relation::getNumAttributes() const
{
	return d->attributes.size();
}

string
Relation::getAttribute(int i) const
{
	return d->attributes[i];
}

