# mongocrypt Java Wrapper #
The Java wrapper for the companion C library for client side encryption in drivers.

### Testing ###
`./gradlew check` runs the java test suite. By default it expects that libmongocrypt is in `./build/jnaLibs/<ARCH>/` - where <ARCH> is the current platform architecture: eg: `linux-x86-64`.

To test against a local build:
`/gradlew check -DjnaLibsPath=../../../../libmongocrypt/cmake-build`

Note: libmongocrypt and the java library are continuously built on evergreen. Submit patch builds to this evergreen project when making changes to test on supported platforms.

### Publishing ####

First check the build artifacts locally (~/.m2/repository/org/mongodb/mongocrypt): `./gradlew clean downloadJnaLibs publishToMavenLocal`

**Sonatype**

`./gradlew publishToSonatype`
Will push the latest snapshot or release version to sonatype repository.

### Custom gradle flags ###

* `jnaLibsPath`: Custom local JNA library path for inclusion into the build (rather than downloading from s3)<br>
  Usage: `./gradlew publishToSonatype -DjnaLibsPath=../../../cmake-build-nocrypto`
* `gitRevision`: Sets the Git Revision to download the built resources for from s3.<br>
  Usage: `./gradlew publishToSonatype -DgitRevision=<fullGitHash>`

These flags can be combined with the `downloadJnaLibs` task:
 
* Test without compiling libmongocrypt locally:<br> `./gradlew clean downloadJnaLibs test -DgitRevision=<fullGitHash>`
* Test using a custom libmongocrypt path:<br> `./gradlew clean test -DjnaLibsPath=<path>`


### Debugging errors ###

* Use the info and jna debug flags to output debugging information when running tasks:<br> `./gradlew <taskName> --info -Djna.debug_load=true`
