package Locales::DB::Language::ml;

# Auto generated from CLDR

$Locales::DB::Language::ml::VERSION = '0.06';

$Locales::DB::Language::ml::cldr_version = '1.7.2';

%Locales::DB::Language::ml::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#\,\#\#0\.\#\#\#",
        'language'                => "ഭാഷ\:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#\,\#\#0\%",
        'territory'               => "ദേശം\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => 'അല്ല',
        'yesstr' => 'അതെ'
    },
);

%Locales::DB::Language::ml::code_to_name = (
    'aa'    => 'അഫാര്‍',
    'ab'    => 'അബ്ഖാസിയന്‍',
    'ace'   => 'അചിനീസ്',
    'ach'   => 'അകോലി',
    'ada'   => 'അഡാങ്ഗമി',
    'ady'   => 'അഡൈഗേ',
    'ae'    => 'അവസ്റ്റാന്‍',
    'af'    => 'ആഫ്രിക്കാന്‍സ്',
    'afa'   => "ആഫ്രോ\-ഏഷ്യാറ്റിക്\ ഭാഷ",
    'afh'   => 'ആഫ്രിഹിലി',
    'ain'   => 'അയിനു',
    'ak'    => 'അകാന്‍',
    'akk'   => 'അക്കാഡിയന്‍',
    'ale'   => 'അലൈട്ട്',
    'alg'   => "അല്‍ഗോണ്‍ക്യന്‍\ ഭാഷ",
    'alt'   => "തെക്കന്‍\ അള്‍ട്ടായി",
    'am'    => 'അമാറിക്',
    'an'    => 'അരഗോണീസ്',
    'ang'   => "പഴയ\ ഇംഗ്ലീഷ്",
    'anp'   => 'ആന്‍ഗിക',
    'apa'   => "അപ്പാചേ\ ഭാഷ",
    'ar'    => 'അറബി',
    'arc'   => 'അരമായഭാഷ',
    'arn'   => 'ആരൗകാനിയന്‍',
    'arp'   => 'അരപാഹോ',
    'art'   => 'കൃത്രിമഭാഷ',
    'arw'   => 'അറാവക്',
    'as'    => 'ആസ്സാമീസ്',
    'ast'   => 'ഓസ്‌ട്രിയന്‍',
    'ath'   => "അതപാസ്കന്‍\ ഭാഷ",
    'aus'   => "ഓസ്ട്രേലിയന്‍\ ഭാഷ",
    'av'    => 'അവാരിക്',
    'awa'   => 'അവധി',
    'ay'    => 'അയ്മാറ',
    'az'    => 'അസര്‍ബൈജാനി',
    'ba'    => 'ബഷ്ഖിര്‍',
    'bad'   => 'ബന്‍ഡ',
    'bai'   => "ബാമിലകേ\ ഭാഷ",
    'bal'   => 'ബലൂചി',
    'ban'   => 'ബാലിനീസ്',
    'bas'   => 'ബസ',
    'bat'   => "ബാള്‍ട്ടിക്\ ഭാഷ",
    'be'    => 'ബൈലോറഷ്യന്‍',
    'bej'   => 'ബേജ',
    'bem'   => 'ബെംബ',
    'ber'   => 'ബെര്‍ബര്‍',
    'bg'    => 'ബള്‍ഗേറിയന്‍',
    'bh'    => 'ബീഹാറി',
    'bho'   => 'ഭോജ്‌പൂരി',
    'bi'    => 'ബിസ്‌ലാമ',
    'bik'   => 'ബികോല്‍',
    'bin'   => 'ബിനി',
    'bla'   => 'സിക്സിക',
    'bm'    => 'ബംബാറ',
    'bn'    => 'ബംഗാളി',
    'bnt'   => 'ബാന്‌ടു',
    'bo'    => 'തിബറ്റന്‍',
    'br'    => 'ബ്രറ്റണ്‍',
    'bra'   => 'ബ്രജ്',
    'bs'    => 'ബോസ്നിയന്‍',
    'btk'   => 'ബാറ്റക്',
    'bua'   => 'ബുറിയത്ത്',
    'bug'   => 'ബുഗിനീസ്',
    'byn'   => 'ബ്ലിന്‍',
    'ca'    => 'കറ്റാലന്‍',
    'cad'   => 'കാഡോ',
    'cai'   => "മദ്ധ്യ\ അമേരിക്കന്‍\ ഇന്‍ഡ്യന്‍\ ഭാഷ",
    'car'   => 'കാരിബ്',
    'cau'   => "കൊക്കേഷ്യന്‍\ ഭാഷ",
    'cch'   => 'അറ്റ്സാം',
    'ce'    => 'ചെചന്‍',
    'ceb'   => 'സെബുവാനോ',
    'cel'   => "സെല്‍റ്റിക്\ ഭാഷ",
    'ch'    => 'കമോറോ',
    'chb'   => 'ചിബ്ച',
    'chg'   => 'ചഗതൈ',
    'chk'   => 'ചൂകീസ്',
    'chm'   => 'മാരി',
    'chn'   => "ചിനൂഗ്\-ജാര്‍ഗണ്‍",
    'cho'   => 'ചോക്റ്റാവ്',
    'chp'   => 'ചിപേവ്യന്‍',
    'chr'   => 'ചെരോകീ',
    'chy'   => 'ചിയേന്നേ',
    'cmc'   => "ചാമിക്\ ഭാഷ",
    'co'    => 'കോഴ്സിക്കണ്‍',
    'cop'   => 'കോപ്റ്റിക്',
    'cpe'   => "ഇംഗ്ലീഷ്\ അധിഷ്ഠിത\ മിശ്ര\ ഭാഷ",
    'cpf'   => "ഫ്രഞ്ച്\ അധിഷ്ഠിത\ മിശ്രഭാഷ",
    'cpp'   => "പോര്‍ച്ചുഗീസ്\ അധിഷ്ഠിത\ മിശ്രഭാഷ",
    'cr'    => 'ക്രീ',
    'crh'   => "ക്രിമിയന്‍\ ടര്‍ക്കിഷ്",
    'crp'   => 'മിശ്രഭാഷ',
    'cs'    => 'ചെക്ക്',
    'csb'   => 'കാഷുബിയാന്‍',
    'cu'    => "ചര്‍ച്ച്\ സ്ലാവിക്",
    'cus'   => "കുഷിറ്റിക്\ ഭാഷ",
    'cv'    => 'ചുവാഷ്',
    'cy'    => 'വെല്‍ഷ്',
    'da'    => 'ഡാനിഷ്',
    'dak'   => 'ഡകോട്ട',
    'dar'   => 'ഡര്‍ഗ്വാ',
    'day'   => 'ദയാക്',
    'de'    => 'ജര്‍മ്മന്‍',
    'de_at' => "ഓസ്ട്രിയന്‍\ ജര്‍മന്‍",
    'de_ch' => "സ്വിസ്\ ഉച്ച\ ജര്‍മന്‍",
    'del'   => 'ദലവാരെ',
    'den'   => 'സ്ലേവ്',
    'dgr'   => 'ഡോഗ്രിബ്',
    'din'   => 'ദിന്‍ക',
    'doi'   => 'ഡോഗ്രി',
    'dra'   => 'ദ്രാവിഡഭാഷ',
    'dsb'   => "ലോവര്‍\ സോര്‍ബിയന്‍",
    'dua'   => 'ദ്വാല',
    'dum'   => "മദ്ധ്യ\ ഡച്ച്",
    'dv'    => 'ദിവെഹി',
    'dyu'   => 'ദ്വൈല',
    'dz'    => 'ഭൂട്ടാനി',
    'ee'    => 'എവ്',
    'efi'   => 'എഫിക്',
    'egy'   => "പ്രാചീന\ ഈജിപ്ഷ്യന്‍",
    'eka'   => 'എകാജുക്',
    'el'    => 'ഗ്രീക്ക്',
    'elx'   => 'എലാമൈറ്റ്',
    'en'    => 'ഇംഗ്ലീഷ്',
    'en_au' => "ഓസ്ട്രേലിയന്‍\ ഇംഗ്ലീഷ്",
    'en_ca' => "കനേഡിയന്‍\ ഇംഗ്ലീഷ്",
    'en_gb' => "ബ്രിട്ടീഷ്\ ഇംഗ്ലീഷ്",
    'en_us' => "അമേരിക്കന്‍\ ഇംഗ്ലീഷ്",
    'enm'   => "മദ്ധ്യ\ ഇംഗ്ലീഷ്",
    'eo'    => 'എസ്പരാന്തോ',
    'es'    => 'സ്പാനിഷ്',
    'es_es' => "ഇബേറിയന്‍\ സ്പാനിഷ്",
    'et'    => 'എസ്റ്റോണിയന്‍',
    'eu'    => 'ബാസ്ക്',
    'ewo'   => 'എവോന്‍ഡോ',
    'fa'    => 'പേര്‍ഷ്യന്‍',
    'fan'   => 'ഫങ്',
    'fat'   => 'ഫിലിപ്പീനോ',
    'ff'    => 'ഫുല',
    'fi'    => 'ഫിന്നിഷ്',
    'fil'   => 'ഫിലിപ്പിനോ',
    'fiu'   => "ഫിന്നോ\-ഉഗ്രിയന്‍\ ഭാഷ",
    'fj'    => 'ഫിജിയന്‍',
    'fo'    => 'ഫാറോസ്',
    'fon'   => 'ഫോന്‍',
    'fr'    => 'ഫ്രഞ്ച്',
    'fr_ca' => "കനേഡിയന്‍\ ഫ്രഞ്ച്",
    'fr_ch' => "സ്വിസ്\ ഫ്രഞ്ച്",
    'frm'   => "മദ്ധ്യ\ ഫ്രഞ്ച്",
    'fro'   => "പഴയ\ ഫ്രഞ്ച്",
    'frr'   => "നോര്‍ത്തേന്‍\ ഫ്രിഷ്യന്‍",
    'frs'   => "ഈസ്റ്റേണ്‍\ ഫ്രിഷ്യന്‍",
    'fur'   => 'ഫ്രിയുലിയാന്‍',
    'fy'    => "പശ്ചിമ\ ഫ്രിഷിയന്‍",
    'ga'    => 'ഐറിഷ്',
    'gaa'   => 'ഗാ',
    'gay'   => 'ഗയൊ',
    'gba'   => 'ഗബ്യ',
    'gd'    => "സ്കോട്ടിഷ്\ ഗൈലിക്",
    'gem'   => "ജര്‍മാനിക്\ ഭാഷ",
    'gez'   => 'ഗീസ്',
    'gil'   => 'ഗില്‍ബര്‍സേ',
    'gl'    => 'ഗലീഷ്യന്‍',
    'gmh'   => "മദ്ധ്യ\ ഉച്ച\ ജര്‍മന്‍",
    'gn'    => 'ഗ്വാറാനി',
    'goh'   => "പ്രാചീന\ ഉച്ച\ ജര്‍മന്‍",
    'gon'   => 'ഗോണ്ഡി',
    'gor'   => 'ഗൊറോന്‍റാലോ',
    'got'   => 'ഗോഥിക്ക്',
    'grb'   => 'ഗ്രബൊ',
    'grc'   => "പുരാതന\ യവന\ ഭാഷ",
    'gsw'   => "സ്വിസ്\ ജര്‍മന്‍",
    'gu'    => 'ഗുജറാത്തി',
    'gv'    => 'മാന്‍സ്',
    'gwi'   => "ഗ്വിച്ച്\ ഇന്‍",
    'ha'    => 'ഹൗസ',
    'hai'   => 'ഹൈഡ',
    'haw'   => 'ഹവായിയന്‍',
    'he'    => 'ഹീബ്രു',
    'hi'    => 'ഹിന്ദി',
    'hil'   => 'ഹിലിഗയ്നോണ്‍',
    'him'   => 'ഹിമാചലി',
    'hit'   => 'ഹിറ്റൈറ്റേ',
    'hmn'   => 'മോങ്',
    'ho'    => "ഹിരി\ മോതു",
    'hr'    => 'ക്രൊയേഷ്യന്‍',
    'hsb'   => "അപ്പര്‍\ സോര്‍ബിയന്‍",
    'ht'    => 'ഹെയ്തിയന്‍',
    'hu'    => 'ഹംഗേറിയന്‍',
    'hup'   => 'ഹൂപ',
    'hy'    => 'അര്‍മേനിയന്‍',
    'hz'    => 'ഹെരേരൊ',
    'ia'    => 'ഇന്‍റര്‍ലിംഗ്വാ',
    'iba'   => 'ഇബാന്‍',
    'id'    => 'ഇന്‍ഡോനേഷ്യന്‍',
    'ie'    => 'ഇന്റര്‍ലിംഗ്വ',
    'ig'    => 'ഇഗ്ബോ',
    'ii'    => 'ഷുവാന്‍യി',
    'ijo'   => 'ഇജോ',
    'ik'    => 'ഇനുപിയാക്',
    'ilo'   => 'ഇലോകോ',
    'inc'   => 'ഭാരതീയഭാഷ',
    'ine'   => "ഇന്‍ഡോ\-യൂറോപ്യന്‍\ ഭാഷ",
    'inh'   => 'ഇംഗ്വിഷ്',
    'io'    => 'ഇഡോ',
    'ira'   => "ഇറാനിയന്‍\ ഭാഷ",
    'iro'   => "ഇറോക്വായിയന്‍\ ഭാഷ",
    'is'    => 'ഐസ്‌ലാന്‍ഡിക്',
    'it'    => 'ഇറ്റാലിയന്‍',
    'iu'    => 'ഇനുക്റ്റിറ്റട്ട്',
    'ja'    => 'ജാപ്പനീസ്',
    'jbo'   => 'ലോജ്ബാന്‍',
    'jpr'   => "ജൂഡിയോ\-പേര്‍ഷ്യന്‍",
    'jrb'   => "ജൂഡിയോ\-അറബിക്",
    'jv'    => 'ജാവാനീസ്',
    'ka'    => 'ജോര്‍ജിയന്‍',
    'kaa'   => "കര\-കാല്‍പ്പക്",
    'kab'   => 'കബൈല്‍',
    'kac'   => 'കാചിന്‍',
    'kaj'   => 'ജ്ജു',
    'kam'   => 'കംബ',
    'kar'   => 'കരേന്‍',
    'kaw'   => 'കാവി',
    'kbd'   => 'കബര്‍ഡിയാന്‍',
    'kcg'   => 'ട്യാപ്',
    'kfo'   => 'കോറോ',
    'kg'    => 'കോംഗോ',
    'kha'   => 'ഘാസി',
    'khi'   => "ഘോയിസന്‍\ ഭാഷ",
    'kho'   => 'ഘോറ്റാനേസേ',
    'ki'    => 'കികൂയു',
    'kj'    => 'ക്വാന്യമ',
    'kk'    => 'കസാഖ്',
    'kl'    => 'കലാല്ലിസട്ട്',
    'km'    => 'കംബോഡിയന്‍',
    'kmb'   => 'ക്ലിംഗന്‍',
    'kn'    => 'കന്നഡ',
    'ko'    => 'കൊറിയന്‍',
    'kok'   => 'കൊങ്കണി',
    'kos'   => 'കൊസറേയന്‍',
    'kpe'   => 'കപെല്ലേ',
    'kr'    => 'കനൂറി',
    'krc'   => "കരചൈ\-ബാല്‍കര്‍",
    'krl'   => 'കരീലിയന്‍',
    'kro'   => 'ക്രു',
    'kru'   => 'കുരുഖ്',
    'ks'    => 'കാശ്മീരി',
    'ku'    => 'കുര്‍ദ്ദിഷ്',
    'kum'   => 'കുമൈക്',
    'kut'   => 'കുതേനൈ',
    'kv'    => 'കോമി',
    'kw'    => 'കോര്‍ണിഷ്',
    'ky'    => 'കിര്‍ഗിസ്',
    'la'    => 'ലാറ്റിന്‍',
    'lad'   => 'ലാഡിനോ',
    'lah'   => 'ലഹ്‌ന്‍ഡ',
    'lam'   => 'ലംബ',
    'lb'    => 'ലക്സംബര്‍ഗിഷ്',
    'lez'   => 'ലഹ്ഗിയാന്‍',
    'lg'    => 'ഗാന്‍ഡ',
    'li'    => 'ലിംബര്‍ഗിഷ്',
    'ln'    => 'ലിംഗാല',
    'lo'    => 'ലാവോ',
    'lol'   => 'മോങ്കോ',
    'loz'   => 'ലോസി',
    'lt'    => 'ലിത്വേനിയന്‍',
    'lu'    => "ലുബ\-കറ്റംഗ",
    'lua'   => "ലൂബ\-ലുലുവ",
    'lui'   => 'ലൂയിസെനോ',
    'lun'   => 'ലുന്‍ഡ',
    'luo'   => 'ലവോ',
    'lus'   => 'ലുഷായി',
    'lv'    => 'ലാത്വിയന്‍',
    'mad'   => 'മദുരേസേ',
    'mag'   => 'മഗാഹി',
    'mai'   => 'മൈഥിലി',
    'mak'   => 'മകാസര്‍',
    'man'   => 'മണ്ഡിന്‍ഗോ',
    'map'   => 'ഓസ്ട്രോനേഷ്യന്‍',
    'mas'   => 'മസൈ',
    'mdf'   => 'മോക്ഷ',
    'mdr'   => 'മണ്ഡാര്‍',
    'men'   => 'മെന്‍ഡെ',
    'mfe'   => 'Morisyen',
    'mg'    => 'മലഗാസി',
    'mga'   => "മദ്ധ്യ\ ഐറിഷ്",
    'mh'    => 'മാര്‍ഷല്ലീസ്',
    'mi'    => 'മൗറി',
    'mic'   => 'മിക്മാക്',
    'min'   => 'മിനാങ്കബൗ',
    'mis'   => 'ഇതരഭാഷ',
    'mk'    => 'മാസിഡോണിയന്‍',
    'mkh'   => "മോണ്‍\-ഖമര്‍\ ഭാഷ",
    'ml'    => 'മലയാളം',
    'mn'    => 'മംഗോളിയന്‍',
    'mnc'   => 'മന്‍ചു',
    'mni'   => 'മണിപ്പൂരി',
    'mno'   => "മനോബോ\ ഭാഷ",
    'mo'    => 'മോള്‍ഡാവിയന്‍',
    'moh'   => 'മോഹാക്',
    'mos'   => 'മൊസ്സി',
    'mr'    => 'മറാഠി',
    'ms'    => 'മലയ',
    'mt'    => 'മാള്‍ട്ടീസ്',
    'mul'   => 'പലഭാഷകള്‍',
    'mun'   => "മുണ്ഡ\ ഭാഷ",
    'mus'   => 'ക്രീക്ക്',
    'mwl'   => 'മിരാന്‍റസേ',
    'mwr'   => 'മര്‍വാരി',
    'my'    => 'ബര്‍മീസ്',
    'myn'   => "മായന്‍\ ഭാഷ",
    'myv'   => 'ഏഴ്സ്യ',
    'na'    => 'നൗറു',
    'nah'   => 'നാഹ്വാള്‍‍ട്ട്',
    'nai'   => "വടക്കേ\ അമേരിക്കന്‍\ ഇന്‍ഡ്യന്‍\ ഭാഷ",
    'nap'   => 'നെപ്പോളിറ്റാന്‍',
    'nb'    => "നോര്‍വീജിയന്‍\ ബുക്‌മല്‍",
    'nd'    => "നോര്‍ത്ത്\ ഡെബിള്‍",
    'nds'   => "ലോ\ ജര്‍മന്‍",
    'ne'    => 'നേപ്പാളി',
    'new'   => 'നേവാരി',
    'ng'    => 'ഡോങ്ക',
    'nia'   => 'നിയാസ്',
    'nic'   => "നൈ‍ജര്‍\-കോര്‍‍ഡോഫാനിയന്‍\ ഭാഷ",
    'niu'   => 'ന്യുവാന്‍',
    'nl'    => 'ഡച്ച്',
    'nl_be' => 'ഫ്ലമിഷ്',
    'nn'    => "നോര്‍വീജിയന്‍\ നൈനോര്‍ക്സ്",
    'no'    => 'നോര്‍വീജിയന്‍',
    'nog'   => 'നോഗൈ',
    'non'   => "പഴയ\ പേര്‍ഷ്യന്‍",
    'nqo'   => 'ഇന്‍കോ',
    'nr'    => "ദക്ഷിണ\ നെഡിബിള്‍",
    'nso'   => "നോര്‍ത്തേന്‍\ സോതോ",
    'nub'   => "നുബിയന്‍\ ഭാഷ",
    'nv'    => 'നവാഹൊ',
    'nwc'   => "ക്ലാസിക്കല്‍\ നേവാരി",
    'ny'    => 'ന്യന്‍ജ',
    'nym'   => 'ന്യാംവേസി',
    'nyn'   => 'ന്യാന്‍കലേ',
    'nyo'   => 'ന്യോറോ',
    'nzi'   => 'സിമ',
    'oc'    => 'ഒക്സിററന്‍',
    'oj'    => 'ഓജിബ്വാ',
    'om'    => 'ഒറോമൂ',
    'or'    => 'ഒറിയ',
    'os'    => 'ഒസ്സെറ്റിക്',
    'osa'   => 'ഒസേജ്',
    'ota'   => "ഓട്ടോമന്‍\ തുര്‍ക്കിഷ്",
    'oto'   => "ഓട്ടോമിയന്‍\ ഭാഷ",
    'pa'    => 'പഞ്ചാബി',
    'paa'   => "പാപുവാന്‍\ ഭാഷ",
    'pag'   => 'പങ്കാസിനന്‍',
    'pal'   => 'പാഹ്ലവി',
    'pam'   => 'പാംപന്‍ഗ',
    'pap'   => 'പാപിയാമെന്‍റൊ',
    'pau'   => 'പലാവുന്‍',
    'peo'   => "പ്രാചീന\ പേര്‍ഷ്യന്‍",
    'phi'   => "ഫിലിപീനി\ ഭാഷ",
    'phn'   => 'ഫീനിഷ്യന്‍',
    'pi'    => 'പാലി',
    'pl'    => 'പോളിഷ്',
    'pon'   => 'പൊന്‍പിയന്‍',
    'pra'   => 'പ്രാകൃതം',
    'pro'   => 'പ്രൊവന്‍ഷ്ല്‍',
    'ps'    => 'പഷ്തു',
    'pt'    => 'പോര്‍ച്ചുഗീസ്',
    'pt_br' => "ബ്രസീലിയന്‍\ പോര്‍ച്ചുഗീസ്",
    'pt_pt' => "ഇബേറിയന്‍\ പോര്‍ച്ചുഗീസ്",
    'qu'    => 'ക്വെച്ചുവ',
    'raj'   => 'രാജസ്ഥാനി',
    'rap'   => 'രാപനൂയി',
    'rar'   => 'രാരോടോങ്കന്‍',
    'rm'    => "രഹയ്ട്ടോ\-റോമന്‍സ്",
    'rn'    => 'റുണ്ടി',
    'ro'    => 'റുമേനിയന്‍',
    'roa'   => "റോമന്‍സ്\ ഭാഷ",
    'rom'   => 'റോമനി',
    'ru'    => 'റഷ്യന്‍',
    'rup'   => 'ആരോമാനിയന്‍',
    'rw'    => 'കിന്യര്‍വണ്ട',
    'sa'    => 'സംസ്കൃതം',
    'sad'   => 'സാന്‍ഡവേ',
    'sah'   => 'യാകൂട്',
    'sai'   => "ദക്ഷിണ\ അമേരിക്കന്‍\ ഇന്‍ഡ്യന്‍\ ഭാഷ",
    'sal'   => "സാലിഷാന്‍\ ഭാഷ",
    'sam'   => "സമരിയാക്കാരുടെ\ അരമായ",
    'sas'   => 'സസാക്',
    'sat'   => 'സന്താലി',
    'sc'    => 'സര്‍ഡിനിയാന്‍',
    'scn'   => 'സിസിലിയന്‍',
    'sco'   => 'സ്കോട്സ്',
    'sd'    => 'സിന്ധി',
    'se'    => "വടക്കന്‍\ സമി",
    'sel'   => 'സെല്‍കപ്',
    'sem'   => "സെമറ്റിക്\ ഭാഷ",
    'sg'    => 'സാങ്കോ',
    'sga'   => "പ്രാചീന\ ഐറിഷ്",
    'sgn'   => 'ആംഗ്യഭാഷ',
    'sh'    => "സെര്‍ബോ\-ക്രൊയേഷ്യന്‍",
    'shn'   => 'ഷാന്‍',
    'si'    => 'സിംഹള',
    'sid'   => 'സിഡാമോ',
    'sio'   => "സിവോന്‍\ ഭാഷ",
    'sit'   => "ചീന\-ടിബത്തന്‍\ ഭാഷ",
    'sk'    => 'സ്ലോവാക്ക്',
    'sl'    => 'സ്ലോവേനിയന്‍',
    'sla'   => "സ്ലേവിക്\ ഭാഷ",
    'sm'    => 'സമോവന്‍',
    'sma'   => "തെക്കന്‍\ സമി",
    'smi'   => "സമി\ ഭാഷ",
    'smj'   => "ലൂലീ\ സമി",
    'smn'   => "ഇനാരി\ സാമി",
    'sms'   => "സ്കോള്‍ട്ട്\ സമി",
    'sn'    => 'ഷോണാ',
    'snk'   => 'സോണിന്‍കെ',
    'so'    => 'സോമാലി',
    'sog'   => 'സോജിഡിയന്‍',
    'son'   => 'സോംഗൈ',
    'sq'    => 'അല്‍ബേനിയന്‍',
    'sr'    => 'സെര്‍ബിയന്‍',
    'srn'   => "ശ്രാനന്‍\ ഡോങ്കോ",
    'srr'   => 'സെറര്‍',
    'ss'    => 'സ്വാറ്റി',
    'ssa'   => "നിളോ\-സഹാറന്‍\ ഭാഷ",
    'st'    => "തെക്കന്‍\ സോതോ",
    'su'    => 'സുഡാനീസ്',
    'suk'   => 'സുകുമ',
    'sus'   => 'സുസു',
    'sux'   => 'സുമേരിയന്‍',
    'sv'    => 'സ്വീഡിഷ്',
    'sw'    => 'സ്വാഹിലി',
    'syc'   => "പുരാതന\ സുറിയാനിഭാഷ",
    'syr'   => 'സുറിയാനി',
    'ta'    => 'തമിഴ്',
    'tai'   => "തായ്\ ഭാഷ",
    'te'    => 'തെലുങ്ക്',
    'tem'   => 'ടിംനേ',
    'ter'   => 'ടെറേനോ',
    'tet'   => 'ടെറ്റും',
    'tg'    => 'താജിക്',
    'th'    => 'തായ്',
    'ti'    => 'ടൈഗ്രിന്യ',
    'tig'   => 'ടൈഗ്രി',
    'tiv'   => 'ടിവ്',
    'tk'    => 'തുര്‍ക്മെന്‍',
    'tkl'   => 'ടൊക്കേലൗ',
    'tl'    => 'തഗാലോഗ്',
    'tlh'   => 'ക്ലിംഗോണ്‍',
    'tli'   => 'ലിംഗ്വിറ്റ്',
    'tmh'   => 'ടമഷേക്',
    'tn'    => 'ത്സ്വാന',
    'to'    => 'ടോംഗ',
    'tog'   => "ന്യാസാ\ ഡോങ്ക",
    'tpi'   => "ടോക്\ പിസിന്‍",
    'tr'    => 'തുര്‍ക്കി',
    'trv'   => 'Taroko',
    'ts'    => 'ത്സോംഗ',
    'tsi'   => 'സിംഷ്യന്‍',
    'tt'    => 'ടാട്ടാര്‍',
    'tum'   => 'തുംബുക',
    'tup'   => "തുപി\ ഭാഷ",
    'tut'   => "അറ്റ്ലാന്‍റിക്ക്\ ഭാഷ",
    'tvl'   => 'തുവാലു',
    'tw'    => 'ട്വി',
    'ty'    => 'താഹിതിയന്‍',
    'tyv'   => 'തുവിനിയന്‍',
    'udm'   => 'ഉഡ്മുര്‍ട്ട്',
    'ug'    => 'ഉയ്ഘുര്‍',
    'uga'   => 'ഉഗറിട്ടിക്',
    'uk'    => 'ഉക്രേനിയന്‍',
    'umb'   => 'ഉംബുന്ദു',
    'und'   => "അറിയാത്തതോ\ നിലവിലില്ലാത്തതോ\ ആയ\ ഭാഷ",
    'ur'    => 'ഉറുദു',
    'uz'    => 'ഉസ്ബെക്',
    'vai'   => 'വൈ',
    've'    => 'വെന്ദ',
    'vi'    => 'വിയറ്റ്നാമീസ്',
    'vo'    => 'വോളാപുക്',
    'vot'   => 'വോട്ടിക്',
    'wa'    => 'വല്ലൂണ്‍',
    'wak'   => "വകഷന്‍\ ഭാഷകള്‍",
    'wal'   => 'വലമൊ',
    'war'   => 'വാരേയ്',
    'was'   => 'വാഷൊ',
    'wen'   => "സോര്‍ബിയന്‍\ ഭാഷ",
    'wo'    => 'വൊളോഫ്',
    'xal'   => 'കല്‍മൈക്',
    'xh'    => 'ഖോസാ',
    'yao'   => 'യാവോ',
    'yap'   => 'യെപ്പീസ്',
    'yi'    => 'യിദ്ദിഷ്',
    'yo'    => 'യൊറൂബാ',
    'ypk'   => 'യുപിക്',
    'za'    => 'സ്വാംഗ്',
    'zap'   => 'സാപ്പോടെക്',
    'zbl'   => 'ബ്ലിസ്സിംബല്‍സ്',
    'zen'   => 'സെനഗ',
    'zh'    => 'ചൈനീസ്',
    'znd'   => 'സാന്ദെ',
    'zu'    => 'സുലു',
    'zun'   => 'സുനി',
    'zxx'   => 'ഭാഷേതരം',
    'zza'   => 'സാസാ',
);

%Locales::DB::Language::ml::name_to_code = (
    'morisyen'                                                                                      => 'mfe',
    'taroko'                                                                                        => 'trv',
    'അകാന്‍'                                                                            => 'ak',
    'അകോലി'                                                                               => 'ach',
    'അക്കാഡിയന്‍'                                                             => 'akk',
    'അചിനീസ്'                                                                         => 'ace',
    'അഡാങ്ഗമി'                                                                      => 'ada',
    'അഡൈഗേ'                                                                               => 'ady',
    'അതപാസ്കന്‍ഭാഷ'                                                       => 'ath',
    'അപ്പര്‍സോര്‍ബിയന്‍'                                        => 'hsb',
    'അപ്പാചേഭാഷ'                                                                => 'apa',
    'അഫാര്‍'                                                                            => 'aa',
    'അബ്ഖാസിയന്‍'                                                             => 'ab',
    'അമാറിക്'                                                                         => 'am',
    'അമേരിക്കന്‍ഇംഗ്ലീഷ്'                                     => 'en_us',
    'അയിനു'                                                                               => 'ain',
    'അയ്മാറ'                                                                            => 'ay',
    'അരഗോണീസ്'                                                                      => 'an',
    'അരപാഹോ'                                                                            => 'arp',
    'അരമായഭാഷ'                                                                      => 'arc',
    'അര്‍മേനിയന്‍'                                                          => 'hy',
    'അറബി'                                                                                  => 'ar',
    'അറാവക്'                                                                            => 'arw',
    'അറിയാത്തതോനിലവിലില്ലാത്തതോആയഭാഷ' => 'und',
    'അറ്റ്ലാന്‍റിക്ക്ഭാഷ'                                     => 'tut',
    'അറ്റ്സാം'                                                                      => 'cch',
    'അലൈട്ട്'                                                                         => 'ale',
    'അല്‍ഗോണ്‍ക്യന്‍ഭാഷ'                                        => 'alg',
    'അല്‍ബേനിയന്‍'                                                          => 'sq',
    'അവധി'                                                                                  => 'awa',
    'അവസ്റ്റാന്‍'                                                             => 'ae',
    'അവാരിക്'                                                                         => 'av',
    'അസര്‍ബൈജാനി'                                                             => 'az',
    'ആംഗ്യഭാഷ'                                                                      => 'sgn',
    'ആന്‍ഗിക'                                                                         => 'anp',
    'ആഫ്രിക്കാന്‍സ്'                                                    => 'af',
    'ആഫ്രിഹിലി'                                                                   => 'afh',
    'ആഫ്രോഏഷ്യാറ്റിക്ഭാഷ'                                     => 'afa',
    'ആരോമാനിയന്‍'                                                             => 'rup',
    'ആരൗകാനിയന്‍'                                                             => 'arn',
    'ആസ്സാമീസ്'                                                                   => 'as',
    'ഇംഗ്ലീഷ്'                                                                      => 'en',
    'ഇംഗ്ലീഷ്അധിഷ്ഠിതമിശ്രഭാഷ'                      => 'cpe',
    'ഇംഗ്വിഷ്'                                                                      => 'inh',
    'ഇഗ്ബോ'                                                                               => 'ig',
    'ഇജോ'                                                                                     => 'ijo',
    'ഇഡോ'                                                                                     => 'io',
    'ഇതരഭാഷ'                                                                            => 'mis',
    'ഇനാരിസാമി'                                                                   => 'smn',
    'ഇനുക്റ്റിറ്റട്ട്'                                              => 'iu',
    'ഇനുപിയാക്'                                                                   => 'ik',
    'ഇന്റര്‍ലിംഗ്വ'                                                       => 'ie',
    'ഇന്‍കോ'                                                                            => 'nqo',
    'ഇന്‍ഡോനേഷ്യന്‍'                                                    => 'id',
    'ഇന്‍ഡോയൂറോപ്യന്‍ഭാഷ'                                     => 'ine',
    'ഇന്‍റര്‍ലിംഗ്വാ'                                                 => 'ia',
    'ഇബാന്‍'                                                                            => 'iba',
    'ഇബേറിയന്‍പോര്‍ച്ചുഗീസ്'                            => 'pt_pt',
    'ഇബേറിയന്‍സ്പാനിഷ്'                                           => 'es_es',
    'ഇറാനിയന്‍ഭാഷ'                                                          => 'ira',
    'ഇറോക്വായിയന്‍ഭാഷ'                                              => 'iro',
    'ഇറ്റാലിയന്‍'                                                             => 'it',
    'ഇലോകോ'                                                                               => 'ilo',
    'ഈസ്റ്റേണ്‍ഫ്രിഷ്യന്‍'                                  => 'frs',
    'ഉംബുന്ദു'                                                                      => 'umb',
    'ഉക്രേനിയന്‍'                                                             => 'uk',
    'ഉഗറിട്ടിക്'                                                                => 'uga',
    'ഉഡ്മുര്‍ട്ട്'                                                          => 'udm',
    'ഉയ്ഘുര്‍'                                                                      => 'ug',
    'ഉറുദു'                                                                               => 'ur',
    'ഉസ്ബെക്'                                                                         => 'uz',
    'എകാജുക്'                                                                         => 'eka',
    'എഫിക്'                                                                               => 'efi',
    'എലാമൈറ്റ്'                                                                   => 'elx',
    'എവോന്‍ഡോ'                                                                      => 'ewo',
    'എവ്'                                                                                     => 'ee',
    'എസ്പരാന്തോ'                                                                => 'eo',
    'എസ്റ്റോണിയന്‍'                                                       => 'et',
    'ഏഴ്സ്യ'                                                                            => 'myv',
    'ഐറിഷ്'                                                                               => 'ga',
    'ഐസ്‌ലാന്‍ഡിക്'                                                       => 'is',
    'ഒക്സിററന്‍'                                                                => 'oc',
    'ഒറിയ'                                                                                  => 'or',
    'ഒറോമൂ'                                                                               => 'om',
    'ഒസേജ്'                                                                               => 'osa',
    'ഒസ്സെറ്റിക്'                                                             => 'os',
    'ഓജിബ്വാ'                                                                         => 'oj',
    'ഓട്ടോമന്‍തുര്‍ക്കിഷ്'                                  => 'ota',
    'ഓട്ടോമിയന്‍ഭാഷ'                                                    => 'oto',
    'ഓസ്ട്രിയന്‍ജര്‍മന്‍'                                     => 'de_at',
    'ഓസ്ട്രേലിയന്‍ഇംഗ്ലീഷ്'                               => 'en_au',
    'ഓസ്ട്രേലിയന്‍ഭാഷ'                                              => 'aus',
    'ഓസ്ട്രോനേഷ്യന്‍'                                                 => 'map',
    'ഓസ്‌ട്രിയന്‍'                                                          => 'ast',
    'കംബ'                                                                                     => 'kam',
    'കംബോഡിയന്‍'                                                                => 'km',
    'കനൂറി'                                                                               => 'kr',
    'കനേഡിയന്‍ഇംഗ്ലീഷ്'                                           => 'en_ca',
    'കനേഡിയന്‍ഫ്രഞ്ച്'                                              => 'fr_ca',
    'കന്നഡ'                                                                               => 'kn',
    'കപെല്ലേ'                                                                         => 'kpe',
    'കബര്‍ഡിയാന്‍'                                                          => 'kbd',
    'കബൈല്‍'                                                                            => 'kab',
    'കമോറോ'                                                                               => 'ch',
    'കരകാല്‍പ്പക്'                                                          => 'kaa',
    'കരചൈബാല്‍കര്‍'                                                       => 'krc',
    'കരീലിയന്‍'                                                                   => 'krl',
    'കരേന്‍'                                                                            => 'kar',
    'കറ്റാലന്‍'                                                                   => 'ca',
    'കലാല്ലിസട്ട്'                                                          => 'kl',
    'കല്‍മൈക്'                                                                      => 'xal',
    'കസാഖ്'                                                                               => 'kk',
    'കാചിന്‍'                                                                         => 'kac',
    'കാഡോ'                                                                                  => 'cad',
    'കാരിബ്'                                                                            => 'car',
    'കാവി'                                                                                  => 'kaw',
    'കാശ്മീരി'                                                                      => 'ks',
    'കാഷുബിയാന്‍'                                                             => 'csb',
    'കികൂയു'                                                                            => 'ki',
    'കിന്യര്‍വണ്ട'                                                          => 'rw',
    'കിര്‍ഗിസ്'                                                                   => 'ky',
    'കുതേനൈ'                                                                            => 'kut',
    'കുമൈക്'                                                                            => 'kum',
    'കുരുഖ്'                                                                            => 'kru',
    'കുര്‍ദ്ദിഷ്'                                                             => 'ku',
    'കുഷിറ്റിക്ഭാഷ'                                                       => 'cus',
    'കൃത്രിമഭാഷ'                                                                => 'art',
    'കൊക്കേഷ്യന്‍ഭാഷ'                                                 => 'cau',
    'കൊങ്കണി'                                                                         => 'kok',
    'കൊറിയന്‍'                                                                      => 'ko',
    'കൊസറേയന്‍'                                                                   => 'kos',
    'കോംഗോ'                                                                               => 'kg',
    'കോപ്റ്റിക്'                                                                => 'cop',
    'കോമി'                                                                                  => 'kv',
    'കോര്‍ണിഷ്'                                                                   => 'kw',
    'കോറോ'                                                                                  => 'kfo',
    'കോഴ്സിക്കണ്‍'                                                          => 'co',
    'ക്രിമിയന്‍ടര്‍ക്കിഷ്'                                  => 'crh',
    'ക്രീ'                                                                                  => 'cr',
    'ക്രീക്ക്'                                                                      => 'mus',
    'ക്രു'                                                                                  => 'kro',
    'ക്രൊയേഷ്യന്‍'                                                          => 'hr',
    'ക്ലാസിക്കല്‍നേവാരി'                                        => 'nwc',
    'ക്ലിംഗന്‍'                                                                   => 'kmb',
    'ക്ലിംഗോണ്‍'                                                                => 'tlh',
    'ക്വാന്യമ'                                                                      => 'kj',
    'ക്വെച്ചുവ'                                                                   => 'qu',
    'ഖോസാ'                                                                                  => 'xh',
    'ഗബ്യ'                                                                                  => 'gba',
    'ഗയൊ'                                                                                     => 'gay',
    'ഗലീഷ്യന്‍'                                                                   => 'gl',
    'ഗാ'                                                                                        => 'gaa',
    'ഗാന്‍ഡ'                                                                            => 'lg',
    'ഗില്‍ബര്‍സേ'                                                             => 'gil',
    'ഗീസ്'                                                                                  => 'gez',
    'ഗുജറാത്തി'                                                                   => 'gu',
    'ഗൊറോന്‍റാലോ'                                                             => 'gor',
    'ഗോണ്ഡി'                                                                            => 'gon',
    'ഗോഥിക്ക്'                                                                      => 'got',
    'ഗ്രബൊ'                                                                               => 'grb',
    'ഗ്രീക്ക്'                                                                      => 'el',
    'ഗ്വാറാനി'                                                                      => 'gn',
    'ഗ്വിച്ച്ഇന്‍'                                                          => 'gwi',
    'ഘാസി'                                                                                  => 'kha',
    'ഘോയിസന്‍ഭാഷ'                                                             => 'khi',
    'ഘോറ്റാനേസേ'                                                                => 'kho',
    'ചഗതൈ'                                                                                  => 'chg',
    'ചര്‍ച്ച്സ്ലാവിക്'                                              => 'cu',
    'ചാമിക്ഭാഷ'                                                                   => 'cmc',
    'ചിനൂഗ്ജാര്‍ഗണ്‍'                                                 => 'chn',
    'ചിപേവ്യന്‍'                                                                => 'chp',
    'ചിബ്ച'                                                                               => 'chb',
    'ചിയേന്നേ'                                                                      => 'chy',
    'ചീനടിബത്തന്‍ഭാഷ'                                                 => 'sit',
    'ചുവാഷ്'                                                                            => 'cv',
    'ചൂകീസ്'                                                                            => 'chk',
    'ചെക്ക്'                                                                            => 'cs',
    'ചെചന്‍'                                                                            => 'ce',
    'ചെരോകീ'                                                                            => 'chr',
    'ചൈനീസ്'                                                                            => 'zh',
    'ചോക്റ്റാവ്'                                                                => 'cho',
    'ജര്‍മാനിക്ഭാഷ'                                                       => 'gem',
    'ജര്‍മ്മന്‍'                                                                => 'de',
    'ജാപ്പനീസ്'                                                                   => 'ja',
    'ജാവാനീസ്'                                                                      => 'jv',
    'ജൂഡിയോഅറബിക്'                                                          => 'jrb',
    'ജൂഡിയോപേര്‍ഷ്യന്‍'                                           => 'jpr',
    'ജോര്‍ജിയന്‍'                                                             => 'ka',
    'ജ്ജു'                                                                                  => 'kaj',
    'ടമഷേക്'                                                                            => 'tmh',
    'ടാട്ടാര്‍'                                                                   => 'tt',
    'ടിംനേ'                                                                               => 'tem',
    'ടിവ്'                                                                                  => 'tiv',
    'ടെറേനോ'                                                                            => 'ter',
    'ടെറ്റും'                                                                         => 'tet',
    'ടൈഗ്രി'                                                                            => 'tig',
    'ടൈഗ്രിന്യ'                                                                   => 'ti',
    'ടൊക്കേലൗ'                                                                      => 'tkl',
    'ടോംഗ'                                                                                  => 'to',
    'ടോക്പിസിന്‍'                                                             => 'tpi',
    'ട്യാപ്'                                                                            => 'kcg',
    'ട്വി'                                                                                  => 'tw',
    'ഡകോട്ട'                                                                            => 'dak',
    'ഡച്ച്'                                                                               => 'nl',
    'ഡര്‍ഗ്വാ'                                                                      => 'dar',
    'ഡാനിഷ്'                                                                            => 'da',
    'ഡോഗ്രി'                                                                            => 'doi',
    'ഡോഗ്രിബ്'                                                                      => 'dgr',
    'ഡോങ്ക'                                                                               => 'ng',
    'തഗാലോഗ്'                                                                         => 'tl',
    'തമിഴ്'                                                                               => 'ta',
    'താജിക്'                                                                            => 'tg',
    'തായ്'                                                                                  => 'th',
    'തായ്ഭാഷ'                                                                         => 'tai',
    'താഹിതിയന്‍'                                                                => 'ty',
    'തിബറ്റന്‍'                                                                   => 'bo',
    'തുംബുക'                                                                            => 'tum',
    'തുപിഭാഷ'                                                                         => 'tup',
    'തുര്‍ക്കി'                                                                   => 'tr',
    'തുര്‍ക്മെന്‍'                                                          => 'tk',
    'തുവാലു'                                                                            => 'tvl',
    'തുവിനിയന്‍'                                                                => 'tyv',
    'തെക്കന്‍അള്‍ട്ടായി'                                        => 'alt',
    'തെക്കന്‍സമി'                                                             => 'sma',
    'തെക്കന്‍സോതോ'                                                          => 'st',
    'തെലുങ്ക്'                                                                      => 'te',
    'ത്സോംഗ'                                                                            => 'ts',
    'ത്സ്വാന'                                                                         => 'tn',
    'ദക്ഷിണഅമേരിക്കന്‍ഇന്‍ഡ്യന്‍ഭാഷ'    => 'sai',
    'ദക്ഷിണനെഡിബിള്‍'                                                 => 'nr',
    'ദയാക്'                                                                               => 'day',
    'ദലവാരെ'                                                                            => 'del',
    'ദിന്‍ക'                                                                            => 'din',
    'ദിവെഹി'                                                                            => 'dv',
    'ദ്രാവിഡഭാഷ'                                                                => 'dra',
    'ദ്വാല'                                                                               => 'dua',
    'ദ്വൈല'                                                                               => 'dyu',
    'നവാഹൊ'                                                                               => 'nv',
    'നാഹ്വാള്‍‍ട്ട്'                                                    => 'nah',
    'നിയാസ്'                                                                            => 'nia',
    'നിളോസഹാറന്‍ഭാഷ'                                                    => 'ssa',
    'നുബിയന്‍ഭാഷ'                                                             => 'nub',
    'നെപ്പോളിറ്റാന്‍'                                                 => 'nap',
    'നേപ്പാളി'                                                                      => 'ne',
    'നേവാരി'                                                                            => 'new',
    'നൈ‍ജര്‍കോര്‍‍ഡോഫാനിയന്‍ഭാഷ'                => 'nic',
    'നോഗൈ'                                                                                  => 'nog',
    'നോര്‍ത്തേന്‍ഫ്രിഷ്യന്‍'                            => 'frr',
    'നോര്‍ത്തേന്‍സോതോ'                                              => 'nso',
    'നോര്‍ത്ത്ഡെബിള്‍'                                              => 'nd',
    'നോര്‍വീജിയന്‍'                                                       => 'no',
    'നോര്‍വീജിയന്‍നൈനോര്‍ക്സ്'                      => 'nn',
    'നോര്‍വീജിയന്‍ബുക്‌മല്‍'                            => 'nb',
    'ന്യന്‍ജ'                                                                         => 'ny',
    'ന്യാംവേസി'                                                                   => 'nym',
    'ന്യാന്‍കലേ'                                                                => 'nyn',
    'ന്യാസാഡോങ്ക'                                                             => 'tog',
    'ന്യുവാന്‍'                                                                   => 'niu',
    'ന്യോറോ'                                                                            => 'nyo',
    'നൗറു'                                                                                  => 'na',
    'പങ്കാസിനന്‍'                                                             => 'pag',
    'പഞ്ചാബി'                                                                         => 'pa',
    'പലഭാഷകള്‍'                                                                   => 'mul',
    'പലാവുന്‍'                                                                      => 'pau',
    'പഴയഇംഗ്ലീഷ്'                                                             => 'ang',
    'പഴയപേര്‍ഷ്യന്‍'                                                    => 'non',
    'പഴയഫ്രഞ്ച്'                                                                => 'fro',
    'പശ്ചിമഫ്രിഷിയന്‍'                                              => 'fy',
    'പഷ്തു'                                                                               => 'ps',
    'പാംപന്‍ഗ'                                                                      => 'pam',
    'പാപിയാമെന്‍റൊ'                                                       => 'pap',
    'പാപുവാന്‍ഭാഷ'                                                          => 'paa',
    'പാലി'                                                                                  => 'pi',
    'പാഹ്ലവി'                                                                         => 'pal',
    'പുരാതനയവനഭാഷ'                                                          => 'grc',
    'പുരാതനസുറിയാനിഭാഷ'                                           => 'syc',
    'പേര്‍ഷ്യന്‍'                                                             => 'fa',
    'പൊന്‍പിയന്‍'                                                             => 'pon',
    'പോര്‍ച്ചുഗീസ്'                                                       => 'pt',
    'പോര്‍ച്ചുഗീസ്അധിഷ്ഠിതമിശ്രഭാഷ'       => 'cpp',
    'പോളിഷ്'                                                                            => 'pl',
    'പ്രാകൃതം'                                                                      => 'pra',
    'പ്രാചീനഈജിപ്ഷ്യന്‍'                                        => 'egy',
    'പ്രാചീനഉച്ചജര്‍മന്‍'                                     => 'goh',
    'പ്രാചീനഐറിഷ്'                                                          => 'sga',
    'പ്രാചീനപേര്‍ഷ്യന്‍'                                        => 'peo',
    'പ്രൊവന്‍ഷ്ല്‍'                                                       => 'pro',
    'ഫങ്'                                                                                     => 'fan',
    'ഫാറോസ്'                                                                            => 'fo',
    'ഫിജിയന്‍'                                                                      => 'fj',
    'ഫിന്നിഷ്'                                                                      => 'fi',
    'ഫിന്നോഉഗ്രിയന്‍ഭാഷ'                                        => 'fiu',
    'ഫിലിപീനിഭാഷ'                                                             => 'phi',
    'ഫിലിപ്പിനോ'                                                                => 'fil',
    'ഫിലിപ്പീനോ'                                                                => 'fat',
    'ഫീനിഷ്യന്‍'                                                                => 'phn',
    'ഫുല'                                                                                     => 'ff',
    'ഫോന്‍'                                                                               => 'fon',
    'ഫ്രഞ്ച്'                                                                         => 'fr',
    'ഫ്രഞ്ച്അധിഷ്ഠിതമിശ്രഭാഷ'                         => 'cpf',
    'ഫ്രിയുലിയാന്‍'                                                       => 'fur',
    'ഫ്ലമിഷ്'                                                                         => 'nl_be',
    'ബംഗാളി'                                                                            => 'bn',
    'ബംബാറ'                                                                               => 'bm',
    'ബന്‍ഡ'                                                                               => 'bad',
    'ബര്‍മീസ്'                                                                      => 'my',
    'ബലൂചി'                                                                               => 'bal',
    'ബള്‍ഗേറിയന്‍'                                                          => 'bg',
    'ബഷ്ഖിര്‍'                                                                      => 'ba',
    'ബസ'                                                                                        => 'bas',
    'ബാന്‌ടു'                                                                         => 'bnt',
    'ബാമിലകേഭാഷ'                                                                => 'bai',
    'ബാറ്റക്'                                                                         => 'btk',
    'ബാലിനീസ്'                                                                      => 'ban',
    'ബാള്‍ട്ടിക്ഭാഷ'                                                    => 'bat',
    'ബാസ്ക്'                                                                            => 'eu',
    'ബികോല്‍'                                                                         => 'bik',
    'ബിനി'                                                                                  => 'bin',
    'ബിസ്‌ലാമ'                                                                      => 'bi',
    'ബീഹാറി'                                                                            => 'bh',
    'ബുഗിനീസ്'                                                                      => 'bug',
    'ബുറിയത്ത്'                                                                   => 'bua',
    'ബെംബ'                                                                                  => 'bem',
    'ബെര്‍ബര്‍'                                                                   => 'ber',
    'ബേജ'                                                                                     => 'bej',
    'ബൈലോറഷ്യന്‍'                                                             => 'be',
    'ബോസ്നിയന്‍'                                                                => 'bs',
    'ബ്രജ്'                                                                               => 'bra',
    'ബ്രറ്റണ്‍'                                                                   => 'br',
    'ബ്രസീലിയന്‍പോര്‍ച്ചുഗീസ്'                      => 'pt_br',
    'ബ്രിട്ടീഷ്ഇംഗ്ലീഷ്'                                        => 'en_gb',
    'ബ്ലിന്‍'                                                                         => 'byn',
    'ബ്ലിസ്സിംബല്‍സ്'                                                 => 'zbl',
    'ഭാരതീയഭാഷ'                                                                   => 'inc',
    'ഭാഷേതരം'                                                                         => 'zxx',
    'ഭൂട്ടാനി'                                                                      => 'dz',
    'ഭോജ്‌പൂരി'                                                                   => 'bho',
    'മംഗോളിയന്‍'                                                                => 'mn',
    'മകാസര്‍'                                                                         => 'mak',
    'മഗാഹി'                                                                               => 'mag',
    'മണിപ്പൂരി'                                                                   => 'mni',
    'മണ്ഡാര്‍'                                                                      => 'mdr',
    'മണ്ഡിന്‍ഗോ'                                                                => 'man',
    'മദുരേസേ'                                                                         => 'mad',
    'മദ്ധ്യഅമേരിക്കന്‍ഇന്‍ഡ്യന്‍ഭാഷ'    => 'cai',
    'മദ്ധ്യഇംഗ്ലീഷ്'                                                    => 'enm',
    'മദ്ധ്യഉച്ചജര്‍മന്‍'                                        => 'gmh',
    'മദ്ധ്യഐറിഷ്'                                                             => 'mga',
    'മദ്ധ്യഡച്ച്'                                                             => 'dum',
    'മദ്ധ്യഫ്രഞ്ച്'                                                       => 'frm',
    'മനോബോഭാഷ'                                                                      => 'mno',
    'മന്‍ചു'                                                                            => 'mnc',
    'മര്‍വാരി'                                                                      => 'mwr',
    'മറാഠി'                                                                               => 'mr',
    'മലഗാസി'                                                                            => 'mg',
    'മലയ'                                                                                     => 'ms',
    'മലയാളം'                                                                            => 'ml',
    'മസൈ'                                                                                     => 'mas',
    'മാന്‍സ്'                                                                         => 'gv',
    'മായന്‍ഭാഷ'                                                                   => 'myn',
    'മാരി'                                                                                  => 'chm',
    'മാര്‍ഷല്ലീസ്'                                                          => 'mh',
    'മാള്‍ട്ടീസ്'                                                             => 'mt',
    'മാസിഡോണിയന്‍'                                                          => 'mk',
    'മിക്മാക്'                                                                      => 'mic',
    'മിനാങ്കബൗ'                                                                   => 'min',
    'മിരാന്‍റസേ'                                                                => 'mwl',
    'മിശ്രഭാഷ'                                                                      => 'crp',
    'മുണ്ഡഭാഷ'                                                                      => 'mun',
    'മെന്‍ഡെ'                                                                         => 'men',
    'മൈഥിലി'                                                                            => 'mai',
    'മൊസ്സി'                                                                            => 'mos',
    'മോക്ഷ'                                                                               => 'mdf',
    'മോങ്'                                                                                  => 'hmn',
    'മോങ്കോ'                                                                            => 'lol',
    'മോണ്‍ഖമര്‍ഭാഷ'                                                       => 'mkh',
    'മോള്‍ഡാവിയന്‍'                                                       => 'mo',
    'മോഹാക്'                                                                            => 'moh',
    'മൗറി'                                                                                  => 'mi',
    'യാകൂട്'                                                                            => 'sah',
    'യാവോ'                                                                                  => 'yao',
    'യിദ്ദിഷ്'                                                                      => 'yi',
    'യുപിക്'                                                                            => 'ypk',
    'യെപ്പീസ്'                                                                      => 'yap',
    'യൊറൂബാ'                                                                            => 'yo',
    'രഹയ്ട്ടോറോമന്‍സ്'                                              => 'rm',
    'രാജസ്ഥാനി'                                                                   => 'raj',
    'രാപനൂയി'                                                                         => 'rap',
    'രാരോടോങ്കന്‍'                                                          => 'rar',
    'റഷ്യന്‍'                                                                         => 'ru',
    'റുണ്ടി'                                                                            => 'rn',
    'റുമേനിയന്‍'                                                                => 'ro',
    'റോമനി'                                                                               => 'rom',
    'റോമന്‍സ്ഭാഷ'                                                             => 'roa',
    'ലംബ'                                                                                     => 'lam',
    'ലക്സംബര്‍ഗിഷ്'                                                       => 'lb',
    'ലവോ'                                                                                     => 'luo',
    'ലഹ്ഗിയാന്‍'                                                                => 'lez',
    'ലഹ്‌ന്‍ഡ'                                                                      => 'lah',
    'ലാഡിനോ'                                                                            => 'lad',
    'ലാത്വിയന്‍'                                                                => 'lv',
    'ലാറ്റിന്‍'                                                                   => 'la',
    'ലാവോ'                                                                                  => 'lo',
    'ലിംഗാല'                                                                            => 'ln',
    'ലിംഗ്വിറ്റ്'                                                             => 'tli',
    'ലിംബര്‍ഗിഷ്'                                                             => 'li',
    'ലിത്വേനിയന്‍'                                                          => 'lt',
    'ലുന്‍ഡ'                                                                            => 'lun',
    'ലുബകറ്റംഗ'                                                                   => 'lu',
    'ലുഷായി'                                                                            => 'lus',
    'ലൂബലുലുവ'                                                                      => 'lua',
    'ലൂയിസെനോ'                                                                      => 'lui',
    'ലൂലീസമി'                                                                         => 'smj',
    'ലോജര്‍മന്‍'                                                                => 'nds',
    'ലോജ്ബാന്‍'                                                                   => 'jbo',
    'ലോവര്‍സോര്‍ബിയന്‍'                                           => 'dsb',
    'ലോസി'                                                                                  => 'loz',
    'വകഷന്‍ഭാഷകള്‍'                                                       => 'wak',
    'വടക്കന്‍സമി'                                                             => 'se',
    'വടക്കേഅമേരിക്കന്‍ഇന്‍ഡ്യന്‍ഭാഷ'    => 'nai',
    'വലമൊ'                                                                                  => 'wal',
    'വല്ലൂണ്‍'                                                                      => 'wa',
    'വാരേയ്'                                                                            => 'war',
    'വാഷൊ'                                                                                  => 'was',
    'വിയറ്റ്നാമീസ്'                                                       => 'vi',
    'വെന്ദ'                                                                               => 've',
    'വെല്‍ഷ്'                                                                         => 'cy',
    'വൈ'                                                                                        => 'vai',
    'വൊളോഫ്'                                                                            => 'wo',
    'വോട്ടിക്'                                                                      => 'vot',
    'വോളാപുക്'                                                                      => 'vo',
    'ശ്രാനന്‍ഡോങ്കോ'                                                    => 'srn',
    'ഷാന്‍'                                                                               => 'shn',
    'ഷുവാന്‍യി'                                                                   => 'ii',
    'ഷോണാ'                                                                                  => 'sn',
    'സംസ്കൃതം'                                                                      => 'sa',
    'സന്താലി'                                                                         => 'sat',
    'സമരിയാക്കാരുടെഅരമായ'                                     => 'sam',
    'സമിഭാഷ'                                                                            => 'smi',
    'സമോവന്‍'                                                                         => 'sm',
    'സര്‍ഡിനിയാന്‍'                                                       => 'sc',
    'സസാക്'                                                                               => 'sas',
    'സാങ്കോ'                                                                            => 'sg',
    'സാന്ദെ'                                                                            => 'znd',
    'സാന്‍ഡവേ'                                                                      => 'sad',
    'സാപ്പോടെക്'                                                                => 'zap',
    'സാലിഷാന്‍ഭാഷ'                                                          => 'sal',
    'സാസാ'                                                                                  => 'zza',
    'സിംഷ്യന്‍'                                                                   => 'tsi',
    'സിംഹള'                                                                               => 'si',
    'സിക്സിക'                                                                         => 'bla',
    'സിഡാമോ'                                                                            => 'sid',
    'സിന്ധി'                                                                            => 'sd',
    'സിമ'                                                                                     => 'nzi',
    'സിവോന്‍ഭാഷ'                                                                => 'sio',
    'സിസിലിയന്‍'                                                                => 'scn',
    'സുകുമ'                                                                               => 'suk',
    'സുഡാനീസ്'                                                                      => 'su',
    'സുനി'                                                                                  => 'zun',
    'സുമേരിയന്‍'                                                                => 'sux',
    'സുറിയാനി'                                                                      => 'syr',
    'സുലു'                                                                                  => 'zu',
    'സുസു'                                                                                  => 'sus',
    'സെനഗ'                                                                                  => 'zen',
    'സെബുവാനോ'                                                                      => 'ceb',
    'സെമറ്റിക്ഭാഷ'                                                          => 'sem',
    'സെര്‍ബിയന്‍'                                                             => 'sr',
    'സെര്‍ബോക്രൊയേഷ്യന്‍'                                     => 'sh',
    'സെറര്‍'                                                                            => 'srr',
    'സെല്‍കപ്'                                                                      => 'sel',
    'സെല്‍റ്റിക്ഭാഷ'                                                    => 'cel',
    'സോംഗൈ'                                                                               => 'son',
    'സോജിഡിയന്‍'                                                                => 'sog',
    'സോണിന്‍കെ'                                                                   => 'snk',
    'സോമാലി'                                                                            => 'so',
    'സോര്‍ബിയന്‍ഭാഷ'                                                    => 'wen',
    'സ്കോട്ടിഷ്ഗൈലിക്'                                              => 'gd',
    'സ്കോട്സ്'                                                                      => 'sco',
    'സ്കോള്‍ട്ട്സമി'                                                    => 'sms',
    'സ്പാനിഷ്'                                                                      => 'es',
    'സ്ലേവിക്ഭാഷ'                                                             => 'sla',
    'സ്ലേവ്'                                                                            => 'den',
    'സ്ലോവാക്ക്'                                                                => 'sk',
    'സ്ലോവേനിയന്‍'                                                          => 'sl',
    'സ്വാംഗ്'                                                                         => 'za',
    'സ്വാറ്റി'                                                                      => 'ss',
    'സ്വാഹിലി'                                                                      => 'sw',
    'സ്വിസ്ഉച്ചജര്‍മന്‍'                                        => 'de_ch',
    'സ്വിസ്ജര്‍മന്‍'                                                    => 'gsw',
    'സ്വിസ്ഫ്രഞ്ച്'                                                       => 'fr_ch',
    'സ്വീഡിഷ്'                                                                      => 'sv',
    'ഹംഗേറിയന്‍'                                                                => 'hu',
    'ഹവായിയന്‍'                                                                   => 'haw',
    'ഹിന്ദി'                                                                            => 'hi',
    'ഹിമാചലി'                                                                         => 'him',
    'ഹിരിമോതു'                                                                      => 'ho',
    'ഹിറ്റൈറ്റേ'                                                                => 'hit',
    'ഹിലിഗയ്നോണ്‍'                                                          => 'hil',
    'ഹീബ്രു'                                                                            => 'he',
    'ഹൂപ'                                                                                     => 'hup',
    'ഹെയ്തിയന്‍'                                                                => 'ht',
    'ഹെരേരൊ'                                                                            => 'hz',
    'ഹൈഡ'                                                                                     => 'hai',
    'ഹൗസ'                                                                                     => 'ha',
);

1;
