/*  $Id: lesson.h,v 1.16 2005/02/07 22:12:51 marcusva Exp $ 
 * 
 *  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2004 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef LING_LESSON_H
#define LING_LESSON_H 1

#include <libxml/xpath.h>
#include "lingdefs.h" 

/*
 * lesson_data, lessonData:
 * 
 * stores the available lesson files
 *
 * xmlDocPtr lesson_file is created by xmlParseFile,
 * number is automatically increased
 * meanings is automatically fetched from the file 
 * next points to the next struct containing the next lesson
 * prev points to the previous struct containing the next lesson
 *
 */

typedef struct
{
     xmlDocPtr           lesson;   /* the xmlDocPtr for parsing, etc. */
     xmlXPathContextPtr  x_path;   /* the xmlXPathContextPtr for the lesson */ 
     lingchar           *path;     /* path to the lesson file */
} lessonData;

/*
 * returns a xmlXPathContextPtr of the given xmlDocPtr
 */
xmlXPathContextPtr
lesson_get_xpath (xmlDocPtr doc);

/*
 * creates a new empty lessonData 
 */
lessonData*
lesson_data_new (void);

/* 
 * returns the last lesson from the list of used ones
 */
lingLesson*
lesson_get_last (lingLesson *lesson);

/*
 * creates and returns the lesson data for a file
 */
void*
lesson_create_lesson_data (char *filename, lingConfig *settings);

/*
 * frees all memory hold by the passed lessonData, including the lessonData
 * itself
 */
void
lesson_free_lesson_data (lessonData *data);

/*
 * returns a random lesson from the lesson list, which was passed
 */
lingLesson*
lesson_return_rand_lesson (lingLesson *lesson);

/*
 * saves the passed lesson into the passed file
 */
lingbool
lesson_save_lesson (lingLesson *lesson, char *filename);

#endif /* LING_LESSON_H */
