/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team 
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <string.h>
#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "lingoteach.h"
#include "conf.h"

/*********************
 * private functions *
 *********************/


/********************
 * public functions *
 ********************/

/**
 * Creates a new, empty lingConfig for usage.
 * The lingConfig has to be freed by the user.
 *
 * \return A new lingConfig.
 */
lingConfig*
ling_conf_init_config (void)
{
  lingConfig *settings = malloc (sizeof (lingConfig));

  if (settings == NULL)
    return NULL;
  else 
    {
      settings->appname  = NULL;
      settings->langfile = NULL;
    }
  return settings;
}

/**
 * Sets the application name in a lingConfig.
 *
 * \param settings The settings to modify.
 * \param name The name of the application, which uses the library.
 * \return the modified settings, if the name could be applied to them.
 */
lingConfig*
ling_conf_set_app_name (lingConfig *settings, lingchar *name)
{
  if (settings == NULL || name == NULL)
    return NULL;
  
  if (settings->appname != NULL)
    free(settings->appname);
  
  settings->appname = malloc (strlen (name) + 1);
  if (settings->appname == NULL)
    {
      free (settings);
      return NULL;
    }
  
  strncpy (settings->appname, name, strlen (name) + 1);
  return settings;
}

/**
 * Sets the full qualified path to the language file in a lingConfig.
 *
 * \param settings The settings to modify.
 * \param lfile The file, which contains the languages.
 * \return The modifed settings, if the language file could be applied to them.
 */
lingConfig*
ling_conf_set_lang_file (lingConfig *settings, lingchar* lfile)
{
  if (settings == NULL || lfile == NULL)
    return NULL;

  if (settings->langfile != NULL)
    free (settings->langfile);
  
  settings->langfile = malloc (strlen (lfile) + 1);
  if (settings->langfile == NULL)
    {
      free (settings);
      return NULL;
    }
    
  strncpy (settings->langfile, lfile, strlen (lfile) + 1);
  return settings;
}
