/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.svg;

import de.erichseifert.vectorgraphics2d.GraphicsState;
import de.erichseifert.vectorgraphics2d.SizedDocument;
import de.erichseifert.vectorgraphics2d.VectorHints;
import de.erichseifert.vectorgraphics2d.intermediate.CommandSequence;
import de.erichseifert.vectorgraphics2d.intermediate.commands.AffineTransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.Command;
import de.erichseifert.vectorgraphics2d.intermediate.commands.CreateCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DisposeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawImageCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawShapeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawStringCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.FillShapeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.Group;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetBackgroundCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetClipCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetColorCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetCompositeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetFontCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetHintCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetPaintCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetStrokeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetTransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.StateCommand;
import de.erichseifert.vectorgraphics2d.util.Base64EncodeStream;
import de.erichseifert.vectorgraphics2d.util.DataUtils;
import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import de.erichseifert.vectorgraphics2d.util.PageSize;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class SVGDocument
extends SizedDocument {
    private static final String SVG_DOCTYPE_QNAME = "svg";
    private static final String SVG_DOCTYPE_PUBLIC_ID = "-//W3C//DTD SVG 1.1//EN";
    private static final String SVG_DOCTYPE_SYSTEM_ID = "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd";
    private static final String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    private static final String XLINK_NAMESPACE = "xlink";
    private static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    private static final String PREFIX_CLIP = "clip";
    private static final double DPI = 72.0;
    private static final double PX_PER_MM = 2.834645669291339;
    private static final String CHARSET = "UTF-8";
    private final Stack<GraphicsState> states = new Stack();
    private final Document doc;
    private final Element root;
    private Element group;
    private boolean groupAdded;
    private Element defs;
    private final Map<Integer, Element> clippingPathElements;
    private static final Map<Integer, String> STROKE_ENDCAPS = DataUtils.map(new Integer[]{0, 1, 2}, new String[]{"butt", "round", "square"});
    private static final Map<Integer, String> STROKE_LINEJOIN = DataUtils.map(new Integer[]{0, 1, 2}, new String[]{"miter", "round", "bevel"});

    public SVGDocument(CommandSequence commandSequence, PageSize pageSize) {
        super(pageSize, true);
        DocumentBuilder documentBuilder;
        this.states.push(new GraphicsState());
        this.clippingPathElements = new HashMap<Integer, Element>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException("Could not create XML builder.");
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(SVG_DOCTYPE_QNAME, SVG_DOCTYPE_PUBLIC_ID, SVG_DOCTYPE_SYSTEM_ID);
        this.doc = dOMImplementation.createDocument(SVG_NAMESPACE_URI, SVG_DOCTYPE_QNAME, documentType);
        try {
            this.doc.setXmlStandalone(false);
        }
        catch (AbstractMethodError abstractMethodError) {
            System.err.println("Your XML parser does not support standalone XML documents.");
        }
        this.root = this.doc.getDocumentElement();
        this.initRoot();
        this.group = this.root;
        for (Command command : commandSequence) {
            this.handle(command);
        }
    }

    private GraphicsState getCurrentState() {
        return this.states.peek();
    }

    private void initRoot() {
        double d = this.getPageSize().getX();
        double d2 = this.getPageSize().getY();
        double d3 = this.getPageSize().getWidth();
        double d4 = this.getPageSize().getHeight();
        this.root.setAttribute("xmlns:xlink", XLINK_NAMESPACE_URI);
        this.root.setAttribute("version", "1.1");
        this.root.setAttribute("x", DataUtils.format(d / 2.834645669291339) + "mm");
        this.root.setAttribute("y", DataUtils.format(d2 / 2.834645669291339) + "mm");
        this.root.setAttribute("width", DataUtils.format(d3 / 2.834645669291339) + "mm");
        this.root.setAttribute("height", DataUtils.format(d4 / 2.834645669291339) + "mm");
        this.root.setAttribute("viewBox", DataUtils.join(" ", new double[]{d, d2, d3, d4}));
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "no");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("encoding", CHARSET);
            transformer.setOutputProperty("doctype-public", this.doc.getDoctype().getPublicId());
            transformer.setOutputProperty("doctype-system", this.doc.getDoctype().getSystemId());
            transformer.transform(new DOMSource(this.doc), new StreamResult(outputStream));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException(transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.getMessage());
        }
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeTo(byteArrayOutputStream);
            return byteArrayOutputStream.toString(CHARSET);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private void newGroup() {
        Object object;
        this.group = this.doc.createElement("g");
        this.groupAdded = false;
        Shape shape = this.getCurrentState().getClip();
        if (shape != GraphicsState.DEFAULT_CLIP) {
            object = this.getClipElement(shape);
            String string = "url(#" + object.getAttribute("id") + ")";
            this.group.setAttribute("clip-path", string);
        }
        if (!GraphicsState.DEFAULT_TRANSFORM.equals(object = this.getCurrentState().getTransform())) {
            this.group.setAttribute("transform", SVGDocument.getOutput((AffineTransform)object));
        }
    }

    private Element getClipElement(Shape shape) {
        Element element = this.clippingPathElements.get(shape.hashCode());
        if (element != null) {
            return element;
        }
        if (this.defs == null) {
            this.defs = this.doc.createElement("defs");
            this.root.insertBefore(this.defs, this.root.getFirstChild());
        }
        element = this.doc.createElement("clipPath");
        element.setAttribute("id", PREFIX_CLIP + shape.hashCode());
        Element element2 = this.getElement(shape);
        element2.removeAttribute("style");
        element.appendChild(element2);
        this.defs.appendChild(element);
        this.clippingPathElements.put(shape.hashCode(), element);
        return element;
    }

    private void addToGroup(Element element) {
        this.group.appendChild(element);
        if (!this.groupAdded && this.group != this.root) {
            this.root.appendChild(this.group);
            this.groupAdded = true;
        }
    }

    public void handle(Command<?> command) {
        if (command instanceof Group) {
            Group group = (Group)command;
            this.applyStateCommands((List)group.getValue());
            if (this.containsGroupCommand((List)group.getValue())) {
                this.newGroup();
            }
        } else if (command instanceof DrawImageCommand) {
            DrawImageCommand drawImageCommand = (DrawImageCommand)command;
            Element element = this.getElement((Image)drawImageCommand.getValue(), drawImageCommand.getX(), drawImageCommand.getY(), drawImageCommand.getWidth(), drawImageCommand.getHeight());
            this.addToGroup(element);
        } else if (command instanceof DrawShapeCommand) {
            DrawShapeCommand drawShapeCommand = (DrawShapeCommand)command;
            Element element = this.getElement((Shape)drawShapeCommand.getValue());
            element.setAttribute("style", this.getStyle(false));
            this.addToGroup(element);
        } else if (command instanceof DrawStringCommand) {
            DrawStringCommand drawStringCommand = (DrawStringCommand)command;
            Element element = this.getElement((String)drawStringCommand.getValue(), drawStringCommand.getX(), drawStringCommand.getY());
            element.setAttribute("style", this.getStyle(this.getCurrentState().getFont()));
            this.addToGroup(element);
        } else if (command instanceof FillShapeCommand) {
            FillShapeCommand fillShapeCommand = (FillShapeCommand)command;
            Element element = this.getElement((Shape)fillShapeCommand.getValue());
            element.setAttribute("style", this.getStyle(true));
            this.addToGroup(element);
        }
    }

    private void applyStateCommands(List<Command<?>> list) {
        for (Command<?> command : list) {
            StateCommand stateCommand;
            GraphicsState graphicsState = this.getCurrentState();
            if (command instanceof SetBackgroundCommand) {
                stateCommand = (SetBackgroundCommand)command;
                graphicsState.setBackground((Color)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetClipCommand) {
                stateCommand = (SetClipCommand)command;
                graphicsState.setClip((Shape)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetColorCommand) {
                stateCommand = (SetColorCommand)command;
                graphicsState.setColor((Color)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetCompositeCommand) {
                stateCommand = (SetCompositeCommand)command;
                graphicsState.setComposite((Composite)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetFontCommand) {
                stateCommand = (SetFontCommand)command;
                graphicsState.setFont((Font)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetPaintCommand) {
                stateCommand = (SetPaintCommand)command;
                graphicsState.setPaint((Paint)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetStrokeCommand) {
                stateCommand = (SetStrokeCommand)command;
                graphicsState.setStroke((Stroke)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetTransformCommand) {
                stateCommand = (SetTransformCommand)command;
                graphicsState.setTransform((AffineTransform)stateCommand.getValue());
                continue;
            }
            if (command instanceof AffineTransformCommand) {
                stateCommand = (AffineTransformCommand)command;
                AffineTransform affineTransform = graphicsState.getTransform();
                AffineTransform affineTransform2 = (AffineTransform)stateCommand.getValue();
                affineTransform.concatenate(affineTransform2);
                graphicsState.setTransform(affineTransform);
                continue;
            }
            if (command instanceof SetHintCommand) {
                stateCommand = (SetHintCommand)command;
                graphicsState.getHints().put(((SetHintCommand)stateCommand).getKey(), stateCommand.getValue());
                continue;
            }
            if (command instanceof CreateCommand) {
                try {
                    this.states.push((GraphicsState)this.getCurrentState().clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
                continue;
            }
            if (!(command instanceof DisposeCommand)) continue;
            this.states.pop();
        }
    }

    private boolean containsGroupCommand(List<Command<?>> list) {
        for (Command<?> command : list) {
            if (!(command instanceof SetClipCommand) && !(command instanceof SetTransformCommand) && !(command instanceof AffineTransformCommand)) continue;
            return true;
        }
        return false;
    }

    private String getStyle(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Color color = this.getCurrentState().getColor();
        String string = SVGDocument.getOutput(color);
        double d = (double)color.getAlpha() / 255.0;
        if (bl) {
            SVGDocument.appendStyle(stringBuilder, "fill", string);
            if (color.getAlpha() < 255) {
                SVGDocument.appendStyle(stringBuilder, "fill-opacity", d);
            }
        } else {
            SVGDocument.appendStyle(stringBuilder, "fill", "none");
        }
        if (!bl) {
            Stroke stroke;
            SVGDocument.appendStyle(stringBuilder, "stroke", string);
            if (color.getAlpha() < 255) {
                SVGDocument.appendStyle(stringBuilder, "stroke-opacity", d);
            }
            if ((stroke = this.getCurrentState().getStroke()) instanceof BasicStroke) {
                BasicStroke basicStroke = (BasicStroke)stroke;
                if (basicStroke.getLineWidth() != 1.0f) {
                    SVGDocument.appendStyle(stringBuilder, "stroke-width", Float.valueOf(basicStroke.getLineWidth()));
                }
                if (basicStroke.getMiterLimit() != 4.0f) {
                    SVGDocument.appendStyle(stringBuilder, "stroke-miterlimit", Float.valueOf(basicStroke.getMiterLimit()));
                }
                if (basicStroke.getEndCap() != 0) {
                    SVGDocument.appendStyle(stringBuilder, "stroke-linecap", STROKE_ENDCAPS.get(basicStroke.getEndCap()));
                }
                if (basicStroke.getLineJoin() != 0) {
                    SVGDocument.appendStyle(stringBuilder, "stroke-linejoin", STROKE_LINEJOIN.get(basicStroke.getLineJoin()));
                }
                if (basicStroke.getDashArray() != null) {
                    SVGDocument.appendStyle(stringBuilder, "stroke-dasharray", DataUtils.join(",", basicStroke.getDashArray()));
                    if (basicStroke.getDashPhase() != 0.0f) {
                        SVGDocument.appendStyle(stringBuilder, "stroke-dashoffset", Float.valueOf(basicStroke.getDashPhase()));
                    }
                }
            }
        } else {
            SVGDocument.appendStyle(stringBuilder, "stroke", "none");
        }
        return stringBuilder.toString();
    }

    private String getStyle(Font font) {
        String string = this.getStyle(true);
        if (!GraphicsState.DEFAULT_FONT.equals(font)) {
            string = string + SVGDocument.getOutput(font);
        }
        return string;
    }

    private static void appendStyle(StringBuilder stringBuilder, String string, Object object) {
        stringBuilder.append(string).append(":").append(DataUtils.format(object)).append(";");
    }

    private static String getOutput(AffineTransform affineTransform) {
        StringBuilder stringBuilder = new StringBuilder();
        if (AffineTransform.getTranslateInstance(affineTransform.getTranslateX(), affineTransform.getTranslateY()).equals(affineTransform)) {
            stringBuilder.append("translate(").append(DataUtils.format(affineTransform.getTranslateX())).append(" ").append(DataUtils.format(affineTransform.getTranslateY())).append(")");
        } else {
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            stringBuilder.append("matrix(").append(DataUtils.join(" ", dArray)).append(")");
        }
        return stringBuilder.toString();
    }

    private static String getOutput(Color color) {
        if (color.getColorSpace().getType() == 9) {
            float[] fArray = color.getComponents(null);
            return String.format((Locale)null, "rgb(%d,%d,%d) icc-color(Generic-CMYK-profile,%f,%f,%f,%f)", color.getRed(), color.getGreen(), color.getBlue(), Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]));
        }
        return String.format((Locale)null, "rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static String getOutput(Shape shape) {
        StringBuilder stringBuilder = new StringBuilder();
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        int n = 0;
        while (!pathIterator.isDone()) {
            if (n > 0) {
                stringBuilder.append(" ");
            }
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    stringBuilder.append("M").append(dArray[0]).append(",").append(dArray[1]);
                    break;
                }
                case 1: {
                    stringBuilder.append("L").append(dArray[0]).append(",").append(dArray[1]);
                    break;
                }
                case 3: {
                    stringBuilder.append("C").append(dArray[0]).append(",").append(dArray[1]).append(" ").append(dArray[2]).append(",").append(dArray[3]).append(" ").append(dArray[4]).append(",").append(dArray[5]);
                    break;
                }
                case 2: {
                    stringBuilder.append("Q").append(dArray[0]).append(",").append(dArray[1]).append(" ").append(dArray[2]).append(",").append(dArray[3]);
                    break;
                }
                case 4: {
                    stringBuilder.append("Z");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++n;
            pathIterator.next();
        }
        return stringBuilder.toString();
    }

    private static String getOutput(Font font) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!GraphicsState.DEFAULT_FONT.getFamily().equals(font.getFamily())) {
            String string = GraphicsUtils.getPhysicalFont(font).getFamily();
            stringBuilder.append("font-family:\"").append(string).append("\";");
        }
        if (font.getSize2D() != GraphicsState.DEFAULT_FONT.getSize2D()) {
            stringBuilder.append("font-size:").append(DataUtils.format(Float.valueOf(font.getSize2D()))).append("px;");
        }
        if ((font.getStyle() & 2) != 0) {
            stringBuilder.append("font-style:italic;");
        }
        if ((font.getStyle() & 1) != 0) {
            stringBuilder.append("font-weight:bold;");
        }
        return stringBuilder.toString();
    }

    private static String getOutput(Image image, boolean bl) {
        String string;
        BufferedImage bufferedImage = GraphicsUtils.toBufferedImage(image);
        String string2 = SVGDocument.encodeImage(bufferedImage, "png");
        if (!GraphicsUtils.usesAlpha(bufferedImage) && bl && (string = SVGDocument.encodeImage(bufferedImage, "jpeg")).length() > 0 && string.length() < string2.length()) {
            string2 = string;
        }
        return string2;
    }

    private static String encodeImage(BufferedImage bufferedImage, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64EncodeStream base64EncodeStream = new Base64EncodeStream(byteArrayOutputStream);
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, base64EncodeStream);
            base64EncodeStream.close();
            String string2 = byteArrayOutputStream.toString("ISO-8859-1");
            return String.format("data:image/%s;base64,%s", string, string2);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private Element getElement(Shape shape) {
        Element element;
        if (shape instanceof Line2D) {
            Line2D line2D = (Line2D)shape;
            element = this.doc.createElement("line");
            element.setAttribute("x1", DataUtils.format(line2D.getX1()));
            element.setAttribute("y1", DataUtils.format(line2D.getY1()));
            element.setAttribute("x2", DataUtils.format(line2D.getX2()));
            element.setAttribute("y2", DataUtils.format(line2D.getY2()));
        } else if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            element = this.doc.createElement("rect");
            element.setAttribute("x", DataUtils.format(rectangle2D.getX()));
            element.setAttribute("y", DataUtils.format(rectangle2D.getY()));
            element.setAttribute("width", DataUtils.format(rectangle2D.getWidth()));
            element.setAttribute("height", DataUtils.format(rectangle2D.getHeight()));
        } else if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
            element = this.doc.createElement("rect");
            element.setAttribute("x", DataUtils.format(roundRectangle2D.getX()));
            element.setAttribute("y", DataUtils.format(roundRectangle2D.getY()));
            element.setAttribute("width", DataUtils.format(roundRectangle2D.getWidth()));
            element.setAttribute("height", DataUtils.format(roundRectangle2D.getHeight()));
            element.setAttribute("rx", DataUtils.format(roundRectangle2D.getArcWidth() / 2.0));
            element.setAttribute("ry", DataUtils.format(roundRectangle2D.getArcHeight() / 2.0));
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            element = this.doc.createElement("ellipse");
            element.setAttribute("cx", DataUtils.format(ellipse2D.getCenterX()));
            element.setAttribute("cy", DataUtils.format(ellipse2D.getCenterY()));
            element.setAttribute("rx", DataUtils.format(ellipse2D.getWidth() / 2.0));
            element.setAttribute("ry", DataUtils.format(ellipse2D.getHeight() / 2.0));
        } else {
            element = this.doc.createElement("path");
            element.setAttribute("d", SVGDocument.getOutput(shape));
        }
        return element;
    }

    private Element getElement(String string, double d, double d2) {
        Element element = this.doc.createElement("text");
        element.appendChild(this.doc.createTextNode(string));
        element.setAttribute("x", DataUtils.format(d));
        element.setAttribute("y", DataUtils.format(d2));
        return element;
    }

    private Element getElement(Image image, double d, double d2, double d3, double d4) {
        Element element = this.doc.createElement("image");
        element.setAttribute("x", DataUtils.format(d));
        element.setAttribute("y", DataUtils.format(d2));
        element.setAttribute("width", DataUtils.format(d3));
        element.setAttribute("height", DataUtils.format(d4));
        element.setAttribute("preserveAspectRatio", "none");
        boolean bl = this.getCurrentState().getHints().get(VectorHints.KEY_EXPORT) == VectorHints.VALUE_EXPORT_SIZE;
        element.setAttribute("xlink:href", SVGDocument.getOutput(image, bl));
        return element;
    }
}

