/*
 * Farsight Voice+Video library
 *  Copyright 2006 Collabora Ltd, 
 *  Copyright 2006 Nokia Corporation
 *   @author: Philippe Khalaf <philippe.khalaf@collabora.co.uk>.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string>

#include <talk/base/thread.h>
#include <talk/base/network.h>
#include <talk/p2p/base/socketmanager.h>
#include <talk/p2p/client/basicportallocator.h>

using namespace cricket;

class SignalListener1;
class SignalListener2;

class SocketClient: public sigslot::has_slots<>
{
    public:
        SignalListener1 *sigl1;
        SignalListener2 *sigl2;

        SocketClient(SocketAddress *stun_addr,
                SocketAddress *turn_addr);
        virtual ~SocketClient();

        void CreateSocket(const std::string &name);

        void SetRelayToken(const std::string &relay_token);

        void OnRequestSignaling();

        void OnSocketRead(P2PSocket *socket, const char *data, size_t len);

        /*
        void SetCandidatesReadyCb(candidates_ready_cb_type cb, void *data)
            { candidates_ready_cb = cb; candidates_ready_cb_data = data; };

        void SetStateCb(socket_state_change_cb_type cb, void *data)
            { state_cb = cb; socket_state_change_cb_data = data; };

        void SetNetworkErrorCb(empty_cb_type cb, void *data)
            { network_error_cb = cb; empty_cb_data = data; };

        void SetSocketReadCb(socket_read_cb_type cb, void *data)
            { socket_read_cb = cb; socket_read_cb_data = data; };
            */

        SocketManager *getSocketManager() 
            { return socket_manager; };

        P2PSocket *getSocket()
            { return socket; };

    private:
        SocketManager *socket_manager;
        // We only create 1 socket per SocketClient (for now at least)
        P2PSocket *socket;

        Thread *worker_thread;
        NetworkManager *network_manager;
        BasicPortAllocator *port_allocator;
	
        // callbacks
        /*
        candidates_ready_cb_type candidates_ready_cb;
        socket_state_change_cb_type state_cb;
        empty_cb_type network_error_cb;
        socket_read_cb_type socket_read_cb;

        // the user defined data for the callbacks
        void *candidates_ready_cb_data;
        void *socket_state_change_cb_data;
        void *empty_cb_data;
        void *socket_read_cb_data;
        */
};
