/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.demo;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class DialogsTab {
    private Container parent;
    private JButton informationButton;
    private JButton warningButton;
    private JButton questionButton;
    private JButton errorButton;
    private JButton chooseFileNativeButton;
    private JButton chooseFileSwingButton;

    DialogsTab() {
    }

    private void initComponents() {
        this.informationButton = new JButton("Information");
        this.informationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DialogsTab.this.getParentFrame(), "We just wanted to let you know that you have pressed\nthe Information button to open this sample message dialog.\n\n", "Information", 1);
            }
        });
        this.warningButton = new JButton("Warning");
        this.warningButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DialogsTab.this.getParentFrame(), "We just wanted to let you know that you have pressed\nthe Warning button to open this sample message dialog.\n\n", "Warning", 2);
            }
        });
        this.questionButton = new JButton("Question");
        this.questionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showConfirmDialog(DialogsTab.this.getParentFrame(), "We just wanted to let you know that you have pressed\nthe Question button to open this sample question dialog.\n\nAre you satisfied with the dialog's appearance?\n\n", "Question", 0);
            }
        });
        this.errorButton = new JButton("Error");
        this.errorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(DialogsTab.this.getParentFrame(), "We just wanted to let you know that you have pressed\nthe Error button to open this error message dialog.\n\nJust go ahead and proceed.\n\n", "Error", 0);
            }
        });
        this.chooseFileNativeButton = new JButton("Open\u2026");
        this.chooseFileNativeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileDialog dialog = new FileDialog((Frame)DialogsTab.this.getParentFrame(), "Open File (Native)");
                dialog.setResizable(true);
                dialog.setVisible(true);
            }
        });
        this.chooseFileSwingButton = new JButton("Open\u2026");
        this.chooseFileSwingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new JFileChooser("Open File (Swing)").showOpenDialog(DialogsTab.this.getParentFrame());
            }
        });
    }

    JComponent build(Container aParent) {
        this.parent = aParent;
        this.initComponents();
        FormLayout layout = new FormLayout("0:grow, left:pref, 0:grow", "0:grow, pref, 4dlu, pref, 14dlu, pref, 4dlu, pref, 14dlu, pref, 4dlu, pref, 0:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        builder.addLabel("Press a button to open a message dialog.", cc.xy(2, 2));
        builder.add((Component)this.buildButtonBar(), cc.xy(2, 4));
        builder.addLabel("This opens the native file chooser.", cc.xy(2, 6));
        builder.add((Component)this.chooseFileNativeButton, cc.xy(2, 8));
        builder.addLabel("This opens the Swing file chooser.", cc.xy(2, 10));
        builder.add((Component)this.chooseFileSwingButton, cc.xy(2, 12));
        return builder.getPanel();
    }

    private JPanel buildButtonBar() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.setOpaque(false);
        builder.addGriddedButtons(new JButton[]{this.informationButton, this.warningButton, this.questionButton, this.errorButton});
        return builder.getPanel();
    }

    JFrame getParentFrame() {
        return (JFrame)SwingUtilities.getWindowAncestor(this.parent);
    }
}

