/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib;

import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXNotSupportedException;

public class Extensions {
    private Extensions() {
    }

    public static NodeSet difference(NodeIterator ni1, NodeIterator ni2) throws TransformerException {
        NodeSet ns1 = new NodeSet(ni1);
        NodeSet ns2 = new NodeSet(ni2);
        NodeSet diff = new NodeSet();
        diff.setShouldCacheNodes(true);
        int i = 0;
        while (i < ns1.getLength()) {
            Node n = ns1.elementAt(i);
            if (!ns2.contains(n)) {
                diff.addElement(n);
            }
            ++i;
        }
        return diff;
    }

    public static NodeSet distinct(NodeIterator ni) throws TransformerException {
        NodeSet ns = new NodeSet(ni);
        NodeSet dist = new NodeSet();
        dist.setShouldCacheNodes(true);
        Hashtable<String, Node> stringTable = new Hashtable<String, Node>();
        int i = 0;
        while (i < ns.getLength()) {
            Node n = ns.elementAt(i);
            String key = n.getNodeValue();
            if (!stringTable.containsKey(key)) {
                stringTable.put(key, n);
                dist.addElement(n);
            }
            ++i;
        }
        return dist;
    }

    public static XObject evaluate(ExpressionContext myContext, String xpathExpr) throws SAXNotSupportedException, Exception {
        if (myContext instanceof XPathContext) {
            XPathContext xctxt = (XPathContext)myContext;
            XPath dynamicXPath = new XPath(xpathExpr, xctxt.getSAXLocator(), xctxt.getNamespaceContext(), 0);
            return dynamicXPath.execute(xctxt, myContext.getContextNode(), xctxt.getNamespaceContext());
        }
        throw new SAXNotSupportedException("Invalid context passed to evaluate " + myContext);
    }

    public static boolean hasSameNodes(NodeIterator ni1, NodeIterator ni2) {
        NodeSet ns1 = new NodeSet(ni1);
        NodeSet ns2 = new NodeSet(ni2);
        if (ns1.getLength() != ns2.getLength()) {
            return false;
        }
        int i = 0;
        while (i < ns1.getLength()) {
            Node n = ns1.elementAt(i);
            if (!ns2.contains(n)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static NodeSet intersection(NodeIterator ni1, NodeIterator ni2) throws TransformerException {
        NodeSet ns1 = new NodeSet(ni1);
        NodeSet ns2 = new NodeSet(ni2);
        NodeSet inter = new NodeSet();
        inter.setShouldCacheNodes(true);
        int i = 0;
        while (i < ns1.getLength()) {
            Node n = ns1.elementAt(i);
            if (ns2.contains(n)) {
                inter.addElement(n);
            }
            ++i;
        }
        return inter;
    }

    public static NodeSet nodeset(ExpressionContext myProcessor, Object rtf) {
        if (rtf instanceof NodeIterator) {
            return new NodeSet((NodeIterator)rtf);
        }
        String textNodeValue = rtf instanceof String ? (String)rtf : (rtf instanceof Boolean ? new XBoolean((Boolean)rtf).str() : (rtf instanceof Double ? new XNumber((Double)rtf).str() : rtf.toString()));
        Document myDoc = myProcessor.getContextNode().getOwnerDocument();
        Text textNode = myDoc.createTextNode(textNodeValue);
        DocumentFragment docFrag = myDoc.createDocumentFragment();
        docFrag.appendChild(textNode);
        return new NodeSet(docFrag);
    }

    public static NodeSet tokenize(ExpressionContext myContext, String toTokenize) {
        return Extensions.tokenize(myContext, toTokenize, " \t\n\r");
    }

    public static NodeSet tokenize(ExpressionContext myContext, String toTokenize, String delims) {
        Document lDoc = myContext.getContextNode().getOwnerDocument();
        StringTokenizer lTokenizer = new StringTokenizer(toTokenize, delims);
        NodeSet resultSet = new NodeSet();
        while (lTokenizer.hasMoreTokens()) {
            resultSet.addNode(lDoc.createTextNode(lTokenizer.nextToken()));
        }
        return resultSet;
    }
}

