package org.jboss.cache.eviction;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;

/**
 * Base class implementation of EvictionPolicy and TreeCacheListener.
 *
 * @author Ben Wang  2-2004
 * @author Daniel Huang - dhuang@jboss.org
 * @version $Revision: 4834 $
 */
public abstract class BaseEvictionPolicy implements EvictionPolicy
{
   protected CacheSPI cache_;

   /** EvictionPolicy interface implementation */

   /**
    * Evict the node under given Fqn from cache.
    *
    * @param fqn The fqn of a node in cache.
    * @throws Exception
    */
   public void evict(Fqn fqn) throws Exception
   {
      cache_.evict(fqn, false);
   }

   public void setCache(CacheSPI cache)
   {
      this.cache_ = cache;
   }

   public CacheSPI getCache()
   {
      return this.cache_;
   }

   /*
   * (non-Javadoc)
   * @see org.jboss.cache.eviction.EvictionPolicy#canIgnoreEvent(org.jboss.cache.Fqn)
   *
   */
   public boolean canIgnoreEvent(Fqn fqn, NodeEventType eventType)
   {
      return false;
   }
}
