#!/bin/sh
##
##  Sets up the basic environment for Ant and then starts it.
##
##  @author Jason Dillon <jason@planet57.com>
##

# $Id: build.sh 21628 2008-08-19 22:06:02Z pgier $

# If we are running under Cygwin do some translation
if [ ! -z "$COMSPEC" ]; then
    temp=`cygpath --unix $0`
else
    temp="$0"
fi
PROGNAME=`basename $temp`
DIRNAME=`dirname $temp`

# If we have not been included from the loader script setup some values
if [ "x$TOOLS_ROOT" = "x" ]; then
    TOOLS_ROOT=`cd $DIRNAME/.. && pwd`
fi
if [ "x$MODULE_ROOT" = "x" ]; then
    MODULE_ROOT=`pwd`;
fi
if [ "$CYGWIN" = true ]; then
    TOOLS_ROOT=`cygpath --unix $TOOLS_ROOT`
fi

# Include common /bin/sh functions
. "$TOOLS_ROOT/bin/common.shlib"

# The minimum and maximum VM heap size
xset JVM_MS="32m"
xset JVM_MX="640m"

# Detect which OS we are on
check_os

TOOLS_ROOT=`convertpath --unix $TOOLS_ROOT`
MODULE_ROOT=`convertpath --unix $MODULE_ROOT`
debug "TOOLS_ROOT: $TOOLS_ROOT"
debug "MODULE_ROOT: $MODULE_ROOT"

# Setup defaults
xset MAX_FD "maximum"
xset JAXP "crimson"

# Ignore user's ANT_HOME if it is set
if [ "x$ANT_HOME" != "x" ]; then
    warn "Ignoring environment value for \$ANT_HOME"
fi
ANT_HOME=`convertpath --unix $TOOLS_ROOT`
debug "Ant home: $ANT_HOME"

# Use the color logger if requested
if [ "x$ANT_COLOR" != "x" ]; then
    xset ANT_LOGGER "org.apache.tools.ant.listener.AnsiColorLogger"
else
    xset ANT_LOGGER "org.apache.tools.ant.NoBannerLogger"
fi
debug "Using Ant logger: $ANT_LOGGER"

# The nitty gritty dirty fluffy fluff
main() {
    # if there is a build config file. then source it
    maybe_source "$MODULE_ROOT/build.conf" "$HOME/.build.conf"

    # Increase the maximum file descriptors if we can
    if [ $WIN32 = "false" ]; then
	MAX_FD_LIMIT=`ulimit -H -n`
	if [ $? -eq 0 ]; then
	    if [ "$MAX_FD" = "maximum" -o "$MAX_FD" = "max" ]; then
		# use the system max
		MAX_FD="$MAX_FD_LIMIT"
	    fi

	    ulimit -n $MAX_FD
	    if [ $? -ne 0 ]; then
		warn "Could not set maximum file descriptor limit: $MAX_FD"
	    fi
	else
	    warn "Could not query system maximum file descriptor limit: $MAX_FD_LIMIT"
	fi
    fi

    # Make sure we have one
    ANT="$ANT_HOME/bin/ant"
    if [ ! -x "$ANT" ]; then
	die "Ant script is not executable: $ANT"
    fi

    # Specify the jaxp parser impls to use
    debug "JAXP type: $JAXP"
    case "$JAXP" in
	crimson)
	    JAXP_DOM_FACTORY="org.apache.crimson.jaxp.DocumentBuilderFactoryImpl"
	    JAXP_SAX_FACTORY="org.apache.crimson.jaxp.SAXParserFactoryImpl"
	    ;;
	   
	xerces)
	    JAXP_DOM_FACTORY="org.apache.xerces.jaxp.DocumentBuilderFactoryImpl"
	    JAXP_SAX_FACTORY="org.apache.xerces.jaxp.SAXParserFactoryImpl"
	    ;;

        *)
	    die "Unknown JAXP impl: $JAXP; define \$JAXP_DOM_FACTORY and \$JAXP_SAX_FACTORY"
	    ;;
    esac

    # Set the options which ant will pass to its JVM
    xset ANT_OPTS "-Xms$JVM_MS -Xmx$JVM_MX"

    if [ "x$JAXP_DOM_FACTORY" != "x" ]; then
	ANT_OPTS="$ANT_OPTS -Djavax.xml.parsers.DocumentBuilderFactory=$JAXP_DOM_FACTORY"
    fi
    if [ "x$JAXP_SAX_FACTORY" != "x" ]; then
	ANT_OPTS="$ANT_OPTS -Djavax.xml.parsers.SAXParserFactory=$JAXP_SAX_FACTORY"
    fi
    debug "Ant JVM options: $ANT_OPTS"

    # Add some options to Ant
    xset ANT_OPTIONS "-logger $ANT_LOGGER"

    # Unset the classpath so it will not interfear
    CLASSPATH=""

    # Export some stuff for Ant
    export ANT ANT_HOME ANT_OPTS CLASSPATH

    # Change to the directory where the script lives so users are not forced
    # to be in the same directory as build.xml
    debug "Entering $MODULE_ROOT"
    cd $MODULE_ROOT

    notice "Executing: $ANT $ANT_OPTIONS $@"
    if [ "x$TRACE" != "x" ]; then
	exec /bin/sh -x $ANT $ANT_OPTIONS "$@"
    else
	exec $ANT $ANT_OPTIONS "$@"
    fi
}

# Lets get ready to rumble!
main "$@"
