/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import java.util.Map;
import java.util.Iterator;

import org.apache.tools.ant.*;

import org.jboss.tools.buildmagic.task.util.TaskLogger;

/**
 * Task to add a filter for properties.
 *
 * @version $Id: PropertyFilter.java 21939 2008-08-27 21:01:35Z pgier $
 * @author  Jason Dillon <A href="mailto:jason@planet57.com">&lt;jason@planet57.com&gt;</A>
 */
public class PropertyFilter
   extends Task
{
   /** Instance logger. */
   protected final TaskLogger log = new TaskLogger(this);

   protected boolean all = true;

   public void setAll(boolean all) {
      this.all = all;
   }

   public void execute() throws BuildException {
      if (all) {
         log.verbose("Adding filters for all properties");

         Map props = getProject().getProperties();

         Iterator iter = props.keySet().iterator();
         while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)props.get(key);

            // log.debug("adding: " + key + "=" + value);
            getProject().getGlobalFilterSet().addFilter(key, value);
         }
      }
   }
}
