/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.tools.buildmagic.task;

import java.util.*;

import org.apache.tools.ant.*;

import org.jboss.tools.buildmagic.task.*;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

/**
 * Base class for tasks that can contain other tasks or scripts.
 *
 * @version <pre>$Id: ContainerTask.java 21939 2008-08-27 21:01:35Z pgier $</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public abstract class ContainerTask
   extends Task
   implements Cloneable
{
   /** Instance logger. */
   protected final TaskLogger log = new TaskLogger(this);

   /** The list of tasks to execute. */
   protected List tasks = new LinkedList();

   /**
    * Set the target to execute when expr is true.
    *
    * @param target  The target to execute.
    */
   public void setTarget(final String target) {
      CallTarget call = createCall();
      call.setTarget(target);
      tasks.add(call);
   }

   /**
    * Set the script for this target.
    *
    * @param script  The script for this target.
    */
   public void setScript(final String script) {
      Script task = createScript();
      task.addText(script);
      tasks.add(task);
   }

   /**
    * Create a nested <tt>call</tt> target.
    */
   public CallTarget createCall() {
      CallTarget task = (CallTarget)getProject().createTask("call");
      tasks.add(task);
      return task;
   }

   /**
    * Create a nested <tt>script</tt> target.
    */
   public Script createScript() {
      Script task = (Script)getProject().createTask("script");
      tasks.add(task);
      return task;
   }

   /**
    * Validate the attributes for this task.
    *
    * @throws BuildException  Attributes are not valid.
    */
   protected void validate() throws BuildException {
      if (tasks.size() == 0)
         throw new MissingElementException("call' or 'task", this);
   }

   /**
    * Execute all of the sub-tasks.
    */
   protected void executeTasks() throws BuildException {
      Iterator iter = tasks.iterator();

      while (iter.hasNext()) {
         Task task = (Task)iter.next();
         log.debug("executing sub-task: " + task);
         task.execute();
      }
   }

   /**
    * Return a cloned copy of this object.
    *
    * @return   Cloned object.
    */
   public Object clone() {
      try {
         return super.clone();
      }
      catch (CloneNotSupportedException e) {
         throw new InternalError();
      }
   }
}
