/* iksemel (XML parser for Jabber)
** Copyright (C) 2000-2003 Gurer Ozen <madcat@e-kolay.net>
** This code is free software; you can redistribute it and/or
** modify it under the terms of GNU Lesser General Public License.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "iksemel.h"

int main (int argc, char *argv[])
{
	struct lala {
		char *str;
		char *hash;
	} known_hashes[] = {
		{ "abc", "A9993E364706816ABA3E25717850C26C9CD0D89D" },
		{ "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq",
		  "84983E441C3BD26EBAAE4AA1F95129E5E54670F1" },
		{ NULL, NULL }
	};
	int i = 0;
	char buf[42];

	while (known_hashes[i].str) {
		iks_sha (known_hashes[i].str, buf);
		if (strcmp (buf, known_hashes[i].hash) != 0) {
			printf("SHA1 hash of \"%s\"\n", known_hashes[i].str);
			printf(" Result:   %s\n", buf);
			printf(" Expected: %s\n", known_hashes[i].hash);
			return 1;
		}
		i++;
	}
	return 0;
}
