/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "plugin.h"

#include <QtQml>

#include "../src/parameter.h"
#include "../src/slider-parameter.h"

#include "../src/quit-action.h"
#include "../src/fullscreen-action.h"
#include "../src/help-action.h"
#include "../src/settings-action.h"
#include "../src/undo-action.h"

#include "action.h"
#include "context.h"
#include "hud.h"


void
HudQmlPlugin::registerTypes(const char *uri)
{
    // @uri Ubuntu.HUD

  qmlRegisterType<Ubuntu::HUD::QML::Action>         (uri, 1, 0, "Action");
  qmlRegisterType<Ubuntu::HUD::QML::Context>   (uri, 1, 0, "Context");
  qmlRegisterType<Ubuntu::HUD::QML::HUD>       (uri, 1, 0, "HUD");
  qmlRegisterType<Ubuntu::HUD::Parameter>      ();
  qmlRegisterType<Ubuntu::HUD::SliderParameter>(uri, 1, 0, "SliderParameter");

  qmlRegisterType<Ubuntu::HUD::Action>           ();
  qmlRegisterType<Ubuntu::HUD::PredefinedAction> ();
  qmlRegisterType<Ubuntu::HUD::QuitAction>       (uri, 1, 0, "QuitAction");
  qmlRegisterType<Ubuntu::HUD::FullscreenAction> (uri, 1, 0, "FullscreenAction");
  qmlRegisterType<Ubuntu::HUD::HelpAction>       (uri, 1, 0, "HelpAction");
  qmlRegisterType<Ubuntu::HUD::SettingsAction>   (uri, 1, 0, "SettingsAction");
  qmlRegisterType<Ubuntu::HUD::UndoAction>       (uri, 1, 0, "UndoAction");

}

void
HudQmlPlugin::initializeEngine(QQmlEngine *engine, const char *uri)
{
  Q_UNUSED(uri);
  Q_UNUSED(engine);
}


