// -*- C++ -*-
//
// The Hoard Multiprocessor Memory Allocator
// www.hoard.org
//
// Author: Emery Berger, http://www.cs.umass.edu/~emery
//
// Copyright (c) 1998-2002, The University of Texas at Austin.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as
// published by the Free Software Foundation, http://www.fsf.org.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
//////////////////////////////////////////////////////////////////////////////

#if defined(USE_HOARD)
#pragma comment(lib, "libhoard.lib")
#endif

// This object module comment is a command to the linker 
//	to force a reference to ReferenceLibHoard below

//#pragma comment(linker, "/include:_ReferenceLibHoard")

#define WIN32_LEAN_AND_MEAN
#include <windows.h>


#if 1
extern "C" {

__declspec(dllimport) int ReferenceMe;

}

// Force a reference to libhoard that loads the DLL very early,
// before even main() is executed.
 
namespace LibHoardInternal {
	class ReferToLibHoard {
	   public:
		   ReferToLibHoard (void) {
				(void)LoadLibraryA("libhoard.dll");
				ReferenceMe = 1; 
		   }
	   };

   volatile static ReferToLibHoard oneRef;
};

#endif

// Reroute all C++ calls in this executable to use malloc & free.

extern "C" void * malloc (size_t);
extern "C" void free (void *);

namespace std {
	struct nothrow_t;
};

void * operator new (size_t size)
{
  return malloc (size);
}

void * operator new (size_t size, const std::nothrow_t&) throw() {
  return malloc (size);
} 

void * operator new[] (size_t size)
{
  return malloc (size);
}

void * operator new[] (size_t size, const std::nothrow_t&) throw() {
  return malloc (size);
} 

void operator delete (void * ptr)
{
  free (ptr);
}

void operator delete[] (void * ptr)
{
  free (ptr);
}

