/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: PageSelectorGroup.java,v 1.8 2006/02/26 00:59:07 pietschy Exp $
 */
package org.pietschy.command.demo;

import com.l2fprod.common.swing.JButtonBar;
import org.pietschy.command.CommandManager;
import org.pietschy.command.Face;
import org.pietschy.command.ToggleCommandGroup;

/**
 * This class extends {@link ToggleCommandGroup} to provide a widget based on the
 * JButtonBar component from http://l2fprod.com/.
 * @version $Revision: 1.8 $
 * @author andrewp
 */
public class
PageSelectorGroup
extends ToggleCommandGroup
{
   private static final String SELECTOR_FACE = "page-selector";

   /**
    * Creates a new group with the specified Id and that uses the specified {@link CommandManager}.
    * @param groupId the id of the group.
    * @param container the {@link CommandManager} the group is to use.
    */
   public PageSelectorGroup(CommandManager container, String groupId)
   {
      super(container, groupId);
      setExclusive(true);
   }

   /**
    * Creates a new vertical JButtonBar using the "page-selector" face.
    * @return a new JButtonBar for this group.
    */
   public JButtonBar createButtonBar()
   {
      return createButtonBar(JButtonBar.VERTICAL);
   }

   /**
    * Creates a new JButtonBar with the specified orientation using the "page-selector" face.
    * @param orientation the orientation of the bar, either {@link JButtonBar#VERTICAL} or
    * {@link JButtonBar#HORIZONTAL}.
    *
    * @return a new JButtonBar for this group.
    */
   public JButtonBar createButtonBar(int orientation)
   {
      return createButtonBar(orientation, SELECTOR_FACE);
   }

   /**
    * Creates a new JButtonBar with the specified orientation using the specified face.
    * @param orientation the orientation of the bar, either {@link JButtonBar#VERTICAL} or
    * {@link JButtonBar#HORIZONTAL}.
    * @param faceName the face for button bar and its members to use.
    *
    * @return a new JButtonBar for this group.
    */
   public JButtonBar createButtonBar(int orientation, String faceName)
   {
      JButtonBar buttonBar = new JButtonBar(orientation);
      bindMembers(buttonBar, getButtonFactory(), faceName);
      return buttonBar;
   }

   /**
    * Overrides the default implementation to provide defaults for the page-selector face if
    * it hasn't been specified.
    * @param face the desired face name
    * @return a String array with the alternate faces in preferred order.
    */
   public String[]
   getAlternativeFaceNames(String face)
   {
      if (SELECTOR_FACE.equals(face))
         return new String[]{Face.BUTTON, Face.DEFAULT};

      return super.getAlternativeFaceNames(face);
   }
}
