// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEBUFFER_H
#define _GTKSOURCEVIEWMM_SOURCEBUFFER_H


#include <glibmm.h>

/* sourcebuffer.hg
 * 
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2006 Dodji Seketeli
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief SourceBuffer class
///

#include <gtkmm/textbuffer.h>
#include <gtksourceviewmm/sourcelanguage.h>
#include <gtksourceviewmm/sourcemark.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceBuffer GtkSourceBuffer;
typedef struct _GtkSourceBufferClass GtkSourceBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceBuffer_Class; } // namespace gtksourceview
namespace gtksourceview
{

/// \brief The model for SourceView widgets.
///
/// It extends the TextBuffer object by adding features necessary
/// to display and edit source code: syntax highlighting,
/// bracket matching and markers.
/// It also implements support for undo/redo operations.
/// To create a SourceBuffer use SourceBuffer::create().
/// By default highlighting is enabled, but you can disable it
/// with SourceBuffer::set_highlight_syntax().
/// This can be useful if you're not using SourceLanguage
/// objects to set the highlighting patterns,
/// and instead you're manually adding SourceTag objects
/// to the buffer's tag table.

class SourceBuffer : public Gtk::TextBuffer
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SourceBuffer CppObjectType;
  typedef SourceBuffer_Class CppClassType;
  typedef GtkSourceBuffer BaseObjectType;
  typedef GtkSourceBufferClass BaseClassType;

private:  friend class SourceBuffer_Class;
  static CppClassType sourcebuffer_class_;

private:
  // noncopyable
  SourceBuffer(const SourceBuffer&);
  SourceBuffer& operator=(const SourceBuffer&);

protected:
  explicit SourceBuffer(const Glib::ConstructParams& construct_params);
  explicit SourceBuffer(GtkSourceBuffer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SourceBuffer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceBuffer*       gobj()       { return reinterpret_cast<GtkSourceBuffer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceBuffer* gobj() const { return reinterpret_cast<GtkSourceBuffer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceBuffer* gobj_copy();

private:


protected:
  SourceBuffer();

 
  explicit SourceBuffer(const Glib::RefPtr<Gtk::TextTagTable>& tagtable);
  explicit SourceBuffer (const Glib::RefPtr<SourceLanguage> &language) ;

public:

    /// \brief create a new SourceBuffer, from a Gtk::TextTagTable.
    ///
    /// \param tagtable a tag table to be taken in account
    /// \return a new SourceBuffer
   
  static Glib::RefPtr<SourceBuffer> create(const Glib::RefPtr<Gtk::TextTagTable>& tagtable);


    /// brief create a new SourceBuffer
    ///
    /// \param language the language to be considered by the SourceBuffer for syntax highlighting.
    /// \return a new SourceBuffer
   
  static Glib::RefPtr<SourceBuffer> create(const Glib::RefPtr<SourceLanguage>& language);


   /// \brief Determines whether bracket match highlighting is activated for the source buffer.
   ///
   /// \return true if the source buffer will highlight  matching brackets, false otherwise.
  
  /** Determines whether bracket match highlighting is activated for the
   * source buffer.
   * @return <tt>true</tt> if the source buffer will highlight matching
   * brackets.
   */
  bool get_highlight_matching_brackets() const;

   /// \brief controls the bracket match highlighting function in the buffer.
   ///
   /// If activated, when you position your cursor over a bracket character (a parenthesis, a square bracket, etc.)
   /// the matching opening or closing bracket character will be highlighted.
   /// You can specify the style with the SourceBuffer::set_bracket_match_style() function.
   /// \param highlight true if you want matching brackets highlighted.
  
  /** Controls the bracket match highlighting function in the buffer.  If
   * activated, when you position your cursor over a bracket character
   * (a parenthesis, a square bracket, etc.) the matching opening or
   * closing bracket character will be highlighted.  You can specify the
   * style with the gtk_source_buffer_set_bracket_match_style()
   * function.
   * @param highlight <tt>true</tt> if you want matching brackets highlighted.
   */
  void set_highlight_matching_brackets(bool highlight=true);

  /// \brief Determines whether text highlighting is activated in the source buffer.
  ///
  /// \return true if highlighting is activated, false otherwise.
  
  /** Determines whether syntax highlighting is activated in the source
   * buffer.
   * @return <tt>true</tt> if syntax highlighting is enabled, <tt>false</tt> otherwise.
   */
  bool get_highlight_syntax() const;

  /// \brief controls whether text is highlighted in the buffer.
  ///
  /// If highlight is TRUE, the text will be highlighted according to the patterns
  /// installed in the buffer (either set with SourceBuffer::set_language()
  /// or by adding individual GtkSourceTag tags to the buffer's tag table).
  /// Otherwise, any current highlighted text will be restored to the default buffer style.
  /// Tags not of SourceTag type will not be removed by this option, and normal
  /// Gtk::TextTag priority settings apply when highlighting is enabled.
  /// If not using a SourceLanguage for setting the highlighting patterns in the buffer,
  /// it is recommended for performance reasons that you add all the
  /// SourceTag tags with highlighting disabled and enable it when finished.
  /// \param highlight true if you want to activate highlighting
  
  /** Controls whether syntax is highlighted in the buffer. If @a highlight
   * is <tt>true</tt>, the text will be highlighted according to the syntax
   * patterns specified in the language set with
   * set_language(). If @a highlight is <tt>false</tt>, syntax highlighting
   * is disabled and all the GtkTextTag objects that have been added by the 
   * syntax highlighting engine are removed from the buffer.
   * @param highlight <tt>true</tt> to enable syntax highlighting, <tt>false</tt> to disable it.
   */
  void set_highlight_syntax(bool highlight = true);

  /// \brief Determines the number of undo levels the buffer will track for buffer edits.
  ///
  /// \return the maximum number of possible undo levels.
  
  /** Determines the number of undo levels the buffer will track for
   * buffer edits.
   * @return The maximum number of possible undo levels or
   * -1 if no limit is set.
   */
  int get_max_undo_levels() const;

  /// \brief Sets the number of undo levels for user actions the buffer will track.
  ///
  /// If the number of user actions exceeds the limit set
  /// by this function, older actions will be discarded.
  /// A new action is started whenever the function
  /// Gtk::TextBuffer::begin_user_action() is called.
  /// In general, this happens whenever the user presses
  /// any key which modifies the buffer,
  /// but the undo manager will try to merge similar consecutive actions,
  /// such as multiple character insertions into one action.
  /// But, inserting a newline does start a new action.
  /// \param max_undo_levels the desired maximum number of undo levels.
  
  /** Sets the number of undo levels for user actions the buffer will
   * track.  If the number of user actions exceeds the limit set by this
   * function, older actions will be discarded.
   * 
   * If @a max_undo_levels is -1, no limit is set.
   * 
   * A new action is started whenever the function
   * gtk_text_buffer_begin_user_action() is called.  In general, this
   * happens whenever the user presses any key which modifies the
   * buffer, but the undo manager will try to merge similar consecutive
   * actions, such as multiple character insertions into one action.
   * But, inserting a newline does start a new action.
   * @param max_undo_levels The desired maximum number of undo levels.
   */
  void set_max_undo_levels(int max_undo_levels);

  /// \brief Determines the GtkSourceLanguage used by the buffer.
  ///
  /// \return the SourceLanguage set by SourceBuffer::set_language(), or nil.
  
  /** Return value: Gtk::SourceLanguage associated with the buffer, or <tt>0</tt>.
   * @return Gtk::SourceLanguage associated with the buffer, or <tt>0</tt>.
   */
  Glib::RefPtr<SourceLanguage> get_language();

  /// \brief Determines the GtkSourceLanguage used by the buffer.
  ///
  /// \return the SourceLanguage set by SourceBuffer::set_language(), or nil.
  
  /** Return value: Gtk::SourceLanguage associated with the buffer, or <tt>0</tt>.
   * @return Gtk::SourceLanguage associated with the buffer, or <tt>0</tt>.
   */
  Glib::RefPtr<const SourceLanguage> get_language() const;


  /// \brief Sets the GtkSourceLanguage the source buffer will use.
  ///
  /// This adds GtkSourceTag tags with the language's patterns and sets
  /// the escape character with SourceBuffer::set_escape_char().
  /// Note that this will remove any SourceTag tags currently
  /// in the buffer's tag table.
  /// The buffer holds a reference to the language set.
  /// \param language a GtkSourceLanguage to set.
  
  /** Associate a Gtk::SourceLanguage with the source buffer. If @a language is 
   * not-<tt>0</tt> and syntax highlighting is enabled (see set_highlight_syntax()),
   * the syntax patterns defined in @a language will be used to highlight the text
   * contained in the buffer. If @a language is <tt>0</tt>, the text contained in the 
   * buffer is not highlighted.
   * 
   * The buffer holds a reference to @a language.
   * @param language A Gtk::SourceLanguage to set, or <tt>0</tt>.
   */
  void set_language(const Glib::RefPtr<SourceLanguage>& language);

  /// \brief Determines whether a source buffer can undo the last action
  /// \return true if it's possible to undo the last action, false otherwise.
  
  /** Determines whether a source buffer can undo the last action.
   * @return <tt>true</tt> if it's possible to undo the last action.
   */
  bool can_undo() const;

  /// \brief Determines whether a source buffer can redo the last action
  ///
  /// I.E  if the last operation was an undo.
  /// \return true if it's possible to redo the last action, false otherwise.
  
  /** Determines whether a source buffer can redo the last action
   * (i.e.\ if the last operation was an undo).
   * @return <tt>true</tt> if a redo is possible.
   */
  bool can_redo() const;

  /// \brief Undoes the last user action which modified the buffer.
  ///
  /// Use SourceBuffer::can_undo() to check whether
  /// a call to this function will have any effect.
  /// Actions are defined as groups of operations
  /// between a call to TextBuffer::begin_user_action()
  /// and TextBuffer::end_user_action(),
  /// or sequences of similar edits
  /// (inserts or deletes) on the same line.
  
  /** Undoes the last user action which modified the buffer.  Use
   * can_undo() to check whether a call to this
   * function will have any effect.
   * 
   * Actions are defined as groups of operations between a call to
   * gtk_text_buffer_begin_user_action() and
   * gtk_text_buffer_end_user_action(), or sequences of similar edits
   * (inserts or deletes) on the same line.
   */
  void undo();

  /// \brief redoes the last undo operation.
  ///
  /// Use SourceBuffer::can_redo() to check whether
  /// a call to this function will have any effect.
  
  /** Redoes the last undo operation.  Use can_redo()
   * to check whether a call to this function will have any effect.
   */
  void redo();

  /// \brief  Marks the beginning of a not undoable action on the buffer, disabling the undo manager.
  ///
  /// Typically you would call this function before
  /// initially setting the contents of the buffer (e.g. when loading a file in a text editor).
  /// You may nest SourceBuffer::begin_not_undoable_action() / SourceBuffer::end_not_undoable_action() blocks.
  
  /** Marks the beginning of a not undoable action on the buffer,
   * disabling the undo manager.  Typically you would call this function
   * before initially setting the contents of the buffer (e.g. when
   * loading a file in a text editor).
   * 
   * You may nest begin_not_undoable_action() /
   * end_not_undoable_action() blocks.
   */
  void begin_not_undoable_action();

  /// \brief  Marks the end of a not undoable action on the buffer.
  ///
  /// When the last not undoable block is closed through the call to this function,
  /// the list of undo actions is cleared and the undo manager is re-enabled.
  
  /** Marks the end of a not undoable action on the buffer.  When the
   * last not undoable block is closed through the call to this
   * function, the list of undo actions is cleared and the undo manager
   * is re-enabled.
   */
  void end_not_undoable_action();

  /// \brief Moves iter to the position of the previous GtkSourceMark of the
  /// given category.
  ///
  /// Returns true if iter was moved. If category is NULL, the
  /// previous source mark can be of any category.
  ///
  /// \param iter the iterator to consider.
  /// \param category the category to search for or NULL.
  /// \return true if iter moved, false otherwise.
  
  bool backward_iter_to_source_mark(Gtk::TextIter& iter, const Glib::ustring& category);
  // overload with category == NULL
  bool backward_iter_to_source_mark(Gtk::TextIter& iter);

  /// \brief Moves iter to the position of the next #SourceMark of the given
  /// category.
  ///
  /// Returns true if iter was moved. If category is NULL, the next
  /// source mark can be of any category.
  /// \param iter the iterator to move.
  /// \param category the category to search for, or NULL.
  /// \return true if iter moved, false otherwise.
  
  bool forward_iter_to_source_mark(Gtk::TextIter& iter, const Glib::ustring& category);

  /// \brief Moves iter to the position of the next #SourceMark
  ///
  /// Returns true if iter was moved. The category of the next #SourceMark
  /// is considered to be NULL so that #SourceMark can be of any category.
  ///
  /// \param iter the iterator to move.
  /// \return true if iter moved, false otherwise.
  bool forward_iter_to_source_mark(Gtk::TextIter& iter);

  /// \brief Forces buffer to analyze and highlight the given area
  /// synchronously.
  ///
  /// \param start start of the area to highlight.
  /// \param end end of the area to highlight.
  
  /** Forces buffer to analyze and highlight the given area synchronously.
   * 
   * &lt;note&gt;
   * 
   * This is a potentially slow operation and should be used only
   * when you need to make sure that some text not currently
   * visible is highlighted, for instance before printing.
   * 
   * &lt;/note&gt;
   * @param start Start of the area to highlight.
   * @param end End of the area to highlight.
   */
  void ensure_highlight(const Gtk::TextIter& start, const Gtk::TextIter& end);

  /// \brief Sets style scheme used by the buffer.
  ///
  /// \param scheme the style scheme to be used by the buffer
  
  /** Sets style scheme used by the buffer.
   * @param scheme Style scheme.
   */
  void set_style_scheme(const Glib::RefPtr<SourceStyleScheme>& scheme);

  /// \brief Returns the style scheme currently used by the buffer.
  ///
  /// \return the style scheme currently used the buffer.
  
  /** Returns: the Gtk::SourceStyleScheme set by
   * @return The Gtk::SourceStyleScheme set by
   * set_style_scheme(), or <tt>0</tt>.
   */
  Glib::RefPtr<SourceStyleScheme> get_style_scheme();

  /// \brief Returns the style scheme currently used by the buffer.
  ///
  /// This method is const and returns a const value.
  
  /** Returns: the Gtk::SourceStyleScheme set by
   * @return The Gtk::SourceStyleScheme set by
   * set_style_scheme(), or <tt>0</tt>.
   */
  Glib::RefPtr<const SourceStyleScheme> get_style_scheme() const;

  /// \brief Creates a source mark in the buffer of category #category.
  ///
  /// A source mark is a Gtk::TextMark but organised into categories. Depending on
  /// the category a pixbuf can be specified that will be displayed along the
  /// line of the mark.
  /// Like a Gtk::TextMark, a #SourceMark can be anonymous if the passed name is
  /// NULL.
  ///
  /// Note that the buffer owns the marks.
  ///
  /// Marks always have left gravity and are moved to the beginning of the line
  /// when the user deletes the line they were in.
  /// Typical uses for a source mark are bookmarks, breakpoints, current executing
  /// instruction indication in a source file, etc..
  ///
  /// \param name the name of the mark, can be "".
  /// \param category a string defining the mark category.
  /// \param where location where to place the mark.
  /// \return the newly created #SourceMark
  
  Glib::RefPtr<SourceMark> create_source_mark(const Glib::ustring& name, const Glib::ustring& category, const Gtk::TextIter& where);

 
   /// \brief Returns the list of marks of the given category at line.
   ///
   /// If category is NULL, all marks at line are returned.
   ///
   /// \param line the line number to consider.
   /// \param category category to search for or NULL.
   /// \param a newly allocated GSList.
   /// \return the list of marks.
  
  Glib::SListHandle<Glib::RefPtr<SourceMark> > get_source_marks_at_line(int line, const Glib::ustring& category) const;

   /// \brief Returns all source marks marks at line.
   ///
   /// \param line the line number to consider.
   /// \param a newly allocated GSList.
   /// \return the list of marks.
  Glib::SListHandle<Glib::RefPtr<SourceMark> > get_source_marks_at_line(int line) const;

  /// \brief returns the list of marks of the given category at a given
  /// itertor.
  ///
  /// If category is NULL it returns all marks at iter.
  ///
  /// \param iter the iterator to consider.
  /// \param category the category to search for, or NULL.
  
  Glib::SListHandle<Glib::RefPtr<SourceMark> > get_source_marks_at_iter(Gtk::TextIter& iter, const Glib::ustring& category) const;

  /// \brief returns all the marks at a given iterator.
  ///
  /// \param iter the iterator to consider.
  Glib::SListHandle<Glib::RefPtr<SourceMark> > get_source_marks_at_iter(Gtk::TextIter& iter) const;

  /// \brief Remove all marks of a given category, from a given region of the
  //// buffer
  ///
  /// If category is NULL, all marks in the range will be removed.
  ///
  /// \param start the begining of the region to consider
  /// \param end the end of the region to consider.
  /// \param category the category of the marks to consider.
  
  void remove_source_marks(const Gtk::TextIter& start, const Gtk::TextIter& end, const Glib::ustring& category);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to highlight syntax in the buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_highlight_syntax() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to highlight syntax in the buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_highlight_syntax() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to highlight matching brackets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_highlight_matching_brackets() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to highlight matching brackets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_highlight_matching_brackets() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of undo levels for the buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max_undo_levels() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of undo levels for the buffer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_undo_levels() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Language object to get highlighting patterns from.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<SourceLanguage> > property_language() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Language object to get highlighting patterns from.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SourceLanguage> > property_language() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether Undo operation is possible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_can_undo() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether Redo operation is possible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_can_redo() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Style scheme.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<SourceStyleScheme> > property_style_scheme() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Style scheme.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SourceStyleScheme> > property_style_scheme() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /// \name signals
  /// @{

  /// \brief Emitted whenever the syntax highlighting information has been updated,
  /// so that views can request a redraw if the region changed is visible.
  ///
  /// Usually only view widgets displaying this buffer will be interested in this signal.
  /// parameter start: an iterator at the start of the updated region.
  /// parameter end: and iterator at the end of the updated region.
  
  /**
   * @par Prototype:
   * <tt>void on_my_%highlight_updated(Gtk::TextIter& start, Gtk::TextIter& end)</tt>
   */

  Glib::SignalProxy2< void,Gtk::TextIter&,Gtk::TextIter& > signal_highlight_updated();


  /// \brief Emitted whenever a marker of sourcebuffer has changed and needs to be redisplayed by the view.
  ///
  /// A change in a marker's type or location can trigger this signal.
  /// Note that moving a marker causes the emission of this signal twice: one for the old location and one for the new. 
  /// parameter where:  an iterator at the location where the change occurred.
  
  /**
   * @par Prototype:
   * <tt>void on_my_%source_mark_updated(const Glib::RefPtr<SourceMark>& where)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<SourceMark>& > signal_source_mark_updated();

  /// @}


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} /* namespace gtksourceview */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates gtksourceview::SourceBuffer
   */
  Glib::RefPtr<gtksourceview::SourceBuffer> wrap(GtkSourceBuffer* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_SOURCEBUFFER_H */

