/*******************************************************************************************************************************************
 cdemomodule.h
 GtkOL demo module abstract basic API.
*******************************************************************************************************************************************/

#ifndef __CDEMOMODULE_H__
#define __CDEMOMODULE_H__

#include "cmetamodule.h"
#include "capplication.h"

// demo modules path constant

#ifdef GTKOL_DEMO_MODS_DIR
const static CString DEMO_MODULES_PATH (GTKOL_DEMO_MODS_DIR);
#else
const static CString DEMO_MODULES_PATH ("/usr/lib/gtkol-demo/");
#endif

//-----------------------------------------------------------------------------------------------------------------------------------------
// module description definition
//-----------------------------------------------------------------------------------------------------------------------------------------
struct TDemoModuleDescription
{
	CString		Name;		// the module friendly name
	CString		Description;	// the module description
	CString		FileName;	// the module source file name
	CLayout *	Layout;		// the module potential extra demo widgets
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoModule class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoModule : public CMetaModule
{
	// instanciation section
	public :

		CDemoModule			();
		virtual ~CDemoModule		();

	// abstract demo module simple API
	public :

		// get the module description, this function may be called multiple times by the gui core so be worried to not instanciate 
		// potential description layout parameter if it has already been
		virtual TDemoModuleDescription	GetDescription		() const 		=0;

		// run the demo on the specified gtkol application instance
		virtual void			Run			(CApplication *inOwner)	=0;

		// stop the demo 
		virtual void			Stop			()			=0;

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_GENERIC_METACLASS ('demo', CDemoModule, CMetaModule);

#endif
