/* GtkDatabox - An extension to the gtk+ library
 * Copyright (C) 1998 - 2005  Dr. Roland Bock
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include <stdio.h>

#include <gtk/gtk.h>
#include <gtkdatabox.h>
#include <math.h>
/* Some versions of math.h have a PI problem... */
#ifndef PI
#define PI 3.14159265358979323846
#endif

#define POINTS 2000

/*----------------------------------------------------------------
 *  databox cross
 *----------------------------------------------------------------*/


static void
create_cross (void)
{
   GtkWidget *window = NULL;
   GtkWidget *box1;
   GtkWidget *box2;
   GtkWidget *close_button;
   GtkWidget *box;
   GtkWidget *label;
   GtkWidget *separator;
   gint index;
   gfloat *X;
   gfloat *Y;
   GdkColor color;
   gint i;

   window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_size_request (window, 500, 500);

   g_signal_connect (GTK_OBJECT (window), "destroy",
		     GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

   gtk_window_set_title (GTK_WINDOW (window),
			 "GtkDatabox: Coordinate System Example");
   gtk_container_set_border_width (GTK_CONTAINER (window), 0);

   box1 = gtk_vbox_new (FALSE, 0);
   gtk_container_add (GTK_CONTAINER (window), box1);

   label =
      gtk_label_new
      ("Just to show how a coordinate system does look like...\nCurrently you can only configure color and line width.\nNo ticks or other fancy stuff, sorry.\nIf you would like to have a nicer one\nplease let me know (and send some code :-))\n\nFor basic understanding see basics :-)");
   gtk_box_pack_start (GTK_BOX (box1), label, FALSE, FALSE, 0);
   separator = gtk_hseparator_new ();
   gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, FALSE, 0);

   box = gtk_databox_new ();
   g_signal_connect (GTK_OBJECT (box), "destroy",
		     GTK_SIGNAL_FUNC (gtk_databox_data_destroy_all), NULL);

   X = g_new0 (gfloat, POINTS);
   Y = g_new0 (gfloat, POINTS);

   for (i = 0; i < POINTS; i++)
   {
      X[i] = i;
      Y[i] = 100. * sin (i * 2 * PI / POINTS);
   }
   color.red = 0;
   color.green = 65535;
   color.blue = 0;

   index = gtk_databox_data_add_x_y (GTK_DATABOX (box), POINTS,
				     X, Y, color, GTK_DATABOX_POINTS, 3);
   Y = g_new0 (gfloat, POINTS);

   for (i = 0; i < POINTS; i++)
   {
      Y[i] = 100. * cos (i * 2 * PI / POINTS);
   }
   color.red = 65535;
   color.green = 0;
   color.blue = 0;

   gtk_databox_data_add_y (GTK_DATABOX (box), POINTS,
			   Y, index, color, GTK_DATABOX_POINTS, 3);

   /* Here comes the cross stuff. 
    * It might look a bit perverted at first glance, but it 
    * has a lot of charme to be able to handle it this way
    */
   color.red = 0;
   color.green = 0;
   color.blue = 65535;

   index = gtk_databox_data_add_y (GTK_DATABOX (box), POINTS,
				   Y, index, color,
				   GTK_DATABOX_CROSS_SIMPLE, 2);

   gtk_databox_rescale (GTK_DATABOX (box));

   gtk_box_pack_start (GTK_BOX (box1), box, TRUE, TRUE, 0);

   separator = gtk_hseparator_new ();
   gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);

   box2 = gtk_vbox_new (FALSE, 10);
   gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
   gtk_box_pack_end (GTK_BOX (box1), box2, FALSE, TRUE, 0);
   close_button = gtk_button_new_with_label ("close");
   g_signal_connect_swapped (GTK_OBJECT (close_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_main_quit),
			     GTK_OBJECT (box));
   gtk_box_pack_start (GTK_BOX (box2), close_button, TRUE, TRUE, 0);
   GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);
   gtk_widget_grab_default (close_button);

   gtk_widget_show_all (window);

}

gint
main (gint argc, char *argv[])
{
   gtk_init (&argc, &argv);

   create_cross ();
   gtk_main ();

   return 0;
}
