/*
 * @(#)TestMonitorRunnableUTest.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.junit.v1;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.io.IOException;
import java.lang.reflect.Method;


/**
 * Tests the TestMonitorRunnable class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     July 12, 2003
 * @version   $Date: 2003/07/15 16:09:25 $
 */
public class TestMonitorRunnableUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = TestMonitorRunnableUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public TestMonitorRunnableUTest( String name )
    {
        super( name );
    }

    


    //-------------------------------------------------------------------------
    // Inner classes
    
    private static class MyTestMonitorRunnable1 extends TestMonitorRunnable
    {
        Throwable t;
        public MyTestMonitorRunnable1( Throwable t )
        {
            this.t = t;
        }
        
        public void runMonitor() throws Throwable
        {
            if (this.t != null)
            {
                throw this.t;
            }
        }
    }
    
    private static class MyTestRunnable extends TestRunnable
    {
        Throwable t;
        public MyTestRunnable( Throwable t )
        {
            this.t = t;
        }
        
        public void runTest() throws Throwable
        {
            if (this.t != null)
            {
                throw this.t;
            }
        }
    }
    
    
    //-------------------------------------------------------------------------
    // Tests
    
    public void testRun1()
    {
        DOC.getLog().warn( "No tests for this class by itself: it is covered "+
            "completely by the TestRunnable and MTTR tests." );
    }
    
    
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    
    protected TestRunnable createTestRunnable( Throwable throwThis )
    {
        return new MyTestRunnable( throwThis );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

