#ifndef GPUARRAY_CONFIG
#define GPUARRAY_CONFIG

/* The following included file should have been generated by CMake. */
#include <gpuarray/abi_version.h>
#define GPUARRAY_API_VERSION 1

#ifdef GPUARRAY_SHARED
 #ifdef _WIN32
  #ifdef GPUARRAY_BUILDING_DLL
   #define GPUARRAY_PUBLIC __declspec(dllexport)
  #else
   #define GPUARRAY_PUBLIC __declspec(dllimport)
  #endif
 #else
  #if __GNUC__ >= 4
   #define GPUARRAY_PUBLIC __attribute__((visibility ("default")))
  #else
   #error "Don't know how to export symbols on this platform"
  #endif
 #endif
#else
 #define GPUARRAY_PUBLIC
#endif

#ifdef _MSC_VER
#include <stddef.h>
#ifndef inline
#define inline __inline
#endif
#if _MSC_VER < 1600
#include <gpuarray/wincompat/stdint.h>
#else
#include <stdint.h>    
#endif
#define ssize_t intptr_t
#define SSIZE_MAX INTPTR_MAX
#else
#include <sys/types.h>
#include <stdint.h>
#endif

#endif
