------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2001-2015, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Strings; use GNAT.Strings;
with GNATCOLL.Traces;  use GNATCOLL.Traces;

package Traces2_Support is

   type My_Stream is new GNATCOLL.Traces.Trace_Stream_Record with record
      Args : GNAT.Strings.String_Access;
   end record;
   overriding procedure Put (Stream : in out My_Stream; Str : String);
   overriding procedure Newline (Stream : in out My_Stream);
   overriding procedure Close (Stream : in out My_Stream);

   type Factory is new Stream_Factory with null record;
   overriding function New_Stream
     (Fact : Factory; Args : String) return Trace_Stream;

   type My_Decorator is
      new GNATCOLL.Traces.Trace_Handle_Record with null record;
   overriding procedure Pre_Decorator
     (Handle  : in out My_Decorator;
      Stream  : in out Trace_Stream_Record'Class;
      Message : String);
   overriding procedure Post_Decorator
     (Handle   : in out My_Decorator;
      Stream   : in out Trace_Stream_Record'Class;
      Location : String;
      Entity   : String;
      Message  : String);
   --  This is meant to be used as a global decorator

   function My_Decorator_Factory return Trace_Handle;

   type My_Handle is new GNATCOLL.Traces.Trace_Handle_Record with null record;
   overriding procedure Pre_Decorator
     (Handle  : in out My_Handle;
      Stream  : in out Trace_Stream_Record'Class;
      Message : String);
   overriding procedure Post_Decorator
     (Handle   : in out My_Handle;
      Stream   : in out Trace_Stream_Record'Class;
      Location : String;
      Entity   : String;
      Message  : String);
   --  a custom stream with its own decorator

   function My_Handle_Factory return Trace_Handle;

end Traces2_Support;
