#line 59 "../noweb/o_line_basic.nw"
/* gEDA - GPL Electronic Design Automation
 * libgeda - gEDA's library
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 11 "../noweb/o_line_basic.nw"
/* DO NOT read or edit this file ! Use ../noweb/o_line_basic.nw instead */

#line 81 "../noweb/o_line_basic.nw"
#include <config.h>

#include <stdio.h>
#include <math.h>

#include <gtk/gtk.h>
#include <guile/gh.h>

#ifdef HAS_LIBGDGEDA
#include <gdgeda/gd.h>
#endif

#include "defines.h"
#include "struct.h"
#include "globals.h"
#include "o_types.h"
#include "colors.h"
#include "funcs.h"

#include "../include/prototype.h"


#line 123 "../noweb/o_line_basic.nw"
OBJECT *o_line_add(TOPLEVEL * w_current, OBJECT * object_list,
		   char type, int color, int x1, int y1, int x2, int y2)
{
  OBJECT *new_node;


#line 145 "../noweb/o_line_basic.nw"
/* create the object */
  new_node = s_basic_init_object("line");
  new_node->type = type;
  new_node->color = color;

  new_node->line = (LINE *) malloc(sizeof(LINE));


#line 132 "../noweb/o_line_basic.nw"

#line 156 "../noweb/o_line_basic.nw"
/* describe the line with its two ends */
  new_node->line->x[0] = x1;
  new_node->line->y[0] = y1;
  new_node->line->x[1] = x2;
  new_node->line->y[1] = y2;

/* line type and filling initialized to default */
  o_set_line_options(w_current, new_node, END_NONE, TYPE_SOLID, 0, -1, -1);
  o_set_fill_options(w_current, new_node,
		     FILLING_HOLLOW, -1, -1, -1, -1, -1);

/* TODO: questionable cast */
  new_node->draw_func = (void *) line_draw_func;
/* TODO: questionable cast */
  new_node->sel_func = (void *) select_func;


#line 134 "../noweb/o_line_basic.nw"

#line 177 "../noweb/o_line_basic.nw"
/* compute bounding box and screen coords */
  o_line_recalc(w_current, new_node);


#line 136 "../noweb/o_line_basic.nw"

#line 184 "../noweb/o_line_basic.nw"
  object_list = (OBJECT *) s_basic_link_object(new_node, object_list);

#line 137 "../noweb/o_line_basic.nw"

  return (object_list);
}


#line 198 "../noweb/o_line_basic.nw"
OBJECT *o_line_copy(TOPLEVEL * w_current, OBJECT * list_tail,
		    OBJECT * o_current)
{
  OBJECT *new_obj;
  ATTRIB *a_current;
  int color;

  if (o_current->saved_color == -1) {
    color = o_current->color;
  } else {
    color = o_current->saved_color;
  }


#line 227 "../noweb/o_line_basic.nw"
/* create a new line object */
  new_obj = o_line_add(w_current, list_tail, OBJ_LINE, color, 0, 0, 0, 0);


#line 213 "../noweb/o_line_basic.nw"

#line 240 "../noweb/o_line_basic.nw"
/* modify the line ends of the new line */
  new_obj->line->x[0] = o_current->line->x[0];
  new_obj->line->y[0] = o_current->line->y[0];
  new_obj->line->x[1] = o_current->line->x[1];
  new_obj->line->y[1] = o_current->line->y[1];

/* copy the line type and filling options */
  o_set_line_options(w_current, new_obj, o_current->line_end,
		     o_current->line_type, o_current->line_width,
		     o_current->line_length, o_current->line_space);
  o_set_fill_options(w_current, new_obj,
		     o_current->fill_type, o_current->fill_width,
		     o_current->fill_pitch1, o_current->fill_angle1,
		     o_current->fill_pitch2, o_current->fill_angle2);

/* calc the screen coords */
  o_line_recalc(w_current, o_current);


#line 215 "../noweb/o_line_basic.nw"

#line 262 "../noweb/o_line_basic.nw"
/*	new_obj->attribute = 0;*/
  a_current = o_current->attribs;
  if (a_current) {
    while (a_current) {

      /* head attrib node has prev = NULL */
      if (a_current->prev != NULL) {
	a_current->copied_to = new_obj;
      }
      a_current = a_current->next;
    }
  }

#line 217 "../noweb/o_line_basic.nw"
  /* return the new tail of the object list */
  return (new_obj);
}


#line 287 "../noweb/o_line_basic.nw"
/* pb20011009 - modified */
void
o_line_modify(TOPLEVEL * w_current, OBJECT * object,
	      int x, int y, int whichone)
{
  /* change one of the end of the line */
  switch (whichone) {
  case LINE_END1:
    object->line->x[0] = x;
    object->line->y[0] = y;
    break;

  case LINE_END2:
    object->line->x[1] = x;
    object->line->y[1] = y;
    break;

  default:
    return;
  }

  /* recalculate the screen coords and the boundings */
  o_line_recalc(w_current, object);

}


#line 332 "../noweb/o_line_basic.nw"
OBJECT *o_line_read(TOPLEVEL * w_current, OBJECT * object_list, char buf[],
		    unsigned int release_ver, unsigned int fileformat_ver)
{
  char type;
  int x1, y1;
  int x2, y2;
  int d_x1, d_y1;
  int d_x2, d_y2;
  int line_width, line_space, line_length;
  int line_end;
  int line_type;
  int color;

  if (release_ver <= VERSION_20000704) {

#line 372 "../noweb/o_line_basic.nw"
    sscanf(buf, "%c %d %d %d %d %d\n", &type, &x1, &y1, &x2, &y2, &color);

    line_width = 0;
    line_end = END_NONE;
    line_type = TYPE_SOLID;
    line_length = -1;
    line_space = -1;


#line 349 "../noweb/o_line_basic.nw"
  } else {

#line 387 "../noweb/o_line_basic.nw"
    sscanf(buf, "%c %d %d %d %d %d %d %d %d %d %d\n", &type,
	   &x1, &y1, &x2, &y2, &color,
	   &line_width, &line_end, &line_type, &line_length, &line_space);

#line 351 "../noweb/o_line_basic.nw"

  }

  d_x1 = x1;			/* PB : Needed ? */
  d_y1 = y1;
  d_x2 = x2;
  d_y2 = y2;


#line 399 "../noweb/o_line_basic.nw"
  if (x1 == x2 && y1 == y2) {
    fprintf(stderr, "Found a zero length line [ %c %d %d %d %d %d ]\n",
	    type, x1, y1, x2, y2, color);
    s_log_message("Found a zero length line [ %c %d %d %d %d %d ]\n",
		  type, x1, y1, x2, y2, color);
  }

  if (color < 0 || color > MAX_COLORS) {
    fprintf(stderr, "Found an invalid color [ %s ]\n", buf);
    s_log_message("Found an invalid color [ %s ]\n", buf);
    s_log_message("Setting color to WHITE\n");
    color = WHITE;
  }

#line 361 "../noweb/o_line_basic.nw"

#line 419 "../noweb/o_line_basic.nw"
/* create and add the line to the list */
  object_list = o_line_add(w_current, object_list,
			   type, color, d_x1, d_y1, d_x2, d_y2);
/* set its line options */
  o_set_line_options(w_current, object_list,
		     line_end, line_type, line_width, line_length,
		     line_space);
/* filling is irrelevant for line, just set to default */
  o_set_fill_options(w_current, object_list,
		     FILLING_HOLLOW, -1, -1, -1, -1, -1);

#line 362 "../noweb/o_line_basic.nw"

  return (object_list);
}

#line 443 "../noweb/o_line_basic.nw"
char *o_line_save(OBJECT * object)
{
  int x1, x2, y1, y2;
  int color;
  int line_width, line_space, line_length;
  char *buf;
  OBJECT_END line_end;
  OBJECT_TYPE line_type;


#line 464 "../noweb/o_line_basic.nw"
/* get the two ends */
  x1 = object->line->x[0];
  y1 = object->line->y[0];
  x2 = object->line->x[1];
  y2 = object->line->y[1];

/* description of the line type */
  line_width = object->line_width;
  line_end = object->line_end;
  line_type = object->line_type;
  line_length = object->line_length;
  line_space = object->line_space;

/* Use the right color */
  if (object->saved_color == -1) {
    color = object->color;
  } else {
    color = object->saved_color;
  }


#line 455 "../noweb/o_line_basic.nw"

#line 488 "../noweb/o_line_basic.nw"
  buf = g_strdup_printf("%c %d %d %d %d %d %d %d %d %d %d", object->type,
			x1, y1, x2, y2, color,
			line_width, line_end, line_type, line_length,
			line_space);

#line 456 "../noweb/o_line_basic.nw"

  return (buf);
}


#line 502 "../noweb/o_line_basic.nw"
void
o_line_translate(TOPLEVEL * w_current, int dx, int dy, OBJECT * object)
{
  int x, y;

  if (object == NULL)
    printf("lt NO!\n");


#line 519 "../noweb/o_line_basic.nw"
/* Do screen coords */
  object->line->screen_x[0] = object->line->screen_x[0] + dx;
  object->line->screen_y[0] = object->line->screen_y[0] + dy;
  object->line->screen_x[1] = object->line->screen_x[1] + dx;
  object->line->screen_y[1] = object->line->screen_y[1] + dy;


#line 511 "../noweb/o_line_basic.nw"

#line 529 "../noweb/o_line_basic.nw"
/* do we want snap grid here? hack */
  SCREENtoWORLD(w_current,
		object->line->screen_x[0], object->line->screen_y[0],
		&x, &y);
  object->line->x[0] = snap_grid(w_current, x);
  object->line->y[0] = snap_grid(w_current, y);

  SCREENtoWORLD(w_current,
		object->line->screen_x[1], object->line->screen_y[1],
		&x, &y);
  object->line->x[1] = snap_grid(w_current, x);
  object->line->y[1] = snap_grid(w_current, y);

#line 512 "../noweb/o_line_basic.nw"

}

#line 552 "../noweb/o_line_basic.nw"
void
o_line_translate_world(TOPLEVEL * w_current, int x1, int y1,
		       OBJECT * object)
{
  int screen_x1, screen_y1;
  int screen_x2, screen_y2;
  int left, right, top, bottom;

  if (object == NULL)
    printf("ltw NO!\n");


#line 571 "../noweb/o_line_basic.nw"
/* Do world coords */
  object->line->x[0] = object->line->x[0] + x1;
  object->line->y[0] = object->line->y[0] + y1;
  object->line->x[1] = object->line->x[1] + x1;
  object->line->y[1] = object->line->y[1] + y1;


#line 563 "../noweb/o_line_basic.nw"

#line 581 "../noweb/o_line_basic.nw"
/* update screen coords */
  WORLDtoSCREEN(w_current, object->line->x[0],
		object->line->y[0], &screen_x1, &screen_y1);
  object->line->screen_x[0] = screen_x1;
  object->line->screen_y[0] = screen_y1;

  WORLDtoSCREEN(w_current, object->line->x[1],
		object->line->y[1], &screen_x2, &screen_y2);
  object->line->screen_x[1] = screen_x2;
  object->line->screen_y[1] = screen_y2;

/* update bounding box */
  get_line_bounds(w_current, object->line, &left, &top, &right, &bottom);

  object->left = left;
  object->top = top;
  object->right = right;
  object->bottom = bottom;

#line 564 "../noweb/o_line_basic.nw"

}


#line 618 "../noweb/o_line_basic.nw"
/* takes in screen coordinates for the centerx,y, and then does the rotate 
 * in world space */
/* also ignores angle argument... for now, rotate only in 90 degree 
 * increments */
void
o_line_rotate(TOPLEVEL * w_current, int centerx, int centery, int angle,
	      OBJECT * object)
{
  int world_centerx, world_centery;

  /* convert the center of rotation to world unit */
  SCREENtoWORLD(w_current, centerx, centery,
		&world_centerx, &world_centery);

  /* rotate the line */
  /* the check on the rotation angle is in o_line_rotate_world() */
  o_line_rotate_world(w_current,
		      world_centerx, world_centery, angle, object);

}

#line 652 "../noweb/o_line_basic.nw"
void
o_line_rotate_world(TOPLEVEL * w_current,
		    int world_centerx, int world_centery, int angle,
		    OBJECT * object)
{
  int newx, newy;

  if (angle == 0)
    return;


#line 672 "../noweb/o_line_basic.nw"
/* angle must be positive */
  if (angle < 0)
    angle = -angle;
/* angle must be 90 multiple or no rotation performed */
  if ((angle % 90) != 0)
    return;


#line 664 "../noweb/o_line_basic.nw"

#line 683 "../noweb/o_line_basic.nw"
/* translate object to origin */
  o_line_translate_world(w_current, -world_centerx, -world_centery,
			 object);

/* rotate line end 1 */
  rotate_point_90(object->line->x[0], object->line->y[0], angle,
		  &newx, &newy);

  object->line->x[0] = newx;
  object->line->y[0] = newy;

/* rotate line end 2 */
  rotate_point_90(object->line->x[1], object->line->y[1], angle,
		  &newx, &newy);

  object->line->x[1] = newx;
  object->line->y[1] = newy;

/* translate object back to normal position */
  o_line_translate_world(w_current, world_centerx, world_centery, object);


#line 666 "../noweb/o_line_basic.nw"
}


#line 715 "../noweb/o_line_basic.nw"
void
o_line_mirror(TOPLEVEL * w_current,
	      int centerx, int centery, OBJECT * object)
{
  int world_centerx, world_centery;

  /* convert the origin of mirror */
  SCREENtoWORLD(w_current, centerx, centery,
		&world_centerx, &world_centery);

  /* apply the mirror in world coords */
  o_line_mirror_world(w_current, world_centerx, world_centery, object);

}

#line 746 "../noweb/o_line_basic.nw"
void
o_line_mirror_world(TOPLEVEL * w_current, int world_centerx,
		    int world_centery, OBJECT * object)
{
  /* translate object to origin */
  o_line_translate_world(w_current, -world_centerx, -world_centery,
			 object);

  /* mirror the line ends */
  object->line->x[0] = -object->line->x[0];
  object->line->x[1] = -object->line->x[1];

  /* translate back in position */
  o_line_translate_world(w_current, world_centerx, world_centery, object);

}


#line 774 "../noweb/o_line_basic.nw"
void o_line_recalc(TOPLEVEL * w_current, OBJECT * o_current)
{
  int screen_x1, screen_y1;
  int screen_x2, screen_y2;
  int left, right, top, bottom;

  if (o_current->line == NULL) {
    return;
  }

#line 797 "../noweb/o_line_basic.nw"
/* update the screen coords of end 1 of the line */
  WORLDtoSCREEN(w_current,
		o_current->line->x[0], o_current->line->y[0],
		&screen_x1, &screen_y1);
  o_current->line->screen_x[0] = screen_x1;
  o_current->line->screen_y[0] = screen_y1;

/* update the screen coords of end 2 of the line */
  WORLDtoSCREEN(w_current,
		o_current->line->x[1], o_current->line->y[1],
		&screen_x2, &screen_y2);
  o_current->line->screen_x[1] = screen_x2;
  o_current->line->screen_y[1] = screen_y2;


#line 787 "../noweb/o_line_basic.nw"

#line 815 "../noweb/o_line_basic.nw"
/* update the bounding box - screen unit */
  get_line_bounds(w_current, o_current->line,
		  &left, &top, &right, &bottom);
  o_current->left = left;
  o_current->top = top;
  o_current->right = right;
  o_current->bottom = bottom;


#line 789 "../noweb/o_line_basic.nw"

#line 827 "../noweb/o_line_basic.nw"
/* recalc OBJECT specific parameters */
  o_object_recalc(w_current, o_current);

#line 790 "../noweb/o_line_basic.nw"

}


#line 840 "../noweb/o_line_basic.nw"
void
get_line_bounds(TOPLEVEL * w_current, LINE * line, int *left, int *top,
		int *right, int *bottom)
{
  *left = w_current->width;
  *top = w_current->height;
  *right = 0;
  *bottom = 0;

  if (line->screen_x[0] < *left)
    *left = line->screen_x[0];
  if (line->screen_x[0] > *right)
    *right = line->screen_x[0];
  if (line->screen_y[0] < *top)
    *top = line->screen_y[0];
  if (line->screen_y[0] > *bottom)
    *bottom = line->screen_y[0];

  if (line->screen_x[1] < *left)
    *left = line->screen_x[1];
  if (line->screen_x[1] > *right)
    *right = line->screen_x[1];
  if (line->screen_y[1] < *top)
    *top = line->screen_y[1];
  if (line->screen_y[1] > *bottom)
    *bottom = line->screen_y[1];

  /* PB : bounding box has to take into account the width of the line */
  /* PB : but line width is unknown here */

  *left = *left - 4;
  *top = *top - 4;
  *right = *right + 4;
  *bottom = *bottom + 4;
}

#line 878 "../noweb/o_line_basic.nw"
void
world_get_line_bounds(TOPLEVEL * w_current, LINE * line, int *left,
		      int *top, int *right, int *bottom)
{
  *left = w_current->init_right;
  *top = w_current->init_bottom;
  *right = 0;
  *bottom = 0;

  if (line->x[0] < *left)
    *left = line->x[0];
  if (line->x[0] > *right)
    *right = line->x[0];
  if (line->y[0] < *top)
    *top = line->y[0];
  if (line->y[0] > *bottom)
    *bottom = line->y[0];

  if (line->x[1] < *left)
    *left = line->x[1];
  if (line->x[1] > *right)
    *right = line->x[1];
  if (line->y[1] < *top)
    *top = line->y[1];
  if (line->y[1] > *bottom)
    *bottom = line->y[1];

}


#line 912 "../noweb/o_line_basic.nw"
void
o_line_print(TOPLEVEL * w_current, FILE * fp, OBJECT * o_current,
	     int origin_x, int origin_y)
{
  int x1, y1, x2, y2;
  int color;
  int line_width, length, space;
  void (*outl_func) () = NULL;

  if (o_current == NULL) {
    printf("got null in o_line_print\n");
    return;
  }

  x1 = o_current->line->x[0];
  y1 = o_current->line->y[0];
  x2 = o_current->line->x[1];
  y2 = o_current->line->y[1];
  color = o_current->color;


#line 946 "../noweb/o_line_basic.nw"
  line_width = o_current->line_width;
  length = o_current->line_length;
  space = o_current->line_space;

  switch (o_current->line_type) {
  case (TYPE_SOLID):
    length = -1;
    space = -1;
    outl_func = (void *) o_line_print_solid;
    break;

  case (TYPE_DOTTED):
    length = -1;
    outl_func = (void *) o_line_print_dotted;
    break;

  case (TYPE_DASHED):
    outl_func = (void *) o_line_print_dashed;
    break;

  case (TYPE_CENTER):
    outl_func = (void *) o_line_print_center;
    break;

  case (TYPE_PHANTOM):
    outl_func = (void *) o_line_print_phantom;
    break;

  case (TYPE_ERASE):
    /* Unused for now, print it solid */
    length = -1;
    space = -1;
    outl_func = (void *) o_line_print_solid;
    break;
  }

  if ((length == 0) || (space == 0)) {
    length = -1;
    space = -1;
    outl_func = (void *) o_line_print_solid;
  }

  (*outl_func) (w_current, fp,
		x1 - origin_x, y1 - origin_y,
		x2 - origin_x, y2 - origin_y,
		color, line_width, length, space, origin_x, origin_y);


#line 934 "../noweb/o_line_basic.nw"
}

#line 1006 "../noweb/o_line_basic.nw"
void
o_line_print_solid(TOPLEVEL * w_current, FILE * fp,
		   int x1, int y1, int x2, int y2,
		   int color,
		   int line_width, int length, int space,
		   int origin_x, int origin_y)
{

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, line_width);

  fprintf(fp, "newpath\n");
  fprintf(fp, "%d mils %d mils moveto\n", x1, y1);
  fprintf(fp, "%d mils %d mils lineto\n", x2, y2);
  fprintf(fp, "stroke\n");
  fprintf(fp, "grestore\n");

}

#line 1047 "../noweb/o_line_basic.nw"
void
o_line_print_dotted(TOPLEVEL * w_current, FILE * fp,
		    int x1, int y1, int x2, int y2,
		    int color,
		    int line_width, int length, int space,
		    int origin_x, int origin_y)
{

  double dx, dy, l, d;
  double dx1, dy1;
  double xa, ya;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  /* PB : is the width relevant for a dot (circle) ? */
  f_print_set_line_width(fp, line_width);

#line 1073 "../noweb/o_line_basic.nw"
  dx = (double) (x2 - x1);
  dy = (double) (y2 - y1);
  l = sqrt((dx * dx) + (dy * dy));

  dx1 = (dx * space) / l;
  dy1 = (dy * space) / l;

  d = 0;
  xa = x1;
  ya = y1;
  while (d < l) {


#line 1101 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils\n", (int) xa, (int) ya);
    if (line_width <= 1) {
      fprintf(fp, "2 mils\n");
    } else {
      fprintf(fp, "%d mils\n", line_width / 2);
    }
    fprintf(fp, "0 360 arc\n");
    fprintf(fp, "fill\n");


#line 1086 "../noweb/o_line_basic.nw"
    d = d + space;
    xa = xa + dx1;
    ya = ya + dy1;
  }

  fprintf(fp, "grestore\n");

}

#line 1130 "../noweb/o_line_basic.nw"
void
o_line_print_dashed(TOPLEVEL * w_current, FILE * fp,
		    int x1, int y1, int x2, int y2,
		    int color,
		    int line_width, int length, int space,
		    int origin_x, int origin_y)
{
  double dx, dy, l, d;
  double dx1, dy1, dx2, dy2;
  double xa, ya, xb, yb;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, line_width);

#line 1156 "../noweb/o_line_basic.nw"
  dx = (double) (x2 - x1);
  dy = (double) (y2 - y1);
  l = sqrt((dx * dx) + (dy * dy));

  dx1 = (dx * length) / l;
  dy1 = (dy * length) / l;

  dx2 = (dx * space) / l;
  dy2 = (dy * space) / l;

  d = 0;
  xa = x1;
  ya = y1;
  while ((d + length + space) < l) {
    d = d + length;
    xb = xa + dx1;
    yb = ya + dy1;


#line 1205 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils moveto\n", (int) xa, (int) ya);
    fprintf(fp, "%d mils %d mils lineto\n", (int) xb, (int) yb);
    fprintf(fp, "stroke\n");

#line 1174 "../noweb/o_line_basic.nw"

    d = d + space;
    xa = xb + dx2;
    ya = yb + dy2;
  }

#line 1186 "../noweb/o_line_basic.nw"
  if ((d + length) < l) {
    d = d + length;
    xb = xa + dx1;
    yb = ya + dy1;
  } else {
    xb = x2;
    yb = y2;
  }


#line 1205 "../noweb/o_line_basic.nw"
  fprintf(fp, "newpath\n");
  fprintf(fp, "%d mils %d mils moveto\n", (int) xa, (int) ya);
  fprintf(fp, "%d mils %d mils lineto\n", (int) xb, (int) yb);
  fprintf(fp, "stroke\n");


#line 1197 "../noweb/o_line_basic.nw"
  fprintf(fp, "grestore\n");

}

#line 1227 "../noweb/o_line_basic.nw"
void
o_line_print_center(TOPLEVEL * w_current, FILE * fp,
		    int x1, int y1, int x2, int y2,
		    int color,
		    int line_width, int length, int space,
		    int origin_x, int origin_y)
{
  double dx, dy, l, d;
  double dx1, dy1, dx2, dy2;
  double xa, ya, xb, yb;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, line_width);

#line 1253 "../noweb/o_line_basic.nw"
  dx = (double) (x2 - x1);
  dy = (double) (y2 - y1);
  l = sqrt((dx * dx) + (dy * dy));

  dx1 = (dx * length) / l;
  dy1 = (dy * length) / l;

  dx2 = (dx * space) / l;
  dy2 = (dy * space) / l;

  d = 0;
  xa = x1;
  ya = y1;
  while ((d + length + 2 * space) < l) {
    d = d + length;
    xb = xa + dx1;
    yb = ya + dy1;


#line 1328 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils moveto\n", (int) xa, (int) ya);
    fprintf(fp, "%d mils %d mils lineto\n", (int) xb, (int) yb);
    fprintf(fp, "stroke\n");


#line 1272 "../noweb/o_line_basic.nw"
    d = d + space;
    xa = xb + dx2;
    ya = yb + dy2;


#line 1339 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils\n", (int) xa, (int) ya);
    if (line_width <= 1) {
      fprintf(fp, "2 mils\n");
    } else {
      fprintf(fp, "%d mils\n", line_width / 2);
    }
    fprintf(fp, "0 360 arc\n");
    fprintf(fp, "fill\n");

#line 1277 "../noweb/o_line_basic.nw"

    d = d + space;
    xa = xa + dx2;
    ya = ya + dy2;
  }

#line 1295 "../noweb/o_line_basic.nw"
  if ((d + length + space) < l) {
    d = d + length;
    xb = xa + dx1;
    yb = ya + dy1;


#line 1328 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils moveto\n", (int) xa, (int) ya);
    fprintf(fp, "%d mils %d mils lineto\n", (int) xb, (int) yb);
    fprintf(fp, "stroke\n");

#line 1301 "../noweb/o_line_basic.nw"

    d = d + space;
    xa = xb + dx2;
    ya = yb + dy2;


#line 1339 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils\n", (int) xa, (int) ya);
    if (line_width <= 1) {
      fprintf(fp, "2 mils\n");
    } else {
      fprintf(fp, "%d mils\n", line_width / 2);
    }
    fprintf(fp, "0 360 arc\n");
    fprintf(fp, "fill\n");

#line 1307 "../noweb/o_line_basic.nw"

  } else {
    if (d + length < l) {
      xb = xa + dx1;
      yb = ya + dy1;
    } else {
      xb = x2;
      yb = y2;
    }


#line 1328 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils moveto\n", (int) xa, (int) ya);
    fprintf(fp, "%d mils %d mils lineto\n", (int) xb, (int) yb);
    fprintf(fp, "stroke\n");

#line 1318 "../noweb/o_line_basic.nw"

  }

  fprintf(fp, "grestore\n");
}

#line 1366 "../noweb/o_line_basic.nw"
void
o_line_print_phantom(TOPLEVEL * w_current, FILE * fp,
		     int x1, int y1, int x2, int y2,
		     int color,
		     int line_width, int length, int space,
		     int origin_x, int origin_y)
{
  double dx, dy, l, d;
  double dx1, dy1, dx2, dy2;
  double xa, ya, xb, yb;

  fprintf(fp, "gsave\n");
  if (w_current->print_color) {
    f_print_set_color(fp, color);
  }

  f_print_set_line_width(fp, line_width);

#line 1392 "../noweb/o_line_basic.nw"
  dx = (double) (x2 - x1);
  dy = (double) (y2 - y1);
  l = sqrt((dx * dx) + (dy * dy));

  dx1 = (dx * length) / l;
  dy1 = (dy * length) / l;

  dx2 = (dx * space) / l;
  dy2 = (dy * space) / l;

  d = 0;
  xa = x1;
  ya = y1;
  while ((d + length + 3 * space) < l) {
    d = d + length;
    xb = xa + dx1;
    yb = ya + dy1;


#line 1497 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils moveto\n", (int) xa, (int) ya);
    fprintf(fp, "%d mils %d mils lineto\n", (int) xb, (int) yb);
    fprintf(fp, "stroke\n");

#line 1410 "../noweb/o_line_basic.nw"

    d = d + space;
    xa = xb + dx2;
    ya = yb + dy2;


#line 1508 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils\n", (int) xa, (int) ya);
    if (line_width <= 1) {
      fprintf(fp, "2 mils\n");
    } else {
      fprintf(fp, "%d mils\n", line_width / 2);
    }
    fprintf(fp, "0 360 arc\n");
    fprintf(fp, "fill\n");


#line 1417 "../noweb/o_line_basic.nw"
    d = d + space;
    xa = xa + dx2;
    ya = ya + dy2;


#line 1508 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils\n", (int) xa, (int) ya);
    if (line_width <= 1) {
      fprintf(fp, "2 mils\n");
    } else {
      fprintf(fp, "%d mils\n", line_width / 2);
    }
    fprintf(fp, "0 360 arc\n");
    fprintf(fp, "fill\n");


#line 1423 "../noweb/o_line_basic.nw"
    d = d + space;
    xa = xa + dx2;
    ya = ya + dy2;
  }

#line 1442 "../noweb/o_line_basic.nw"
  if ((d + length + 2 * space) < l) {
    d = d + length;
    xb = xa + dx1;
    yb = ya + dy1;


#line 1497 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils moveto\n", (int) xa, (int) ya);
    fprintf(fp, "%d mils %d mils lineto\n", (int) xb, (int) yb);
    fprintf(fp, "stroke\n");

#line 1448 "../noweb/o_line_basic.nw"

    d = d + space;
    xa = xb + dx2;
    ya = yb + dy2;


#line 1508 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils\n", (int) xa, (int) ya);
    if (line_width <= 1) {
      fprintf(fp, "2 mils\n");
    } else {
      fprintf(fp, "%d mils\n", line_width / 2);
    }
    fprintf(fp, "0 360 arc\n");
    fprintf(fp, "fill\n");


#line 1455 "../noweb/o_line_basic.nw"
    d = d + space;
    xa = xb + dx2;
    ya = yb + dy2;


#line 1508 "../noweb/o_line_basic.nw"
    fprintf(fp, "newpath\n");
    fprintf(fp, "%d mils %d mils\n", (int) xa, (int) ya);
    if (line_width <= 1) {
      fprintf(fp, "2 mils\n");
    } else {
      fprintf(fp, "%d mils\n", line_width / 2);
    }
    fprintf(fp, "0 360 arc\n");
    fprintf(fp, "fill\n");


#line 1461 "../noweb/o_line_basic.nw"
  } else {
    if (d + length + space < l) {
      d = d + length;
      xb = xa + dx1;
      yb = ya + dy1;


#line 1497 "../noweb/o_line_basic.nw"
      fprintf(fp, "newpath\n");
      fprintf(fp, "%d mils %d mils moveto\n", (int) xa, (int) ya);
      fprintf(fp, "%d mils %d mils lineto\n", (int) xb, (int) yb);
      fprintf(fp, "stroke\n");


#line 1469 "../noweb/o_line_basic.nw"
      d = d + space;
      xa = xb + dx2;
      ya = yb + dy2;


#line 1508 "../noweb/o_line_basic.nw"
      fprintf(fp, "newpath\n");
      fprintf(fp, "%d mils %d mils\n", (int) xa, (int) ya);
      if (line_width <= 1) {
	fprintf(fp, "2 mils\n");
      } else {
	fprintf(fp, "%d mils\n", line_width / 2);
      }
      fprintf(fp, "0 360 arc\n");
      fprintf(fp, "fill\n");


#line 1475 "../noweb/o_line_basic.nw"
    } else {
      if (d + length < l) {
	xb = xa + dx1;
	yb = ya + dy1;
      } else {
	xb = x2;
	yb = y2;
      }


#line 1497 "../noweb/o_line_basic.nw"
      fprintf(fp, "newpath\n");
      fprintf(fp, "%d mils %d mils moveto\n", (int) xa, (int) ya);
      fprintf(fp, "%d mils %d mils lineto\n", (int) xb, (int) yb);
      fprintf(fp, "stroke\n");

#line 1485 "../noweb/o_line_basic.nw"

    }
  }


  fprintf(fp, "grestore\n");
}


#line 45 "../noweb/o_line_basic.nw"
#if 0				/* original way of printing line, no longer used */
#line 1528 "../noweb/o_line_basic.nw"
void
o_line_print_old(TOPLEVEL * w_current, FILE * fp, OBJECT * o_current,
		 int origin_x, int origin_y)
{
  if (o_current == NULL) {
    printf("got null in o_line_print\n");
    return;
  }

  if (w_current->print_color) {
    f_print_set_color(fp, o_current->color);
  }

  fprintf(fp, "newpath\n");

  fprintf(fp, "%d mils %d mils moveto\n",
	  o_current->line_points->x1 - origin_x,
	  o_current->line_points->y1 - origin_y);
  fprintf(fp, "%d mils %d mils lineto\n",
	  o_current->line_points->x2 - origin_x,
	  o_current->line_points->y2 - origin_y);
  fprintf(fp, "stroke\n");

}

#line 47 "../noweb/o_line_basic.nw"
#endif

#line 1563 "../noweb/o_line_basic.nw"
void
o_line_image_write(TOPLEVEL * w_current, OBJECT * o_current,
		   int origin_x, int origin_y, int color_mode)
{
  int color;

  if (o_current == NULL) {
    printf("got null in o_line_print\n");
    return;
  }

  if (color_mode == TRUE) {
    color = o_image_geda2gd_color(o_current->color);
  } else {
    color = image_black;
  }

  /* assumes screen coords are already calculated correctly */
#ifdef HAS_LIBGDGEDA

  gdImageSetThickness(current_im_ptr, SCREENabs(w_current,
						o_current->line_width));

  gdImageLine(current_im_ptr,
	      o_current->line->screen_x[0],
	      o_current->line->screen_y[0],
	      o_current->line->screen_x[1],
	      o_current->line->screen_y[1], color);
#endif
}


#line 1604 "../noweb/o_line_basic.nw"
void
o_line_scale_world(TOPLEVEL * w_current, int x_scale, int y_scale,
		   OBJECT * object)
{
  if (object == NULL)
    printf("lsw NO!\n");

  /* scale the line world coords */
  object->line->x[0] = object->line->x[0] * x_scale;
  object->line->y[0] = object->line->y[0] * y_scale;
  object->line->x[1] = object->line->x[1] * x_scale;
  object->line->y[1] = object->line->y[1] * y_scale;

  /* update screen coords */
  o_line_recalc(w_current, object);

}


#line 1631 "../noweb/o_line_basic.nw"
int
o_line_visible(TOPLEVEL * w_current, LINE * line,
	       int *x1, int *y1, int *x2, int *y2)
{
  int visible = 0;


  /* don't do clipping if this is false */
  if (!w_current->object_clipping) {
    return (TRUE);
  }

  *x1 = line->screen_x[0];
  *y1 = line->screen_y[0];
  *x2 = line->screen_x[1];
  *y2 = line->screen_y[1];

  visible = SCREENclip_change(w_current, x1, y1, x2, y2);

  return (visible);
}

#line 1663 "../noweb/o_line_basic.nw"
double o_line_length(OBJECT * object)
{
  double length;
  double dx, dy;

  if (!object->line) {
    return 0.0;
  }

  dx = object->line->x[0] - object->line->x[1];
  dy = object->line->y[0] - object->line->y[1];

  length = sqrt((dx * dx) + (dy * dy));

  return (length);
}
