/* a_basic.c */
void o_save_embedded(TOPLEVEL *w_current, OBJECT *object_list, FILE *fp);
void o_save_write_header(FILE *fp);
int o_save(TOPLEVEL *w_current, char *filename);
OBJECT *o_read(TOPLEVEL *w_current, OBJECT *object_list, char *filename);
void o_scale(TOPLEVEL *w_current, OBJECT *list, int x_scale, int y_scale);
/* f_basic.c */
int f_open(TOPLEVEL *w_current, char *filename);
void f_close(TOPLEVEL *w_current);
void f_save_close(TOPLEVEL *w_current, char *filename);
int f_save(TOPLEVEL *w_current, char *filename);
/* f_image.c */
void f_image_write_objects(TOPLEVEL *w_current, OBJECT *head, int start_x, int start_y, float scale, int color_mode);
void f_image_write(TOPLEVEL *w_current, char *filename, int width, int height, int color_mode);
void f_image_set_type(TOPLEVEL *w_current, int type);
/* f_print.c */
void f_print_set_line_width(FILE *fp, int width);
void f_print_set_color(FILE *fp, int color);
float f_print_header(TOPLEVEL *w_current, FILE *fp, int paper_size_x, int paper_size_y, int world_right, int world_bottom);
void f_print_footer(FILE *fp);
void f_print_objects(TOPLEVEL *w_current, FILE *fp, OBJECT *head, int start_x, int start_y, float scale);
int f_print(TOPLEVEL *w_current, char *filename);
void f_print_set_type(TOPLEVEL *w_current, int type);
/* g_basic.c */
int g_read_file(char *filename);
/* g_smob.c */
SCM g_make_attrib_smob(TOPLEVEL *curr_w, ATTRIB *curr_attr);
SCM g_get_attrib_name_value(SCM attrib_smob);
SCM g_set_attrib_value_internal(SCM attrib_smob, SCM scm_value, TOPLEVEL **world, OBJECT **o_attrib, char *new_string[]);
void g_init_attrib_smob(void);
/* libgeda.c */
void libgeda_init(void);
/* m_basic.c */
int mil_x(TOPLEVEL *w_current, int val);
int mil_y(TOPLEVEL *w_current, int val);
int pix_x(TOPLEVEL *w_current, int val);
int pix_y(TOPLEVEL *w_current, int val);
void WORLDtoSCREEN(TOPLEVEL *w_current, int x, int y, int *mil_x, int *mil_y);
void SCREENtoWORLD(TOPLEVEL *w_current, int mx, int my, int *x, int *y);
int snap_grid(TOPLEVEL *w_current, int input);
int SCREENabs(TOPLEVEL *w_current, int val);
int WORLDabs(TOPLEVEL *w_current, int val);
void set_window(TOPLEVEL *w_current, int xmin, int xmax, int ymin, int ymax);
int fix_x(TOPLEVEL *w_current, int in);
int fix_y(TOPLEVEL *w_current, int in);
int on_snap(int val);
int SCREENclip_change(TOPLEVEL *w_current, int *x1, int *y1, int *x2, int *y2);
int clip_nochange(TOPLEVEL *w_current, int x1, int y1, int x2, int y2);
int visible(TOPLEVEL *w_current, int wleft, int wtop, int wright, int wbottom);
void rotate_point(int x, int y, int angle, int *newx, int *newy);
void rotate_point_90(int x, int y, int angle, int *newx, int *newy);
void PAPERSIZEtoWORLD(int width, int height, int border, int *right, int *bottom);
double round_5_2_1(double unrounded);
/* o_arc_basic.c */
OBJECT *o_arc_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x, int y, int radius, int start_angle, int end_angle);
OBJECT *o_arc_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_arc_modify(TOPLEVEL *w_current, OBJECT *object, int x, int y, int whichone);
OBJECT *o_arc_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], unsigned int release_ver, unsigned int fileformat_ver);
char *o_arc_save(OBJECT *object);
void o_arc_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_arc_translate_world(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_arc_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_arc_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_arc_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_arc_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
void o_arc_recalc(TOPLEVEL *w_current, OBJECT *o_current);
void get_arc_bounds(TOPLEVEL *w_current, OBJECT *object, int *left, int *top, int *right, int *bottom);
void world_get_arc_bounds(TOPLEVEL *w_current, OBJECT *object, int *left, int *top, int *right, int *bottom);
void o_arc_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_arc_print_solid(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int angle1, int angle2, int color, int arc_width, int length, int space, int origin_x, int origin_y);
void o_arc_print_dotted(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int angle1, int angle2, int color, int arc_width, int length, int space, int origin_x, int origin_y);
void o_arc_print_dashed(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int angle1, int angle2, int color, int arc_width, int length, int space, int origin_x, int origin_y);
void o_arc_print_center(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int angle1, int angle2, int color, int arc_width, int length, int space, int origin_x, int origin_y);
void o_arc_print_phantom(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int angle1, int angle2, int color, int arc_width, int length, int space, int origin_x, int origin_y);
void o_arc_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
/* o_attrib.c */
void o_attrib_update_urefBM(TOPLEVEL *w_current, OBJECT *o_current);
ATTRIB *o_attrib_search(ATTRIB *list, OBJECT *item);
ATTRIB *o_attrib_return_tail(ATTRIB *head);
ATTRIB *add_attrib_head(OBJECT *parent);
ATTRIB *o_attrib_add(TOPLEVEL *w_current, ATTRIB *list_head, OBJECT *item);
void o_attrib_free(TOPLEVEL *w_current, ATTRIB *current);
void o_attrib_attach(TOPLEVEL *w_current, OBJECT *parent_list, OBJECT *text_object, OBJECT *object);
void o_attrib_detach_test(TOPLEVEL *w_current, OBJECT *list, OBJECT *items);
void o_attrib_edit(OBJECT *list, OBJECT *item);
void o_attrib_select_draw(ATTRIB *list);
void o_attrib_unselect_draw(ATTRIB *list);
void o_attrib_free_all(TOPLEVEL *w_current, ATTRIB *list);
void o_attrib_print(ATTRIB *attributes);
void o_attrib_print_reverse(ATTRIB *attributes);
ATTRIB *o_attrib_copy(ATTRIB *list);
void o_attrib_delete(ATTRIB *a_current);
void o_attrib_remove(ATTRIB *list, ATTRIB *remove);
void o_attrib_detach_all(TOPLEVEL *w_current, OBJECT *object_list, OBJECT *main_head);
OBJECT *o_read_attribs(TOPLEVEL *w_current, FILE *fp, OBJECT *object_to_get_attribs, unsigned int release_ver, unsigned int fileformat_ver);
void o_save_attribs(FILE *fp, ATTRIB *attribs);
int o_attrib_get_name_value(char *string, char **name, char **value);
void o_attrib_free_current(TOPLEVEL *w_current);
void o_attrib_set_show(TOPLEVEL *w_current, int flag);
void o_attrib_set_visible(TOPLEVEL *w_current, int flag);
void o_attrib_set_string(TOPLEVEL *w_current, char *string);
OBJECT *o_attrib_return_parent(ATTRIB *attribute);
ATTRIB *o_attrib_copy_all(TOPLEVEL *w_current, OBJECT *attached_to, ATTRIB *attributes);
void o_attrib_reattach(ATTRIB *attributes);
void o_attrib_set_color(TOPLEVEL *w_current, ATTRIB *attributes);
char *o_attrib_search_name(OBJECT *list, char *name, int counter);
OBJECT *o_attrib_search_string_list(OBJECT *list, char *string);
char *o_attrib_search_string_partial(OBJECT *object, char *search_for, int counter);
OBJECT *o_attrib_search_string_single(OBJECT *object, char *search_for);
OBJECT *o_attrib_search_attrib_value(ATTRIB *list, char *value, char *name, int counter);
char *o_attrib_search_attrib_name(ATTRIB *list, char *name, int counter);
char *o_attrib_search_toplevel(OBJECT *list, char *name, int counter);
char *o_attrib_search_special(OBJECT *o_current);
char *o_attrib_search_name_single(OBJECT *object, char *name, OBJECT **return_found);
char *o_attrib_search_name_single_count(OBJECT *object, char *name, int counter);
char *o_attrib_search_slot(OBJECT *object, OBJECT **return_found);
char *o_attrib_search_numslots(OBJECT *object, OBJECT **return_found);
char *o_attrib_search_default_slot(OBJECT *object);
OBJECT *o_attrib_search_pinseq(OBJECT *list, int pin_number);
char *o_attrib_search_slotdef(OBJECT *object, int slotnumber);
char *o_attrib_search_component(OBJECT *object, char *name);
void o_attrib_slot_update(TOPLEVEL *w_current, OBJECT *object);
void o_attrib_slot_copy(TOPLEVEL *w_current, OBJECT *original, OBJECT *target);
int o_attrib_count_toplevel(TOPLEVEL *w_current, char *name);
char *o_attrib_search_toplevel_all(PAGE *page_head, char *name);
OBJECT **o_attrib_return_attribs(OBJECT *object_list, OBJECT *sel_object);
void o_attrib_free_returned(OBJECT **found_objects);
/* o_basic.c */
int inside_region(int left, int top, int right, int bottom, int x, int y);
void o_redraw_single(TOPLEVEL *w_current, OBJECT *o_current);
void o_recalc(TOPLEVEL *w_current, OBJECT *object_list);
void o_set_line_options(TOPLEVEL *w_current, OBJECT *o_current, OBJECT_END end, OBJECT_TYPE type, int width, int length, int space);
void o_set_fill_options(TOPLEVEL *w_current, OBJECT *o_current, OBJECT_FILLING type, int width, int pitch1, int angle1, int pitch2, int angle2);
void o_object_recalc(TOPLEVEL *w_current, OBJECT *o_current);
/* o_box_basic.c */
OBJECT *o_box_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x1, int y1, int x2, int y2);
OBJECT *o_box_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_box_modify(TOPLEVEL *w_current, OBJECT *object, int x, int y, int whichone);
OBJECT *o_box_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], unsigned int release_ver, unsigned int fileformat_ver);
char *o_box_save(OBJECT *object);
void o_box_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_box_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
void o_box_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_box_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_box_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_box_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
void o_box_recalc(TOPLEVEL *w_current, OBJECT *o_current);
void get_box_bounds(TOPLEVEL *w_current, BOX *box, int *left, int *top, int *right, int *bottom);
void world_get_box_bounds(TOPLEVEL *w_current, BOX *box, int *left, int *top, int *right, int *bottom);
void o_box_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_box_print_solid(TOPLEVEL *w_current, FILE *fp, int x, int y, int width, int height, int color, int line_width, int length, int space, int origin_x, int origin_y);
void o_box_print_dotted(TOPLEVEL *w_current, FILE *fp, int x, int y, int width, int height, int color, int line_width, int length, int space, int origin_x, int origin_y);
void o_box_print_dashed(TOPLEVEL *w_current, FILE *fp, int x, int y, int width, int height, int color, int line_width, int length, int space, int origin_x, int origin_y);
void o_box_print_center(TOPLEVEL *w_current, FILE *fp, int x, int y, int width, int height, int color, int line_width, int length, int space, int origin_x, int origin_y);
void o_box_print_phantom(TOPLEVEL *w_current, FILE *fp, int x, int y, int width, int height, int color, int line_width, int length, int space, int origin_x, int origin_y);
void o_box_print_filled(TOPLEVEL *w_current, FILE *fp, int x, int y, int width, int height, int color, int fill_width, int angle1, int pitch1, int angle2, int pitch2, int origin_x, int origin_y);
void o_box_print_mesh(TOPLEVEL *w_current, FILE *fp, int x, int y, int width, int height, int color, int fill_width, int angle1, int pitch1, int angle2, int pitch2, int origin_x, int origin_y);
void o_box_print_hatch(TOPLEVEL *w_current, FILE *fp, int x, int y, int width, int height, int color, int fill_width, int angle1, int pitch1, int angle2, int pitch2, int origin_x, int origin_y);
void o_box_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
/* o_bus_basic.c */
void get_bus_bounds(TOPLEVEL *w_current, LINE *line, int *left, int *top, int *right, int *bottom);
void world_get_bus_bounds(TOPLEVEL *w_current, LINE *line, int *left, int *top, int *right, int *bottom);
OBJECT *o_bus_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x1, int y1, int x2, int y2, int bus_ripper_direction);
void o_bus_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_bus_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], unsigned int release_ver, unsigned int fileformat_ver);
char *o_bus_save(OBJECT *object);
void o_bus_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_bus_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_bus_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_bus_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_bus_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_bus_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_bus_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_bus_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_bus_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
int o_bus_orientation(OBJECT *object);
void o_bus_consolidate_lowlevel(OBJECT *object, OBJECT *del_object, int orient);
int o_bus_consolidate_segments(TOPLEVEL *w_current, OBJECT *object);
void o_bus_consolidate(TOPLEVEL *w_current);
void o_bus_modify(TOPLEVEL *w_current, OBJECT *object, int x, int y, int whichone);
/* o_circle_basic.c */
int dist(int x1, int y1, int x2, int y2);
OBJECT *o_circle_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x, int y, int radius);
OBJECT *o_circle_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_circle_modify(TOPLEVEL *w_current, OBJECT *object, int x, int y, int whichone);
OBJECT *o_circle_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], unsigned int release_ver, unsigned int fileformat_ver);
char *o_circle_save(OBJECT *object);
void o_circle_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_circle_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
void o_circle_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_circle_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_circle_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_circle_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
void o_circle_recalc(TOPLEVEL *w_current, OBJECT *o_current);
void get_circle_bounds(TOPLEVEL *w_current, CIRCLE *circle, int *left, int *top, int *right, int *bottom);
void world_get_circle_bounds(TOPLEVEL *w_current, CIRCLE *circle, int *left, int *top, int *right, int *bottom);
void o_circle_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_circle_print_solid(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int color, int circle_width, int length, int space, int origin_x, int origin_y);
void o_circle_print_dotted(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int color, int circle_width, int length, int space, int origin_x, int origin_y);
void o_circle_print_dashed(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int color, int circle_width, int length, int space, int origin_x, int origin_y);
void o_circle_print_center(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int color, int circle_width, int length, int space, int origin_x, int origin_y);
void o_circle_print_phantom(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int color, int circle_width, int length, int space, int origin_x, int origin_y);
void o_circle_print_filled(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int color, int fill_width, int angle1, int pitch1, int angle2, int pitch2, int origin_x, int origin_y);
void o_circle_print_mesh(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int color, int fill_width, int angle1, int pitch1, int angle2, int pitch2, int origin_x, int origin_y);
void o_circle_print_hatch(TOPLEVEL *w_current, FILE *fp, int x, int y, int radius, int color, int fill_width, int angle1, int pitch1, int angle2, int pitch2, int origin_x, int origin_y);
void o_circle_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
/* o_complex_basic.c */
void get_complex_bounds(TOPLEVEL *w_current, OBJECT *complex, int *left, int *top, int *right, int *bottom);
void get_complex_bounds_selection(TOPLEVEL *w_current, SELECTION *head, int *left, int *top, int *right, int *bottom);
void world_get_complex_bounds(TOPLEVEL *w_current, OBJECT *complex, int *left, int *top, int *right, int *bottom);
OBJECT *add_head(void);
int o_complex_is_eligible_attribute(OBJECT *object, int promote_invisible);
int o_complex_is_embedded(OBJECT *o_current);
OBJECT *o_complex_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x, int y, int angle, int mirror, char *clib, char *basename, int selectable, int attribute_promotion);
OBJECT *o_complex_add_embedded(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x, int y, int angle, char *clib, char *basename, int selectable);
void o_complex_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_complex_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], unsigned int release_ver, unsigned int fileformat_ver);
char *o_complex_save(OBJECT *object);
void o_complex_set_filename(TOPLEVEL *w_current, char *clib, char *basename);
void o_complex_free_filename(TOPLEVEL *w_current);
void o_complex_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_complex_world_translate(TOPLEVEL *w_current, int x1, int y1, OBJECT *prim_objs);
void o_complex_world_translate_toplevel(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_complex_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
OBJECT *o_complex_copy_embedded(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_complex_delete(TOPLEVEL *w_current, OBJECT *delete);
void o_complex_set_color(OBJECT *prim_objs, int color);
void o_complex_set_color_single(OBJECT *o_current, int color);
void o_complex_set_color_save(OBJECT *complex, int color);
void o_complex_unset_color(OBJECT *complex);
void o_complex_unset_color_single(OBJECT *o_current);
void o_complex_set_saved_color_only(OBJECT *complex, int color);
OBJECT *o_complex_return_nth_pin(OBJECT *o_list, int counter);
void o_complex_rotate_lowlevel(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, int angle_change, OBJECT *object);
void o_complex_mirror_lowlevel(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
OBJECT *o_complex_return_pin_object(OBJECT *object, char *pin);
/* o_image.c */
void o_image_init(void);
void o_image_create(int x, int y, int color_mode);
void o_image_close(void);
int o_image_write(char *filename);
int o_image_geda2gd_color(int color);
/* o_line_basic.c */
OBJECT *o_line_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x1, int y1, int x2, int y2);
OBJECT *o_line_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_line_modify(TOPLEVEL *w_current, OBJECT *object, int x, int y, int whichone);
OBJECT *o_line_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], unsigned int release_ver, unsigned int fileformat_ver);
char *o_line_save(OBJECT *object);
void o_line_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_line_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
void o_line_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_line_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_line_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_line_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
void o_line_recalc(TOPLEVEL *w_current, OBJECT *o_current);
void get_line_bounds(TOPLEVEL *w_current, LINE *line, int *left, int *top, int *right, int *bottom);
void world_get_line_bounds(TOPLEVEL *w_current, LINE *line, int *left, int *top, int *right, int *bottom);
void o_line_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_line_print_solid(TOPLEVEL *w_current, FILE *fp, int x1, int y1, int x2, int y2, int color, int line_width, int length, int space, int origin_x, int origin_y);
void o_line_print_dotted(TOPLEVEL *w_current, FILE *fp, int x1, int y1, int x2, int y2, int color, int line_width, int length, int space, int origin_x, int origin_y);
void o_line_print_dashed(TOPLEVEL *w_current, FILE *fp, int x1, int y1, int x2, int y2, int color, int line_width, int length, int space, int origin_x, int origin_y);
void o_line_print_center(TOPLEVEL *w_current, FILE *fp, int x1, int y1, int x2, int y2, int color, int line_width, int length, int space, int origin_x, int origin_y);
void o_line_print_phantom(TOPLEVEL *w_current, FILE *fp, int x1, int y1, int x2, int y2, int color, int line_width, int length, int space, int origin_x, int origin_y);
void o_line_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_line_scale_world(TOPLEVEL *w_current, int x_scale, int y_scale, OBJECT *object);
int o_line_visible(TOPLEVEL *w_current, LINE *line, int *x1, int *y1, int *x2, int *y2);
double o_line_length(OBJECT *object);
/* o_list.c */
OBJECT *o_list_copy_to(TOPLEVEL *w_current, OBJECT *list_head, OBJECT *selected, int flag, OBJECT **return_end);
OBJECT *o_list_copy_all(TOPLEVEL *w_current, OBJECT *src_list_head, OBJECT *dest_list_head, int flag);
OBJECT *o_list_copy_all_selection2(TOPLEVEL *w_current, SELECTION *src_list_head, OBJECT *dest_list_head, int flag);
OBJECT *o_list_search(OBJECT *list, OBJECT *current);
void o_list_delete(TOPLEVEL *w_current, OBJECT *list, OBJECT *delete);
void o_list_delete_rest(TOPLEVEL *w_current, OBJECT *list);
/* o_net_basic.c */
void get_net_bounds(TOPLEVEL *w_current, LINE *line, int *left, int *top, int *right, int *bottom);
void world_get_net_bounds(TOPLEVEL *w_current, LINE *line, int *left, int *top, int *right, int *bottom);
OBJECT *o_net_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x1, int y1, int x2, int y2);
void o_net_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_net_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], unsigned int release_ver, unsigned int fileformat_ver);
char *o_net_save(OBJECT *object);
void o_net_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_net_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_net_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_net_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_net_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_net_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_net_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_net_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_net_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
int o_net_orientation(OBJECT *object);
void o_net_consolidate_lowlevel(OBJECT *object, OBJECT *del_object, int orient);
int o_net_consolidate_nomidpoint(OBJECT *object, int x, int y);
int o_net_consolidate_segments(TOPLEVEL *w_current, OBJECT *object);
void o_net_consolidate(TOPLEVEL *w_current);
void o_net_modify(TOPLEVEL *w_current, OBJECT *object, int x, int y, int whichone);
/* o_pin_basic.c */
void get_pin_bounds(TOPLEVEL *w_current, LINE *line, int *left, int *top, int *right, int *bottom);
void world_get_pin_bounds(TOPLEVEL *w_current, LINE *line, int *left, int *top, int *right, int *bottom);
OBJECT *o_pin_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x1, int y1, int x2, int y2, int pin_type, int whichend);
void o_pin_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_pin_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], unsigned int release_ver, unsigned int fileformat_ver);
char *o_pin_save(OBJECT *object);
void o_pin_translate(TOPLEVEL *w_current, int dx, int dy, OBJECT *object);
void o_pin_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *object);
OBJECT *o_pin_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_pin_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_pin_image_write(TOPLEVEL *w_current, OBJECT *o_current, int origin_x, int origin_y, int color_mode);
void o_pin_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, OBJECT *object);
void o_pin_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_pin_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
void o_pin_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
void o_pin_modify(TOPLEVEL *w_current, OBJECT *object, int x, int y, int whichone);
void o_pin_update_whichend(TOPLEVEL *w_current, OBJECT *object_list, int num_pins);
/* o_selection.c */
SELECTION *o_selection_return_tail(SELECTION *head);
SELECTION *o_selection_return_head(SELECTION *tail);
SELECTION *o_selection_new_head(void);
void o_selection_destroy_head(SELECTION *s_head);
SELECTION *o_selection_add(SELECTION *head, OBJECT *o_selected);
void o_selection_remove(SELECTION *head, OBJECT *o_selected);
void o_selection_remove_most(TOPLEVEL *w_current, SELECTION *head);
void o_selection_print_all(SELECTION *head);
void o_selection_destroy_all(SELECTION *head);
void o_selection_select(OBJECT *object, int color);
void o_selection_unselect(OBJECT *object);
OBJECT *o_selection_return_first_object(SELECTION *head);
OBJECT *o_selection_return_nth_object(SELECTION *head, int count);
int o_selection_return_num(SELECTION *head);
/* o_text_basic.c */
void get_text_bounds(TOPLEVEL *w_current, OBJECT *o_current, int *left, int *top, int *right, int *bottom);
void world_get_text_bounds(TOPLEVEL *w_current, OBJECT *o_current, int *left, int *top, int *right, int *bottom);
OBJECT *o_text_add_head(void);
void o_text_init(void);
void o_text_print_set(void);
OBJECT *o_text_load_font(TOPLEVEL *w_current, unsigned char needed_char);
int o_text_num_lines(char *string);
int o_text_height(char *string, int size);
int o_text_width(TOPLEVEL *w_current, char *string, int size);
OBJECT *o_text_create_string(TOPLEVEL *w_current, OBJECT *object_list, char *string, int size, int color, int x, int y, int alignment, int angle);
OBJECT *o_text_add(TOPLEVEL *w_current, OBJECT *object_list, char type, int color, int x, int y, int alignment, int angle, char *string, int size, int visibility, int show_name_value);
void o_text_recalc(TOPLEVEL *w_current, OBJECT *o_current);
OBJECT *o_text_read(TOPLEVEL *w_current, OBJECT *object_list, char buf[], FILE *fp, unsigned int release_ver, unsigned int fileformat_ver);
void o_text_set_info_font(char buf[]);
char *o_text_save(OBJECT *object);
void o_text_recreate(TOPLEVEL *w_current, OBJECT *o_current);
void o_text_translate_world(TOPLEVEL *w_current, int x1, int y1, OBJECT *o_current);
OBJECT *o_text_copy(TOPLEVEL *w_current, OBJECT *list_tail, OBJECT *o_current);
void o_text_freeallfonts(TOPLEVEL *w_current);
void o_text_print_text_width(FILE *fp, char *output_string);
void o_text_print_text_height(FILE *fp, int size);
void o_text_print_text_height_full(FILE *fp, char *string, int size);
void o_text_print_text_string(FILE *fp, char *string);
void o_text_print(TOPLEVEL *w_current, FILE *fp, OBJECT *o_current, int origin_x, int origin_y);
void o_text_rotate_lowlevel(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, OBJECT *object);
void o_text_rotate_world(TOPLEVEL *w_current, int world_centerx, int world_centery, int angle, int angle_change, OBJECT *object);
void o_text_rotate(TOPLEVEL *w_current, int centerx, int centery, int angle, int angle_change, OBJECT *object);
void o_text_mirror_world(TOPLEVEL *w_current, int world_centerx, int world_centery, OBJECT *object);
void o_text_mirror(TOPLEVEL *w_current, int centerx, int centery, OBJECT *object);
/* s_attrib.c */
int s_attrib_add_entry(char *new_attrib);
void s_attrib_print(void);
int s_attrib_uniq(char *name);
void s_attrib_free(void);
void s_attrib_init(void);
char *s_attrib_get(int counter);
/* s_basic.c */
void error_if_called(void);
void exit_if_null(void *ptr);
OBJECT *return_tail(OBJECT *head);
OBJECT *return_head(OBJECT *tail);
OBJECT *s_basic_init_object(char *name);
OBJECT *s_basic_link_object(OBJECT *new_node, OBJECT *ptr);
void print_struct_forw(OBJECT *ptr);
void print_struct_back(OBJECT *ptr);
void print_struct(OBJECT *ptr);
void s_delete(TOPLEVEL *w_current, OBJECT *o_current);
void s_delete_list_fromstart(TOPLEVEL *w_current, OBJECT *start);
OBJECT *s_remove(TOPLEVEL *w_current, OBJECT *object);
void string_toupper(char *in, char *out);
void string_tolower(char *in, char *out);
int colornametovalue(char *string);
char *remove_nl(char *string);
char *remove_last_nl(char *string);
char *remove_string(char *string, int start, int end);
char *insert_string(char *string, int start, char *insert_string);
char *expand_env_variables(char *string);
/* s_clib.c */
int s_clib_return_num(void);
int s_clib_add_entry(char *new_path);
int s_clib_search_for_dirname(char *dir_name);
char *s_clib_cache_search(char *basename);
int s_clib_cache_add(char *clib_path, char *basename);
char *s_clib_search_dirs(char *basename);
char *s_clib_search(char *basename);
void s_clib_print(void);
void s_clib_cache_free(void);
void s_clib_free(void);
void s_clib_init(void);
char *s_clib_getdir(int index);
char *s_clib_getfiles(char *directory, int flag, char *filter, int new_current);
int s_clib_uniq(char *path);
/* s_color.c */
void s_color_init(void);
int s_color_request(int color_index, char *color_name, char *outline_color_name, char *ps_color_string, int image_red, int image_green, int image_blue);
void s_color_destroy_all(void);
char *s_color_ps_string(int color);
int s_color_image_int(int color);
void s_color_gdcolor_init(void);
int s_color_get_name(int index, char *string);
/* s_conn.c */
CONN *s_conn_return_new(OBJECT *other_object, int type, int x, int y, int whichone, int other_whichone);
int s_conn_uniq(GList *conn_list, CONN *input_conn);
int s_conn_remove_other(TOPLEVEL *w_current, OBJECT *other_object, OBJECT *to_remove);
void s_conn_remove(TOPLEVEL *w_current, OBJECT *to_remove);
void s_conn_remove_complex(TOPLEVEL *w_current, OBJECT *to_remove);
OBJECT *s_conn_check_midpoint(OBJECT *o_current, int x, int y);
void s_conn_update_object(TOPLEVEL *w_current, OBJECT *object);
void s_conn_update_complex(TOPLEVEL *w_current, OBJECT *complex);
void s_conn_print(GList *conn_list);
GList *s_conn_return_others(GList *input_list, OBJECT *object);
GList *s_conn_return_complex_others(GList *input_list, OBJECT *object);
/* s_cue.c */
void s_cue_postscript_fillbox(TOPLEVEL *w_current, FILE *fp, int x, int y);
void s_cue_postscript_fillcircle(TOPLEVEL *w_current, FILE *fp, int x, int y, int size_flag);
void s_cue_image_fillbox(TOPLEVEL *w_current, OBJECT *object, int world_x, int world_y);
void s_cue_image_fillcircle(TOPLEVEL *w_current, int world_x, int world_y, int size_flag);
void s_cue_output_all(TOPLEVEL *w_current, OBJECT *head, FILE *fp, int type);
void s_cue_output_lowlevel(TOPLEVEL *w_current, OBJECT *object, int whichone, FILE *fp, int output_type);
void s_cue_output_lowlevel_midpoints(TOPLEVEL *w_current, OBJECT *object, FILE *fp, int output_type);
void s_cue_output_single(TOPLEVEL *w_current, OBJECT *object, FILE *fp, int type);
/* s_hierarchy.c */
int s_hierarchy_down_schematic_single(TOPLEVEL *w_current, char *filename, PAGE *parent, int page_control, int flag);
void s_hierarchy_down_schematic_multiple(TOPLEVEL *w_current, char *filename, PAGE *parent);
void s_hierarchy_down_symbol(TOPLEVEL *w_current, char *filename, PAGE *parent);
void s_hierarchy_up(TOPLEVEL *w_current, int pid);
void s_hierarch_traverse(void);
PAGE *s_hierarchy_find_prev_page(PAGE *p_start, int page_control);
PAGE *s_hierarchy_find_next_page(PAGE *p_start, int page_control);
PAGE *s_hierarchy_find_page(PAGE *p_start, int pid);
/* s_log.c */
void s_log_init(char *cwd, char *filename);
void s_log_message(const gchar *format, ...);
void s_log_close(void);
/* s_menu.c */
int s_menu_return_num(void);
SCM s_menu_return_entry(int index, char **menu_name);
int s_menu_add_entry(char *new_menu, SCM menu_items);
void s_menu_print(void);
void s_menu_free(void);
void s_menu_init(void);
/* s_page.c */
PAGE *s_page_return_tail(PAGE *head);
void s_page_free(TOPLEVEL *w_current, PAGE *p_current);
void s_page_free_all(TOPLEVEL *w_current, PAGE *p_tail);
PAGE *s_page_add(TOPLEVEL *w_current, PAGE *p_tail, char *page_filename);
void s_page_print(PAGE *p_list);
void s_page_add_head(TOPLEVEL *w_current);
void s_page_free_head(TOPLEVEL *w_current, PAGE *p_head);
void s_page_delete(void);
PAGE *s_page_new_lowlevel(TOPLEVEL *w_current, char *page_filename);
PAGE *s_page_new(TOPLEVEL *w_current, char *page_filename);
void s_page_setup(PAGE *p_current);
int s_page_check_changed(PAGE *p_head);
void s_page_clear_changed(PAGE *p_head);
void s_page_goto(TOPLEVEL *w_current, PAGE *p_new);
PAGE *s_page_search(TOPLEVEL *w_current, char *filename);
int s_page_search_row(TOPLEVEL *w_current, PAGE *p_findme);
void s_page_print_all(TOPLEVEL *w_current);
int s_page_save_all(TOPLEVEL *w_current);
/* s_papersizes.c */
int s_papersizes_add_entry(char *new_papersize, int width, int height);
void s_papersizes_print(void);
int s_papersizes_uniq(char *name);
void s_papersizes_free(void);
void s_papersizes_init(void);
char *s_papersizes_get(int counter);
void s_papersizes_get_size(char *string, int *width, int *height);
/* s_project.c */
TOPLEVEL *s_project_add(TOPLEVEL *w_head, TOPLEVEL *pr_current);
void s_project_add_head(void);
void s_project_free_head(void);
void s_project_delete(TOPLEVEL *w_head, TOPLEVEL *pr_current);
void s_project_setup_world(TOPLEVEL *pr_current);
void s_project_setup_rest(TOPLEVEL *pr_current);
TOPLEVEL *s_project_create_new(void);
void s_project_close(TOPLEVEL *pr_current);
void s_project_close_all(void);
TOPLEVEL *s_project_get_ptr(int wid);
/* s_scratch.c */
void s_scratch_string_init(void);
void s_scratch_string_free(void);
int s_scratch_string_fill(char *string);
/* s_slib.c */
int s_slib_add_entry(char *new_path);
int s_slib_search_for_dirname(char *dir_name);
char *s_slib_search_dirs(char *basename);
char *s_slib_search_lowlevel(char *basename);
char *s_slib_getbasename(char *rawname);
char *s_slib_search(char *filename, int flag);
char *s_slib_search_single(char *filename);
void s_slib_free(void);
void s_slib_init(void);
char *s_slib_getdir(int index);
char *s_slib_getfiles(char *directory, int flag);
void s_slib_print(void);
int s_slib_uniq(char *path);
void s_slib_print_dirs(void);
/* s_stretch.c */
STRETCH *s_stretch_return_tail(STRETCH *head);
STRETCH *s_stretch_return_head(STRETCH *tail);
STRETCH *s_stretch_new_head(void);
void s_stretch_destroy_head(STRETCH *s_head);
STRETCH *s_stretch_add(STRETCH *head, OBJECT *object, CONN *connection, int whichone);
void s_stretch_remove(STRETCH *head, OBJECT *object);
void s_stretch_remove_most(TOPLEVEL *w_current, STRETCH *head);
void s_stretch_print_all(STRETCH *head);
void s_stretch_destroy_all(STRETCH *head);
/* s_tile.c */
void s_tile_init(TOPLEVEL *w_current, PAGE *p_current);
TILE_LOC *s_tile_new_loc(int i, int j);
void s_tile_add_object(TOPLEVEL *w_current, OBJECT *object, int world_x1, int world_y1, int world_x2, int world_y2);
void s_tile_remove_object_all_crude(TOPLEVEL *w_current, OBJECT *object);
void s_tile_remove_object_all(TOPLEVEL *w_current, PAGE *p_current, OBJECT *object);
void s_tile_update_object(TOPLEVEL *w_current, OBJECT *object);
void s_tile_print(TOPLEVEL *w_current);
void s_tile_free_all(PAGE *p_current);
/* s_undo.c */
UNDO *s_undo_return_tail(UNDO *head);
UNDO *s_undo_return_head(UNDO *tail);
UNDO *s_undo_new_head(void);
void s_undo_destroy_head(UNDO *u_head);
UNDO *s_undo_add(UNDO *head, int type, char *filename, OBJECT *object_head, int left, int top, int right, int bottom, int page_control, int up);
void s_undo_print_all(UNDO *head);
void s_undo_destroy_all(TOPLEVEL *w_current, UNDO *head);
void s_undo_remove(TOPLEVEL *w_current, UNDO *head, UNDO *u_tos);
void s_undo_remove_rest(TOPLEVEL *w_current, UNDO *head);
int s_undo_levels(UNDO *head);
void s_undo_init(PAGE *p_current);
void s_undo_free_all(TOPLEVEL *w_current, PAGE *p_current);
/* u_basic.c */
char *u_basic_strdup(const char *p);
char *u_basic_strdup_multiple(const char *str, ...);
char *u_basic_breakup_string(char *string, char delimiter, int count);
void u_basic_strip_trailing(char *string, char c);
int u_basic_has_trailing(char *string, char c);
