/**
 * @file libgalago/galago-object-utils.h Galago Object Utility API
 *
 * @Copyright (C) 2005 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_OBJECT_UTILS_H_
#define _GALAGO_OBJECT_UTILS_H_

#include <libgalago/galago-object.h>

#define GALAGO_REGISTER_CLASS(name, type, parent_type, dbus_iface) \
static void name##_class_init(GalagoObjectClass *klass); \
static void name##_object_init(type *obj); \
static void *name##_parent_class = NULL; \
static void name##_class_init_internal(GalagoObjectClass *klass) \
{ \
	name##_parent_class = galago_class_get_parent(klass); \
	name##_class_init(klass); \
} \
GalagoObjectClass *\
name##_get_class(void) \
{ \
	static GalagoObjectClass *klass = NULL; \
 \
	if (klass == NULL) \
	{ \
		static const GalagoObjectClassInfo info = \
		{ \
			0, \
			sizeof(type##Class), \
			name##_class_init_internal, \
			NULL, \
			sizeof(type), \
			(GalagoObjectInitFunc)name##_object_init, \
		}; \
 \
		klass = galago_class_register(parent_type, #type, dbus_iface, &info); \
	} \
 \
	return klass; \
}

#endif /* _GALAGO_OBJECT_UTILS_H_ */
