/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#ifndef RXPUTIL_H
#define RXPUTIL_H

#define Vector(type, name) \
    int name##_count, name##_alloc; \
    type *name

#define VectorInit(v) \
    (v##_count = v##_alloc = 0, v = 0)

#define VectorPush(v, value) \
    ((v##_count < v##_alloc || \
      (v = VectorExtend(v))) ? \
     (v[v##_count++] = (value), 1) : \
     0)

#define VectorExtend(v) \
    (v##_alloc = (v##_alloc == 0 ? 8 : v##_alloc * 2), \
     Realloc(v, v##_alloc * sizeof(v)))

#define VectorCount(v) v##_count

#endif /* RXPUTIL_H */
