/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


/* FUNCTION: strtrim
 *
 * PARAMETERS: str
 * 
 * DESCRIPTION: Removes leading and trailing whitespace (spaces, tabs,
 * newlines, etc.) from passed string.
 * 
 * RETURNS: Nothing. Always successful, and the provided string is altered 
 * in-place. */

void strtrim(char *str)
{
  char *temp_ptr, *temp2_ptr;

  /* --- Squash leading spaces --- */

  temp_ptr = str;
  while (isspace((char) *((char *)temp_ptr) && (char) *((char *)temp_ptr)))
    temp_ptr++;  /* Find real start */

  if (*temp_ptr && (str != temp_ptr))
  {
    temp2_ptr = str;
    while (*temp_ptr) *temp2_ptr++ = *temp_ptr++;
    *temp2_ptr = 0;
  }

  /* --- Chop trailing spaces --- */

  temp_ptr = str + strlen(str) - 1;
  while (temp_ptr >= str)
  {
    if (!(isspace((char) *((char *)temp_ptr)))) break;
    *temp_ptr = 0;
    temp_ptr--;
  }
}

