/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "flux.h"
#include <stdlib.h>
#include <string.h>


/* --------------------------------------------------------
   Count number of strings in a null-terminated string list
   -------------------------------------------------------- */

int strarr_num(char **str_list)
{
  int n = 0;
  
  while (*str_list++) n++;

  return(n);
}


/* -----------------------------------------------------
   Return string's placement in list, or -1 if not found
   ----------------------------------------------------- */

int strarr_find(char *find_str, char **strlist, int num_strs)
{
  int i;


  if (!find_str || !strlist) return(-1);

  if (num_strs)
  {
    for (i = 0; i < num_strs; i++)
      if (!strcmp(find_str, strlist[i])) return(i);
  }
  else
  {
    for (i = 0; strlist[i][0]; i++)
      if (!strcmp(find_str, strlist[i])) return(i);
  }

  return(-1);
}

/* --- Separate string into individual elements, placed in array --- */

char **strarr_make_split(const char *path, const char delim)
{
  char **elm;
  char *next, *path_dup, delim_str[2];
  int i, j;

  delim_str[0] = delim;
  delim_str[1] = 0;

  i = strchrnum(path, delim) + 1;  /* Number of elements */
  elm = calloc(i + 1, sizeof(char *));

  for (j = 0, next = path_dup = strdup(path); j < i; j++)
    elm[j] = strdup(strsep(&next, delim_str));

  elm[j] = 0;
  free(path_dup);
  return(elm);
}

void strarr_free(char **strarr)
{
  int i;
  
  for (i = 0; strarr[i]; i++) free(strarr[i]);
  free(strarr);
  return;
}
