/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "flux.h"
#include <string.h>


void comm_flush(COMM *c)
{
  while (comm_queue_out_len(c))
  {
    comm_push(c);
    sock_flush(comm_get_sock(c));
  }
  
  sock_flush(comm_get_sock(c));
}


void comm_grab(COMM *c)
{
  fd_set fd_read, fd_write;

  while (!comm_queue_in_len(c))
  {
    comm_pull_many(c);
    FD_ZERO(&fd_read);
    FD_ZERO(&fd_write);
    FD_SET(comm_get_fd_read(c), &fd_read);
    FD_SET(comm_get_fd_write(c), &fd_write);

    while (!select(comm_get_fd_read(c) > comm_get_fd_write(c) ?
                   comm_get_fd_read(c) + 1 : comm_get_fd_write(c) + 1,
                   &fd_read, &fd_write, 0, 0)) ;
  }
}


/* --- */


void comm_send_with_trans_and_flags(COMM *c, TT *tt, u16 trans, u16 flags)
{
  comm_enqueue(c, tt, trans, flags);
  comm_flush(c);
}


void comm_send_with_trans(COMM *c, TT *tt, u16 trans)
{
  comm_enqueue(c, tt, trans, 0);
  comm_flush(c);
}


void comm_send_with_flags(COMM *c, TT *tt, u16 flags)
{
  comm_enqueue(c, tt, 0, flags);
  comm_flush(c);
}


void comm_send(COMM *c, TT *tt)
{
  comm_enqueue(c, tt, 0, 0);
  comm_flush(c);
}


/* --- */


TT *comm_recv_with_trans(COMM *c, u16 *trans)
{
  comm_grab(c);
  if (!comm_queue_in_len(c)) return(0);
  
  return(comm_dequeue(c, trans));
}


TT *comm_recv(COMM *c)
{
  comm_grab(c);
  if (!comm_queue_in_len(c)) return(0);
  
  return(comm_dequeue(c, 0));
}
