/*
   libffm	- Free, pretty fast replacement for some math (libm) routines 
			on Linux/AXP, optimized for the 21164

   Copyright (C) 1998  Joachim Wesner <joachim.wesner@frankfurt.netsurf.de>
                  and  Kazushige Goto <goto@statabo.rim.or.jp>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library (see file COPYING.LIB); if not, write 
   to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
   MA 02139, USA.
*/
/*
   Simple, fast atan2 helper function for the fast trig routines by
   Joachim Wesner <joachim.wesner@frankfurt.netsurf.de>, July 1998.

   This routine should be compatible to gcc/egcs -O3 "inline" coding, where 
   calls to atan(x) are (for some strange ?? reason) replaced by calls to 
   __atan2(x, 1.0). That special case is detected and our atan(x) is 
   directly jumped to, instead of "dividing" by one. Otherwise our general 
   atan2() routine is used.

   No special handling of illegal arguments or NANs, yet !!!
*/

	.set noat
	.set noreorder

#ifdef __ELF__
	.section .rodata
#else
	.rdata
#endif

	.align 5
$C37:
	.t_floating 1.0000000000000000e+00
	.align 3
$C38:
	.t_floating 3.1415926535897931e+00
	.align 3
$C39:
	.t_floating 1.5707963267948966e+00
	.align 3
$C40:
	.t_floating -1.5707963267948966e+00

.text
	.align	5
	.globl	__atan2
	.ent    __atan2
__atan2:
	ldgp	$29,0($27)
	lda	$1,  $C37
	ldt	$f10,0($1)
	cmpteq	$f10,$f17,$f1
	fbeq	$f1,$100
	jmp	$31,atan
	.end __atan2

	.align	5
	.globl 	atan2
	.ent 	atan2
atan2:
	ldgp 	$29,0($27)
$100:
	cmptlt 	$f31,$f17,$f1
	fbeq 	$f1,$50
	divt 	$f16,$f17,$f16
	jmp 	$31,atan
	.align 4
$50:
	lda 	$30,-16($30)

	.frame 	$30,16,$26,0
	stq 	$26,0($30)
	.mask 	0x4000000,-16
	.prologue 1

	cmptlt 	$f17,$f31,$f1
	fbeq 	$f1,$53
	cmptle 	$f31,$f16,$f1
	fbeq 	$f1,$54
	divt 	$f16,$f17,$f16
	jsr 	$26,atan
	lda 	$1,$C38
	ldt 	$f1,0($1)
	addt 	$f0,$f1,$f0
	br 	$31,$61

	.align 4
$54:
	divt 	$f16,$f17,$f16
	jsr 	$26,atan
	lda 	$1,$C38
	ldt 	$f1,0($1)
	subt 	$f0,$f1,$f0
	br 	$31,$61

	.align 4
$53:
	cmptle 	$f31,$f16,$f1
	lda 	$1,$C40
	fbeq 	$f1,$59
	lda 	$1,$C39
$59:
	ldt 	$f0,0($1)

$61:
	ldq 	$26,0($30)
	addq 	$30,16,$30
	ret 	$31,($26),1

	.end atan2
