'\" t
.\"
.\" libexplain - Explain errno values returned by libc functions
.\" Copyright (C) 2008, 2009 Peter Miller
.\" Written by Peter Miller <pmiller@opensource.org.au>
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program. If not, see <http://www.gnu.org/licenses/>.
.\"
.TH "Read Me" libexplain libexplain "Reference Manual"
.so etc/version.so
.hy 0
.ad l
.SH NAME
libexplain \- Explain errno values returned by libc functions
.XX "" "The README file"
.SH DESCRIPTION
The \fIlibexplain\fP package
provides a library which may be used to explain
Unix and Linux system call errors.
This will make your application's error messages much more
informative to your users.
.PP
The library is not quite a drop-in replacement for
\f[I]strerror\fP(3), but it
comes close.
Each system call has a dedicated libexplain function, for example
.RS
.ft CW
.nf
fd = open(path, flags, mode);
if (fd < 0)
{
    fprintf(stderr, "%s\en", explain_open(path, flags, mode));
    exit(EXIT_FAILURE);
}
.fi
.ft R
.RE
If, for example, you were to try to open
\f[CW]no-such-dir/some-file\fP, you would see a message like
.RS
\f[CW]open(pathname = "no-such-dir/some-file", flags = O_RDONLY)
failed, No such file or directory (2, ENOENT) because there is no
"no-such-dir" directory in the current directory\fP
.RE
.PP
The good new is that for each of these functions there is a wrapper
function, in this case \f[I]explain_open_or_die\fP(3), that includes
the above code fragment.  Adding good error reporting is as simple as
using a different, but similarly named, function.
The library also provides thread safe variants of each explanation function.
.PP
.so etc/coverage.so
.br
.ne 1i
.SH RATIONALE
Picture yourself as being the local \[lq]Unix guy\[rq], and all day
long a parade of people knock on your door, to have this or that error
message explained.  And these are usually smart people, but they don't
understand the subtle nuances of \f[CW]strerror\fP output.
.PP
\[lq]No such file or directory\[rq] is my all time favorite.  Users all
too often assume it is only talking about the final component of the
path being operated on.  When that isn't the problem, they are lost.
Libexplain actually locates the problematic component for the user, and
includes it in the error message.
.PP
\[lq]Permission denined\[rq] is another source of confusion.  Again,
users assume that it is only the final path component that has the
problem.  And if it isn't, they are lost again.  Libexplain actually
locates the problematic component for the user, and includes it in the
error message.
.PP
But there is a level beyond helping out the users, it also has to help
out those poor benighted souls who man telephone help desks.  They can't
see the screen, they can't just \[lq]hop on the system\[rq] and have
a quick poke around.  And, of course, the user says \[lq]it crashed
again\[rq].  Libexplain attampts to provide as much context as possible,
so that when the user reads back the text of the message over the phone,
there is more for the help desk staffer to work with.
.SS Too Technical
The error messages produced by libexplain can seem overly technical to
non-technical users, mostly as a result of accurately printing the
system call itself at the beginning of the error message.
.PP
The first consumers of the error messages are the developers themselves,
and way way way down the food^H^H^H^Hsupport chain are the tech support
programmers.  Both groups need bugs explained accurately, so they can
know which part of the system is broken.  And to accurately know what
is happening within the system.
.PP
So, an example of support problems:
The worst offenders are stupid programs that say
.RS
.nf
.fw CW
$ \f[B]stupid\fP
can't open file
$
.ft P
.fi
.RE
.PP
and of course you can't tell what this stupid program is trying to tell
you.  Is there a file called \[lq]file\[rq] that has a problem, or some
other file?  So the intrepid support person will break out their trusty
\f[I]strace\fP(1) or \f[I]truss\fP(1) command and look at what it happening.
But users can't do that.  And help desk staff usually can't, either.
And sometimes the system with the problem is half a world (and several
firewalls) away, making it impossible for anyone but the customer to go
hunting.
.PP
So you, as \f[I]n\f[P]th level support staff, take a clue stick to the
author of said stupid program, telling him to look up \f[I]perror\fP(3).
Lo and behold, the next problem report looks like this:
.RS
.nf
.fw CW
$ \f[B]stupid\fP
open: No such file or directory
$
.ft P
.fi
.RE
.PP
Slightly more informative, but you still need \f[I]strace\fP(1) to
figure it out, and you take yet another run with the clue stick,
this time standing over them until their code reads
.RS
.nf
.fw CW
FILE *fp = fopen(filename, "r");
if (!fp)
{
    fprintf(stderr, "open \e"%s\e": %s\en", filename, strerror(errno));
    exit(1);
}
.ft P
.fi
.RE
.PP
Of course, the developer's system is unable to reproduce the bug,
so the next bug registered by the user says
.RS
.nf
.fw CW
$ \f[B]stupid\fP
open /user/lib/stupid/datafile: No such file or directory
$
.ft P
.fi
.RE
.PP
And finally we discover the bug in the hard-coded path inside the stupid
program.  Of course, the help desk may \f[I]still\fP not be able to spot
the bug, but the next level of support should.
.PP
Wouldn't it be easier if all that had to be done for routine error
handling like this was to use some kind of \[lq]open-or-die\[rq] function
that only ever returned on success?
One that produced error messages that would be of imediate use to the
user, without calling tech support?
.PP
And thus libexplain was born.
Code like this
.RS
.nf
.fw CW
FILE *fp = explain_fopen_or_die(filename, "r");
.ft P
.fi
.RE
.PP
factors out all the error detecting and reporting.
.PP
In general, for any libc library function, section 2 or section 3,
there is an equivalent \f[CW]explain_*_or_die\fP function that calls the
libc function and, in the case of errors reports them and exits, and in the
case of success returns normally.
.PP
Now our example program would say
.RS
.fw CW
$ \f[B]stupid\fP
.br
fopen(path = "/user/lib/stupid/datafile", flags = "r") failed, No such
file or directory (ENOENT) because there is no "user" directory in the
"/" directory, but "usr" is similar\fP
.br
$
.ft P
.RE
.PP
Not so stupid any more.  If the user still can't work it out, tech
support will be able to.  Actually, of course, it's a bug, so grab your
clue stick and take another run at the developer.
(\[lq]Did it not occur to you that there was a tiny bit of a problem when
you made that symlink?\[rq]  rm.  Now the bug is reproducable.  Whack.)
.PP
And here is the \[lq]too technical\[rq] part:
That bit that says \f[I]fopen(path = "/user/lib/stupid/datafile", flags
= "r")\fP is alleged to be too scary for users to see.  Unfortunately
it is essential for the \f[I]n\fPth level support person, because
without it they can't know if it was an \[lq]open for reading\[rq] or an
\[lq]open for writing\[rq] operation that had a problem, because that
can be relevant (not to ENOENT, but, say EACCES) when performing psychic
silicon divination half a planet away.
.PP
If this information is not in the error message, it will never get into
the bug report.  It \f[I]can't\fP get into the bug report, no matter how
tech-savvy the customer is, no matter how brilliant the phone support
staff are.
In order for the tech support programmer to do his job, it needs to be there.
And give your users bit more credit, too.
.SS Too Verbose
The error messages produced by libexplain can seem overly verbose to
technical users, mostly as a result of using every-day language which is
often poorly adapted to explain technical issues.
.PP
The error messages relating to EACCES (Permission denied) are
particularly prone to being quite long, because the error message must
also explain how the Unix file permission modes work, in the process of
explaining exactly which directory or file's mode bits were offended.
It may come as a surprise to seasoned Linux hackers, but users
just don't \[lq]get\[rq] that permission stuff, even though it is
ridiculously easy and applied completely consistently.
.PP
And, of course, the above ENOENT example is anther case than can be
quite long.  The message actually locates and identifies the missing
directory entry, particularly as users are mostly just confused when any
but the last path component is the one that is not there.
And by suggesting similarly named alternatives that \f[I]are\fP there,
the library also deals with the commonest result of typing mistakes
in a helpful way.
.SS Internationalization
The library has globalization support (gettext) in place.
As yet there are no language translations.
.br
.ne 1i
.SH HOME PAGE
The latest version of
.I libexplain
is available on the Web from:
.TS
center,tab(;);
l l s
l l l.
URL:;http://libexplain.sourceforge.net/
File:;index.html;# the libexplain page
File:;libexplain.\*(v).README;# Description, from the tar file
File:;libexplain.\*(v).lsm;# Description, LSM format
File:;libexplain.\*(v).tar.gz;# the complete source
File:;libexplain.\*(v).pdf;# Reference Manual
.TE
.br
.ne 1i
.SH BUILDING LIBEXPLAIN
Full instructions for building
.I libexplain
may be found in the
.I BUILDING
file included in this distribution.
.br
.ne 1i
.SH COPYRIGHT
.I libexplain
version \*(v)
.br
Copyright
.if t \(co
.if n (C)
\*(Y) Peter Miller
.PP
This program is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 3 of the License, or (at
your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
General Public License for more details.
.PP
You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
.PP
It should be in the \f[I]LICENSE\fP file included with this distribution.
.br
.ne 1i
.SH AUTHOR
.TS
tab(;);
l r l.
Peter Miller;E-Mail:;pmiller@opensource.org.au
\f(CW/\e/\e*\fP;WWW:;http://www.canb.auug.org.au/~millerp/
.TE
.br
.bp
.SH RELEASE NOTES
.XX "" "Release Notes"
This section details the various features and bug fixes of the various
releases.  For excruciating and complete detail, and also credits for
those of you who have generously sent me suggestions and bug reports,
see the \fIetc/CHANGES.*\fP files.
.PP
.so etc/coverage.so
.so etc/new.so
