#!/usr/bin/perl -w

#
# $Id: stop_epsilon_nodes.pl,v 1.3 2007/07/20 12:29:47 simakov Exp $
#
# EPSILON - wavelet image compression library.
# Copyright (C) 2006-2007 Alexander Simakov, <xander@entropyware.info>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# http://epsilon-project.sourceforge.net
#

use strict;
use warnings;

sub stop_nodes {
    my ($epsilon_nodes) = @_;

    open F, $epsilon_nodes or die "$epsilon_nodes: $!";
    my @machines = ();

    while (my $line = <F>) {
        if ($line =~ /^(.*?\@.*?):/) {
            my $login = $1;
            push @machines, $login;
        }
    }

    if (@machines) {
        system('dsh', '-m', join(',', @machines), 'killall', 'epsilon');
    }

    close F;
}

sub Main {
    my $epsilon_nodes;

    if (@ARGV == 1) {
        $epsilon_nodes = $ARGV[0];
    } elsif (-e ".epsilon.nodes") {
        $epsilon_nodes = ".epsilon.nodes";
    } elsif (-e "$ENV{HOME}/.epsilon.nodes") {
        $epsilon_nodes = "$ENV{HOME}/.epsilon.nodes";
    } else {
        print <<EOF;
This is a script for stopping EPSILON nodes using DSH (Distributed SHell).
Host configuration is taken from so called `.epsilon.nodes' file.

By default, program checks `.epsilon.nodes' in the current directory.
If there is no such file, program tries `.epsilon.nodes' in user`s home
directory, i.e. \$HOME/.epsilon.nodes. You can also explicitly specify
file location as an argument to `stop_epsilon_nodes.pl' script.
EOF
        exit(1);
    }

    print "Using $epsilon_nodes\n";
    stop_nodes($epsilon_nodes);
}

Main();
