/*
 * Drizzle Client & Protocol Library
 *
 * Copyright (C) 2008 Eric Day (eday@oddments.org)
 * All rights reserved.
 *
 * Use and distribution licensed under the BSD license.  See
 * the COPYING file in this directory for full text.
 */

/**
 * @file
 * @brief drizzle_st tests
 */

#include "tests/common.h"

int main(void)
{
  drizzle_st *drizzle;
  drizzle_st drizzle_buffer;
  drizzle_st *clone;

  printf("# sizeof(drizzle_st) = %zu\n", sizeof(drizzle_st));

  if ((drizzle= drizzle_create(&drizzle_buffer)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_create");
  drizzle_free(drizzle);

  if ((drizzle= drizzle_create(NULL)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_create");

  if ((clone= drizzle_clone(NULL, drizzle)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_clone");
  drizzle_free(clone);

  if (drizzle_options(drizzle) != DRIZZLE_ALLOCATED)
    DRIZZLE_TEST_ERROR("drizzle_options");

  drizzle_add_options(drizzle, DRIZZLE_NON_BLOCKING);

  if (drizzle_options(drizzle) != (DRIZZLE_ALLOCATED | DRIZZLE_NON_BLOCKING))
    DRIZZLE_TEST_ERROR("drizzle_options");

  drizzle_remove_options(drizzle, DRIZZLE_NON_BLOCKING);

  if (drizzle_options(drizzle) != DRIZZLE_ALLOCATED)
    DRIZZLE_TEST_ERROR("drizzle_options");

  drizzle_free(drizzle);

  return 0;
}
