/*
 * Drizzle Client & Protocol Library
 *
 * Copyright (C) 2008 Eric Day (eday@oddments.org)
 * All rights reserved.
 *
 * Use and distribution licensed under the BSD license.  See
 * the COPYING file in this directory for full text.
 */

/**
 * @file
 * @brief Handshake declarations for servers
 */

#ifndef __DRIZZLE_HANDSHAKE_SERVER_H
#define __DRIZZLE_HANDSHAKE_SERVER_H

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @addtogroup drizzle_handshake_server Handshake Functions for Servers
 * @ingroup drizzle_server
 * These functions are used to send and receive handshake packets in a server.
 * @{
 */

/**
 * Write server handshake packet.
 */
DRIZZLE_API
drizzle_return_t drizzle_server_handshake_write(drizzle_con_st *con);

/**
 * Read client handshake packet.
 */
DRIZZLE_API
drizzle_return_t drizzle_client_handshake_read(drizzle_con_st *con);

/** @} */

#ifdef __cplusplus
}
#endif

#endif /* __DRIZZLE_HANDSHAKE_SERVER_H */
