/*
 * Drizzle Client & Protocol Library
 *
 * Copyright (C) 2008 Eric Day (eday@oddments.org)
 * All rights reserved.
 *
 * Use and distribution licensed under the BSD license.  See
 * the COPYING file in this directory for full text.
 */

#include <stdio.h>
#include <string.h>

#include <libdrizzle/drizzle_client.h>

int main(int argc, char *argv[])
{
  char *query= "SELECT table_schema,table_name FROM tables";
  drizzle_con_st con;
  drizzle_result_st result;
  drizzle_return_t ret;
  char **row;

  if (drizzle_con_create(NULL, &con) == NULL)
  {
    printf("drizzle_con_create:NULL\n");
    return 1;
  }

  if (argc == 2 && !strcmp(argv[1], "-m"))
    drizzle_con_add_options(&con, DRIZZLE_CON_MYSQL);
  else if (argc != 1)
  {
    printf("usage: %s [-m]\n", argv[0]);
    return 1;
  }

  drizzle_con_set_db(&con, "information_schema");

  (void)drizzle_query_str(&con, &result, query, &ret);
  if (ret != DRIZZLE_RETURN_OK)
  {
    printf("drizzle_query:%s\n", drizzle_con_error(&con));
    return 1;
  }

  ret= drizzle_result_buffer(&result);
  if (ret != DRIZZLE_RETURN_OK)
  {
    printf("drizzle_result_buffer:%s\n", drizzle_con_error(&con));
    return 1;
  }

  while ((row= (char **)drizzle_row_next(&result)) != NULL)
    printf("%s:%s\n", row[0], row[1]);

  drizzle_result_free(&result);
  drizzle_con_free(&con);

  return 0;
}
