package com.tildemh.debbug;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * Contains bug listings for a particular package, source package, pseudo
 * package, or maintainer.
 *
 * <p>Note: Listings are now supposed to be singly instantiable. Do not try to
 * create two similar listings. Instead, obtain listings using the BTS class. If
 * you don't, all sorts of problems might happen.
 * 
 * <p>Note: this class was formerly called Package, but renamed due to name
 * conflict. Many places will refer to it as Package.
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: Listing.java,v 1.32 2004/03/04 17:38:04 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class Listing extends ListingStub implements java.io.Serializable{

//	private String listing = "None";
	private static final boolean DEBUG = false;
	
	private Long lastSync = new Long(-1);	// Date when record last checked.

	// Array of bug numbers for this listing
	private Hashtable bugs;

	private volatile int countAll = 0;		private volatile int countUnreadAll = 0;	
	private volatile int countRC = 0;		private volatile int countUnreadRC = 0;
	private volatile int countIN = 0;		private volatile int countUnreadIN = 0;
	private volatile int countMW = 0;		private volatile int countUnreadMW = 0;
	private volatile int countFP = 0;		private volatile  int countUnreadFP = 0;

	private boolean complete = false;   // Whether the list is complete or not (false if sync not completed successfully)

	public void setComplete( boolean complete ){
		this.complete = complete;
	}
	public boolean getComplete(){
		return complete;
	}
	
	/**
	 * Constructs a new listing
	 * WARNING: Do not do this! it will mess things up. Use the BTS class to
	 * obtain listings.
	 */
	public static Listing makeListing( ListingStub stub ){
		return new Listing( stub.getType(), stub.getName() );
	}

	private  Listing(ListingType type, String name){
		super( type, name );
		Cache.getInstance().store(this);
	}
	
	/**
	 * TODO: unix time!
	 * Sets the last updated field to the present time
	 */
	public synchronized void setUpdated(){
		// TODO
	//	lastSync = new Date();
	}

	/**
	 * TODO: unix time!
	 * Sets the last updated field 
	 */
	public synchronized void setLastUpdated(Long lastUpdated){
		lastSync = lastUpdated;
	}

	/**
	 * Returns the date when the listing was last updated.
	 */
	public synchronized Long getLastUpdated(){
		return lastSync;
	}

	/**
	 */
	public synchronized Hashtable  getBugs(){
		return bugs;
	}


	public synchronized void setAllUnreadCount(int unreadCount){ this.countUnreadAll = unreadCount; }
	public synchronized int  getAllUnreadCount(){ return countUnreadAll; }

	public synchronized void setRCUnreadCount(int unreadCount){ this.countUnreadRC = unreadCount; }
	public synchronized int  getRCUnreadCount(){ return countUnreadRC; }

	public synchronized void setINUnreadCount(int unreadCount){ this.countUnreadIN = unreadCount; }
	public synchronized int  getINUnreadCount(){ return countUnreadIN; }

	public synchronized void setMWUnreadCount(int unreadCount){ this.countUnreadMW = unreadCount; }
	public synchronized int  getMWUnreadCount(){ return countUnreadMW; }

	public synchronized void setFPUnreadCount(int unreadCount){ this.countUnreadFP = unreadCount; }
	public synchronized int  getFPUnreadCount(){ return countUnreadFP; }


	public synchronized void setAllCount( int count ){ this.countAll = count; };
	public synchronized int  getAllCount(){ return countAll; }

	public synchronized void setRCCount( int count ){ this.countRC = count; };
	public synchronized int  getRCCount(){ return countRC; }

	public synchronized void setINCount( int count ){ this.countIN = count; };
	public synchronized int  getINCount(){ return countIN; }

	public synchronized void setMWCount( int count ){ this.countMW = count; };
	public synchronized int  getMWCount(){ return countMW; }

	public synchronized void setFPCount( int count ){ this.countFP = count; };
	public synchronized int  getFPCount(){ return countFP; }

	/** List of objects interested in events from this listing */
	private transient Vector listeners = new Vector();

	/**
	 * Give us a way to locate a specific listener in a Vector.
	* @param list The Vector of listeners to search.
	* @param listener The object that is to be located in the Vector.
	* @return Returns the index of the listener in the Vector, or -1 if
	*                 the listener is not contained in the Vector.
	 */
	protected static int findListener(Vector list, Object listener) {
		if (null == list || null == listener)
			return -1;
		return list.indexOf(listener);
	}
	/**
	 * Register an object to receive notification of events on this object
	 */
	public synchronized void addListener( ListingListener listener ){
		if (DEBUG) System.out.println("^^^Listing: Adding listener " + listing+ "  old count = "+((listeners==null)?"null":listeners.size()+""));
		// Don't add the listener a second time if it is in the Vector.
		int i = findListener(listeners, listener);
		if (listeners == null) 
			listeners = new Vector();
		if (i == -1) {
			listeners.addElement(listener);
		}
		if (DEBUG) System.out.println("^^^ListingListener added. New count: "+listeners.size());
	}
	
	/**
	 * Unregister an object that was receiving event notification.
	 * 
	 * @param listener The object that is to no longer receive
	 */
	public synchronized void removeListener( ListingListener listener) {
		if (DEBUG) System.out.println("^^^Listing: Removing listener " + listing);
		int i = findListener(listeners, listener);
		if (DEBUG) System.out.println("^^^Listing: Removing listener " +i);
		if (i > -1)
			listeners.remove(i);
	}

	private boolean interrupted(){
		if (!Thread.interrupted()) return false;
		for (int i = listeners.size(); i > 0; i--)
			((ListingListener) listeners.elementAt(i-1)).listingException( this, new InterruptedException() );		
		return true;
	}
	
	/**
	 * Downloads an updated version of the listing from the server and downloads
	 * any bug reports which are of a newer version on the server.
	 * <p>To obtain progress information about this update, attach a {@link
	 * ListingListener} to this object.
	 */
	public void update(){
		// TODO: Only allow one concurrent run of this!
		if (DEBUG) System.out.println( System.currentTimeMillis() + " downloading listing");

		if (interrupted()) return;
		for (int i = listeners.size(); i > 0; i--)
			((ListingListener) listeners.elementAt(i-1)).listingUpdateStart( this );
			
		if (interrupted()) return;
		if (DEBUG) System.out.println("type.makeURL "+listing);
		if (DEBUG) System.out.println(type.toString());
		String sourcePage = type.makeURL(listing);
		if (DEBUG) System.out.println("DEBUG: downloading listing: "+sourcePage);
		if (interrupted()) return;
		
		URL url = null;
		StringBuffer htmlPage = new StringBuffer();
		try{
			url = new URL( sourcePage );
		if (interrupted()) return;

		InputStream in = url.openStream();
		if (interrupted()) return;
		
		int ch =0;
		long count = 0;
		while ((ch = in.read()) != -1){
			count --;
			if (interrupted()) return;
			htmlPage.append((char)ch);
			if ( count <=0){
				count = 100;
				for (int i = listeners.size(); i > 0; i--)
					((ListingListener) listeners.elementAt(i-1)).downloadingListing( this );
			}
		}	
		if (DEBUG) System.out.println(System.currentTimeMillis() + "Listing downloaded"  );

		for (int i = listeners.size(); i > 0; i--)
			((ListingListener) listeners.elementAt(i-1)).interpretingListing( this );
		if (interrupted()) return;
		

		}catch( java.net.UnknownHostException e ){
			for (int i = listeners.size(); i > 0; i--)
				((ListingListener) listeners.elementAt(i-1)).listingException( this, e );
		}catch(Exception e){
			for (int i = listeners.size(); i > 0; i--)
				((ListingListener) listeners.elementAt(i-1)).listingException( this, e );
		}
		String source = htmlPage.toString();
		String pageHeader = "<NUMBER>, <LAST MODIFIED>, ";
		if (interrupted()) return;

		if (DEBUG) System.out.println( System.currentTimeMillis() + " make listing");
		if (source.indexOf("Error") >=0 ){
			for (int i = listeners.size(); i > 0; i--)
				((ListingListener) listeners.elementAt(i-1)).listingException( this, new ListingNotFound() );
		}
		if (interrupted()) return;
		
		Hashtable newBugList = new Hashtable();
	
		StringTokenizer st = new StringTokenizer(source, "\n");
		if (!st.hasMoreTokens()){
			(new Exception()).printStackTrace();
			for (int i = listeners.size(); i > 0; i--)
				((ListingListener) listeners.elementAt(i-1)).listingException( this, new ListingNotFound("Empty web page!") );
		}else{
			String next = st.nextToken();
			if (!next.equals( pageHeader )){
			(new Exception()).printStackTrace();
			for (int i = listeners.size(); i > 0; i--)
				((ListingListener) listeners.elementAt(i-1)).listingException( this, new ListingNotFound("Expected "+pageHeader+", found \""+next+"\".") );
			}
		}
		if (interrupted()) return;
		while (st.hasMoreTokens()){
		if (interrupted()) return;
			String s = st.nextToken();
			int firstComma =  s.indexOf( ", ") ;
			String bug = s.substring( 0 , firstComma );
			String lastMod = s.substring( firstComma +2, s.indexOf( ",", firstComma+2 ) );
			if (DEBUG) System.out.println("Adding bug ("+bug+","+lastMod + ")");
			try{
				if (interrupted()) return;
				newBugList.put( new Integer( bug ), new Long( lastMod ) );
			}catch( NumberFormatException e ){
				(new Exception()).printStackTrace();
				for (int i = listeners.size(); i > 0; i--)
					((ListingListener) listeners.elementAt(i-1)).listingException( this, new ListingNotFound("Error parsing listing - unable to parse bug ("+bug+","+lastMod + ")") );
			}
		}

		if (interrupted()) return;
		// note deletions, changes and additions
		LinkedList changedBugs = new LinkedList();
		LinkedList addedBugs = new LinkedList();
		Integer current;
		Object[] oldBugs = (bugs != null) ?  bugs.keySet().toArray() : new Object[0];
		for (int i = 0; i < oldBugs.length; i++){
			if (interrupted()) return;
			if (! newBugList.containsKey( oldBugs[i] ) ){
				for (int ij = listeners.size(); ij > 0; ij--)
					((ListingListener) listeners.elementAt(ij-1)).bugRemoved( this, (Integer) oldBugs[i] );
				Bug bug = BTS.getInstance().getBug( (Integer) oldBugs[i]);
				removeBug( bug );
				if (interrupted()) return;
			}else if ( ((Long) newBugList.get( oldBugs[i] )).compareTo( bugs.get( oldBugs[i] ) ) > 0 ){
				changedBugs.add( oldBugs[i] );
			}else{
				// bug has not changed - note that in the bug.
				Bug bug = BTS.getInstance().getBug( (Integer) oldBugs[i]);
				bug.setUpdated();
				Cache.getInstance().store(bug);
			}
		}
		Object[] newBugs = newBugList.keySet().toArray();
		for (int i = 0; i < newBugs.length; i++){
		if (interrupted()) return;
			if (bugs == null || !bugs.containsKey( newBugs[i] )){
				if (DEBUG) System.out.println("Adding added bug");
				addedBugs.add( newBugs[i] );
			}
		}

		// fetch modified and new reports.
		int total = changedBugs.size() + addedBugs.size();
		if (DEBUG) System.out.println("Total="+total);
		int done = 0;
		while( (changedBugs.size() > 0) || (addedBugs.size() > 0)){
		if (interrupted()) return;
			if (DEBUG) System.out.println("While loop");
			done++;
			Integer bugnumber;
			if (changedBugs.size() > 0){
				bugnumber =  (Integer) changedBugs.removeFirst();
				for (int i = listeners.size(); i > 0; i--)
					((ListingListener) listeners.elementAt(i-1)).downloadingListingBug( this, bugnumber, done, total );
				Bug bug = BTS.getInstance().getBug( bugnumber );
				bug.addListing( (ListingStub) this ); // should be there already. do this just in case
				try{
					if (DEBUG) System.out.println("Incomplete bug - downloading 1");
					if (interrupted()) return;
					bug.update();
				}catch(Exception e){
					// TODO
					e.printStackTrace();
					if (!listingException( e )){
						return;
						// todo
					}
				}
			}else{
				if (interrupted()) return;
				bugnumber =  (Integer) addedBugs.removeFirst();
				for (int i = listeners.size(); i > 0; i--)
					((ListingListener) listeners.elementAt(i-1)).downloadingListingBug( this, bugnumber, done, total );
				Bug bug = BTS.getInstance().getBug( bugnumber );
				bug.addListing( (ListingStub) this );
				if (bug.getComplete() == false)
				try{
				if (interrupted()) return;
					if (DEBUG) System.out.println("Incomplete bug - downloading 2");
					bug.update();
				}catch(Exception e){
					// TODO
					e.printStackTrace();
					newBugList.remove(bugnumber);
					if (DEBUG) System.err.println("ERROR updating bug #"+bugnumber);
					if (!listingException( e )){
						// TODO
						e.printStackTrace();
						return;
					}
				}
					
				Status status = bug.getStatus();
				Severity severity = bug.getSeverity();
				if (!status.equals(Status.READ)){
					countUnreadAll++;					
					if (severity.equals( Severity.CRITICAL ) || severity.equals( Severity.GRAVE ) || severity.equals( Severity.SERIOUS ))
						countUnreadRC++;
					if (severity.equals( Severity.IMPORTANT ) || severity.equals( Severity.NORMAL ) )
						countUnreadIN++;
					if (severity.equals( Severity.MINOR ) || severity.equals( Severity.WISHLIST ))
						countUnreadMW++;
					if (bug.getTagFixed() || bug.getTagPending())
						countUnreadFP++;
				}
				countAll++;
				if (severity.equals( Severity.CRITICAL ) || severity.equals( Severity.GRAVE ) || severity.equals( Severity.SERIOUS ))
					countRC++;
				if (severity.equals( Severity.IMPORTANT ) || severity.equals( Severity.NORMAL ) )
					countIN++;
				if (severity.equals( Severity.MINOR ) || severity.equals( Severity.WISHLIST ))
					countMW++;
				if (bug.getTagFixed() || bug.getTagPending())
					countFP++;
				for (int i = listeners.size(); i > 0; i--)
					((ListingListener) listeners.elementAt(i-1)).bugAdded(this, bug);
				for (int i = listeners.size(); i > 0; i--)
					((ListingListener) listeners.elementAt(i-1)).bugCountsChanged( this );
			}
		}
		
		bugs = newBugList;

		setComplete(true);

		for (int i = listeners.size(); i > 0; i--)
			((ListingListener) listeners.elementAt(i-1)).listingUpdateDone( this );
		// Catch case when there are no bugs in the report - otherwise watched
		// list would still show ?
		for (int i = listeners.size(); i > 0; i--)
			((ListingListener) listeners.elementAt(i-1)).bugCountsChanged( this );

		Cache.getInstance().store(this);
		if (DEBUG) System.out.println(System.currentTimeMillis() + " done making listing"   );
	}

	private void removeBug( Bug bug ){
		bug.removeListing( (ListingStub) this);			
		Status status = bug.getStatus();
		Severity severity = bug.getSeverity();
		if (!status.equals(Status.READ)){
			countUnreadAll--;					
			if (severity.equals( Severity.CRITICAL ) || severity.equals( Severity.GRAVE ) || severity.equals( Severity.SERIOUS ))
				countUnreadRC--;
			if (severity.equals( Severity.IMPORTANT ) || severity.equals( Severity.NORMAL ) )
				countUnreadIN--;
			if (severity.equals( Severity.MINOR ) || severity.equals( Severity.WISHLIST ))
				countUnreadMW--;
			if (bug.getTagFixed() || bug.getTagPending())
				countUnreadFP--;
		}
		countAll--;
		if (severity.equals( Severity.CRITICAL ) || severity.equals( Severity.GRAVE ) || severity.equals( Severity.SERIOUS ))
			countRC--;
		if (severity.equals( Severity.IMPORTANT ) || severity.equals( Severity.NORMAL ) )
			countIN--;
		if (severity.equals( Severity.MINOR ) || severity.equals( Severity.WISHLIST ))
			countMW--;
		if (bug.getTagFixed() || bug.getTagPending())
			countFP--;
	}


				

	/**
	 * Loads all the reports into memory setting listeners and calls bugAdded
	 * events for each
	 */
	public void loadReports(){
		Object[] bugNumber = bugs.keySet().toArray();
		// This is an ideal time to update the counts in case they are out of
		// sync. 
		//
		// Example of where this happens:
		// bugviewer views a bug, changes status to read. Updating report
		// changes severity. No listings are listening at this stage. When
		// bugwatcher is started, it does not contain these updates in the
		// counts. May show x unread in watched list, but no unread in listing.
		//
		// This is of course a hack. The proper way to fix it would be to add a
		// field to Bug for all the listings which it is part of. Then, when the
		// bug is modified, it would load all these listings and update them,
		// irregardless of whether a BugListener has been set in the current
		// invocation of whatever the program is
//		int newcountAll = 0;		int newcountUnreadAll = 0;	
//		int newcountRC = 0;		int newcountUnreadRC = 0;
//		int newcountIN = 0;		int newcountUnreadIN = 0;
//		int newcountMW = 0;		int newcountUnreadMW = 0;
//		int newcountFP = 0;		int newcountUnreadFP = 0;

		
		for( int i = 0; i < bugNumber.length; i++){
			Bug bug = BTS.getInstance().getBug( (Integer) bugNumber[i] );
			if (!bug.getComplete()){
				try{
					bug.update();	
				}catch( Exception e){
					e.printStackTrace();
					// TODO
					continue;
				}
			}
			for (int ij = listeners.size(); ij > 0; ij--)
				((ListingListener) listeners.elementAt(ij-1)).bugAdded(this, bug);
		}
/*		Status status = bug.getStatus();
		Severity severity = bug.getSeverity();
		if (!status.equals(Status.READ)){
			newcountUnreadAll++;					
			if (severity.equals( Severity.CRITICAL ) || severity.equals( Severity.GRAVE ) || severity.equals( Severity.SERIOUS ))
				newcountUnreadRC++;
			if (severity.equals( Severity.IMPORTANT ) || severity.equals( Severity.NORMAL ) )
				newcountUnreadIN++;
			if (severity.equals( Severity.MINOR ) || severity.equals( Severity.WISHLIST ))
				newcountUnreadMW++;
			if (bug.getTagFixed() || bug.getTagPending())
				newcountUnreadFP++;
		}
//		newcountAll++;
		if (severity.equals( Severity.CRITICAL ) || severity.equals( Severity.GRAVE ) || severity.equals( Severity.SERIOUS ))
			newcountRC++;
		if (severity.equals( Severity.IMPORTANT ) || severity.equals( Severity.NORMAL ) )
			newcountIN++;
		if (severity.equals( Severity.MINOR ) || severity.equals( Severity.WISHLIST ))
			newcountMW++;
		if (bug.getTagFixed() || bug.getTagPending())
			newcountFP++;
		
		}
		
//		countAll = newcountAll;		countUnreadAll = newcountUnreadAll;	
//		countRC = newcountRC;		countUnreadRC = newcountUnreadRC;
//		countIN = newcountIN;		countUnreadIN = newcountUnreadIN;
//		countMW = newcountMW;		countUnreadMW = newcountUnreadMW;
//		countFP = newcountFP;		countUnreadFP = newcountUnreadFP;
		Cache.getInstance().store(this);

		for (int i = listeners.size(); i > 0; i--)
			((ListingListener) listeners.elementAt(i-1)).bugCountsChanged( this );
*/		
		for (int ij = listeners.size(); ij > 0; ij--)
			((ListingListener) listeners.elementAt(ij-1)).loadReportsDone(this);
	}

	/**
	 * returns true if exe should continue, false otherwise.
	 */
	private boolean listingException( Exception e ){
		for (int i = listeners.size(); i > 0; i--){
			if (!((ListingListener) listeners.elementAt(i-1)).listingException( this, e )){
				return false;
			}
		}
		return true;
	}


	///// Handling BugListener events
	
	/**
	 * Called whenever the read/unread status of <code>bug</code> changes.
	 */
	public void bugStatusChanged( Bug bug, Status oldStatus ){
		if (bug.getStatus().equals( oldStatus )){ 
			return;
		}
		Severity severity = bug.getSeverity();
		if (oldStatus.equals(Status.READ)){
			countUnreadAll++;					
			if (severity.equals( Severity.CRITICAL ) || severity.equals( Severity.GRAVE ) || severity.equals( Severity.SERIOUS ))
				countUnreadRC++;
			if (severity.equals( Severity.IMPORTANT ) || severity.equals( Severity.NORMAL ) )
				countUnreadIN++;
			if (severity.equals( Severity.MINOR ) || severity.equals( Severity.WISHLIST ))
				countUnreadMW++;
			if (bug.getTagFixed() || bug.getTagPending())
				countUnreadFP++;
		}else{
			countUnreadAll--;
			if (severity.equals( Severity.CRITICAL ) || severity.equals( Severity.GRAVE ) || severity.equals( Severity.SERIOUS ))
				countUnreadRC--;
			if (severity.equals( Severity.IMPORTANT ) || severity.equals( Severity.NORMAL ) )
				countUnreadIN--;
			if (severity.equals( Severity.MINOR ) || severity.equals( Severity.WISHLIST ))
				countUnreadMW--;
			if (bug.getTagFixed() || bug.getTagPending())
				countUnreadFP--;
		}
		for (int i = listeners.size(); i > 0; i--)
			((ListingListener) listeners.elementAt(i-1)).bugChanged( this, bug );
		for (int i = listeners.size(); i > 0; i--)
			((ListingListener) listeners.elementAt(i-1)).bugCountsChanged( this );
		Cache.getInstance().store(this);
	}

	public void bugSeverityChanged( Bug bug, Severity oldseverity ){
		Severity severity = bug.getSeverity();
		if (severity.equals( Severity.CRITICAL ) || severity.equals( Severity.GRAVE ) || severity.equals( Severity.SERIOUS ))
			countRC++;
		if (severity.equals( Severity.IMPORTANT ) || severity.equals( Severity.NORMAL ) )
			countIN++;
		if (severity.equals( Severity.MINOR ) || severity.equals( Severity.WISHLIST ))
			countMW++;
		if (bug.getTagFixed() || bug.getTagPending())
			countFP++;

		if (!bug.getStatus().equals(Status.READ)){
			if (severity.equals( Severity.CRITICAL ) || severity.equals( Severity.GRAVE ) || severity.equals( Severity.SERIOUS ))
				countUnreadRC++;
			if (severity.equals( Severity.IMPORTANT ) || severity.equals( Severity.NORMAL ) )
				countUnreadIN++;
			if (severity.equals( Severity.MINOR ) || severity.equals( Severity.WISHLIST ))
				countUnreadMW++;
			if (bug.getTagFixed() || bug.getTagPending())
				countUnreadFP++;
		}

		if (oldseverity.equals( Severity.CRITICAL ) || oldseverity.equals( Severity.GRAVE ) || oldseverity.equals( Severity.SERIOUS ))
			countRC--;
		if (oldseverity.equals( Severity.IMPORTANT ) || oldseverity.equals( Severity.NORMAL ) )
			countIN--;
		if (oldseverity.equals( Severity.MINOR ) || oldseverity.equals( Severity.WISHLIST ))
			countMW--;
		if (bug.getTagFixed() || bug.getTagPending())
			countFP--;

		if (!bug.getStatus().equals(Status.READ)){
			if (oldseverity.equals( Severity.CRITICAL ) || oldseverity.equals( Severity.GRAVE ) || oldseverity.equals( Severity.SERIOUS ))
				countUnreadRC--;
			if (oldseverity.equals( Severity.IMPORTANT ) || oldseverity.equals( Severity.NORMAL ) )
				countUnreadIN--;
			if (oldseverity.equals( Severity.MINOR ) || oldseverity.equals( Severity.WISHLIST ))
				countUnreadMW--;
			if (bug.getTagFixed() || bug.getTagPending())
				countUnreadFP--;
		}
		Cache.getInstance().store(this);
		for (int i = listeners.size(); i > 0; i--)
			((ListingListener) listeners.elementAt(i-1)).bugCountsChanged( this );
	}

	/**
	 * Called when a bug is updated
	 */
	public void bugUpdated( Bug bug ){ // Do nothing (for now). we probably called this anyway.
	}

	/**
	 * Called when an exception occurs with a bug (e.g. error contacting server)
	 * @return true if execution should continue
	 */
	public boolean bugException( Bug bug, Exception e ){
		// TODO: do we do anything??
		return true;
	}
	/**
	 * Called when a bug is being retrieved, If verbose progress notifications
	 * have been requested
	 */
	public void retrievingBug( Bug bug ){}
	/**
	 * Called when downloading of a bug report has completed
	 */
	public void bugDownloaded( Bug bug ){}



}
