package com.tildemh.debbug;

/**
 * Interface for events related to a bug object.
 * 
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BugListener.java,v 1.4 2003/11/19 21:35:22 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public interface BugListener{

	/**
	 * Called whenever the read/unread status of <code>bug</code> changes.
	 */
	public void bugStatusChanged( Bug bug, Status oldStatus );

	/**
	 * Called when the severity of <code>bug</code> changes
	 */
	public void bugSeverityChanged( Bug bug, Severity oldSeverity );
	

	/**
	 * Called when bug comments or tags are updated (i.e. everything not covered
	 * by other events)
	 */
	public void bugUpdated( Bug bug );

	/**
	 * Called when an exception occurs with a bug (e.g. error contacting server)
	 * @return true if execution should continue
	 */
	public boolean bugException( Bug bug, Exception e );

	/**
	 * Called when a bug is being retrieved, If verbose progress notifications
	 * have been requested
	 */
	public void retrievingBug( Bug bug );
	/**
	 * Called when downloading of a bug report has completed
	 */
	public void bugDownloaded( Bug bug );

}
