package com.tildemh.debbug;

/**
 * Any comment added to a bug report, including the initial report. 
 *
 * <p>Methods of this object will use extract the data
 * from the source text as needed. -- Not much of this is implemented yet.
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BugComment.java,v 1.6 2003/08/31 09:51:06 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BugComment implements java.io.Serializable{

		
	private volatile String source;	// the original source message. 
	private String submitter = null;
	private String subject = null;
	private String headers = null;
	private String body = null;
	
	/**
	 * Creates a new comment
	 */
	public BugComment(String source){
		this.source = source;
	}

	/** 
	 * @return the body of the comment
	 */
	public String getBody(){
		int boundary = source.indexOf("\n\n");
		if (boundary < 0)
			return "WARNING: head/bdy boundary not found. Returning full source"+source;
		return source.substring( boundary ); 
	}

	public String getSource(){
		return source;
	}

	public String getHead(){
		int boundary = source.indexOf("\n\n");
		if (boundary < 0) // FIXME: throw exception??
			return "Unknown divide - putting all in body";
		return source.substring(0, boundary );
	}
	public String toString(){
		return source;
	}

	/** 
	 * @return person who sent the bug report
	 */
	public String getSubmitter(){
		return null;
		// TODO
	}

}
