/* 
 * $Id: ctktogglebutton.c,v 1.19 2000/07/26 22:31:16 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"
#include "ctkcolor.h"

static void ctk_toggle_button_clicked_handler(CtkButton* button, gpointer data);

/* Initialize the Button */
void ctk_toggle_button_init(CtkToggleButton* button)
{
	ctk_button_init(&button->button);
	CTK_OBJECT(button)->type = CtkTypeToggleButton;

	button->active = FALSE;
	
	ctk_signal_new("toggled", CtkTypeToggleButton);	

	((CtkWidget *)button)->width = 5;
	((CtkWidget *)button)->height = 1;
	((CtkWidget *)button)->orig_width = 5;
	((CtkWidget *)button)->orig_height = 1;	
	((CtkWidget *)button)->main_col = 
	    ctk_calculate_palette(CTK_COLOR_CYAN,CTK_COLOR_BLUE);
	((CtkWidget *)button)->inverse_col =
	    ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_RED);
	((CtkWidget *)button)->selected_col =
	    ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_MAGENTA);
	((CtkWidget *)button)->inv_selected_col =
	    ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_CYAN);

	ctk_signal_connect(CTK_OBJECT(button), "clicked",
			   CTK_SIGNAL_FUNC(&ctk_toggle_button_clicked_handler), 
			   NULL);
}

/* New Toggle Button */
CtkWidget* ctk_toggle_button_new(void)
{
	CtkToggleButton* button;
	
	button = g_malloc(sizeof(CtkToggleButton));
	
	ctk_toggle_button_init(button);

	return ((CtkWidget *)button);
}

/* New Toggle Button with label */
CtkWidget* ctk_toggle_button_new_with_label(const gchar* label)
{
	CtkWidget* button;
	CtkWidget* label_widget;
	
	button = ctk_toggle_button_new();
	
	if (label) 
	{
		label_widget = ctk_label_new(label);
		ctk_container_add(CTK_CONTAINER(button),label_widget);
	}	

	return button;
}

/* Toggle a toggle type button */
void ctk_toggle_button_toggled(CtkToggleButton* button)
{
	if (CTK_CHECK_TYPE(button, CtkTypeRadioButton))
	{
		CtkRadioButton* radiobutton;
		GSList*         scan;
		
		radiobutton = CTK_RADIO_BUTTON(button);
		((CtkToggleButton*)radiobutton)->active = TRUE;
		
		/* This is verified gtk behaviour */
		for (scan = radiobutton->radio_group; scan; scan = scan->next)
		{
			CtkRadioButton* b2;
			b2 = CTK_RADIO_BUTTON(scan->data);
		
			if (((CtkToggleButton*)b2)->active && 
				(CtkToggleButton*)b2 != button)
			{
				((CtkToggleButton*)b2)->active = FALSE;
				ctk_signal_emit_by_name(CTK_OBJECT(b2), "toggled");
				break;
			}
		}
		
		ctk_signal_emit_by_name(CTK_OBJECT(button), "toggled");
	}
	else
	{
		if (button->active)
		    button->active = FALSE;
		else
		    button->active = TRUE;
		
		ctk_draw_mark_changed(CTK_WIDGET(button));
		ctk_signal_emit_by_name(CTK_OBJECT(button), "toggled");
	}
}

/* Button was clicked on */
void ctk_toggle_button_clicked_handler(CtkButton* button, gpointer data)
{
	ctk_toggle_button_toggled(CTK_TOGGLE_BUTTON(button));
}

/* Set Active */
void ctk_toggle_button_set_active(CtkToggleButton* toggle_button,
				 gboolean is_active)
{
	if (!toggle_button)
	    return;
	
	if (toggle_button->active != is_active)
		ctk_button_clicked(CTK_BUTTON(toggle_button));
}

gboolean ctk_toggle_button_get_active(CtkToggleButton* toggle_button)
{
	return toggle_button->active;
}
