/* 
 * $Id: ctkcheckbutton.c,v 1.20 2000/07/12 22:47:14 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"
#include "ctkcolor.h"

gpointer ctk_check_button_mouse_handle_events(CtkWidget *window, CtkWidget *widget, char *event, gint y, gint x);

/* Initialize the Button */
void ctk_check_button_init(CtkCheckButton* button)
{
	ctk_toggle_button_init(&button->togglebutton);

	((CtkObject *)button)->type = CtkTypeCheckButton;
	((CtkWidget *)button)->width = 4;
	((CtkWidget *)button)->height = 1;
	((CtkWidget *)button)->orig_width = 4;
	((CtkWidget *)button)->orig_height = 1;
	((CtkWidget *)button)->main_col = ctk_calculate_palette(CTK_COLOR_CYAN,CTK_COLOR_BLUE);
	((CtkWidget *)button)->inverse_col = ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_RED);
	((CtkWidget *)button)->insensitive_col = ctk_calculate_palette(CTK_COLOR_GRAY,CTK_COLOR_LIGHT_GRAY);
	
	((CtkWidget*)button)->set_min_size  = &ctk_check_button_min_size;
	((CtkWidget*)button)->set_real_size = &ctk_check_button_real_size;
}

/* Create a Button Widget */
CtkWidget* ctk_check_button_new()
{
	CtkCheckButton *button;
	
	button = g_malloc(sizeof(CtkCheckButton));
	
	ctk_check_button_init(button);
	
	return ((CtkWidget *)button);
}

CtkWidget* ctk_check_button_new_with_label(const gchar* text)
{
	CtkWidget* button;
	CtkWidget* label;

	button = ctk_check_button_new();

	label = ctk_label_new(text);
	ctk_misc_set_alignment(CTK_MISC(label), 0, 0.5);
	
	ctk_container_add(CTK_CONTAINER(button),label);

	ctk_widget_show(label);
	
	return button;
}

void ctk_check_button_min_size(CtkWidget* widget)
{
	/* We are a bin that needs 4 extra columns */
	ctk_bin_min_size(widget);
	widget->min_width += 4;
	
	if (widget->min_height <= 0) widget->min_height = 1;
}

void ctk_check_button_real_size(CtkWidget* widget)
{
	/* We need to size the children without our extra 4 spaces */
	widget->width -= 4;
	widget->col   += 4;
	ctk_bin_real_size(widget);
	widget->width += 4;
	widget->col   -= 4;
}
