/* 
 * $Id: ctkbox.h,v 1.7 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKBOX_H__
#define __CTKBOX_H__

/* BOX Structure and Attributes */

typedef struct CtkBox_S {
	CtkTable table;
	gint     pack_index;
	
	void (*pack_start)(struct CtkBox_S* box, CtkWidget* child, 
				gboolean expand, gboolean fill, gint padding);
	void (*pack_end  )(struct CtkBox_S* box, CtkWidget* child, 
				gboolean expand, gboolean fill, gint padding);
} CtkBox;

/* MACRO for type definitions */

#define CTK_BOX(obj)	CTK_CHECK_CAST((obj),CtkBox,CtkTypeBox)

void ctk_box_init(CtkBox* box, guint rows, guint cols, gboolean homogeneous);

void ctk_box_pack_start(CtkBox* box, CtkWidget* child, gboolean expand, gboolean fill, gint padding);
void ctk_box_pack_end  (CtkBox* box, CtkWidget* child, gboolean expand, gboolean fill, gint padding);

#endif
