/* 
 * $Id: ctk.h,v 1.23 2000/07/07 00:27:32 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTK_H__
# define __CTK_H__

#include <glib.h>

#include <ctk/ctkobject.h>
#include <ctk/ctkwidget.h>
#include <ctk/ctkmisc.h>
#include <ctk/ctklabel.h>
#include <ctk/ctkcontainer.h>
#include <ctk/ctkbin.h>
#include <ctk/ctkframe.h>
#include <ctk/ctkbutton.h>
#include <ctk/ctktogglebutton.h>
#include <ctk/ctkcheckbutton.h>
#include <ctk/ctkradiobutton.h>
#include <ctk/ctkwindow.h>
#include <ctk/ctkscrolledwindow.h>
#include <ctk/ctkviewport.h>
#include <ctk/ctkitem.h>
#include <ctk/ctkmenuitem.h>
#include <ctk/ctklistitem.h>
#include <ctk/ctktable.h>
#include <ctk/ctkbox.h>
#include <ctk/ctkhbox.h>
#include <ctk/ctkcombo.h>
#include <ctk/ctkvbox.h>
#include <ctk/ctkclist.h>
#include <ctk/ctklist.h>
#include <ctk/ctknotebook.h>
#include <ctk/ctkmenushell.h>
#include <ctk/ctkmenu.h>
#include <ctk/ctkoptionmenu.h>
#include <ctk/ctktablechild.h>
#include <ctk/ctkeditable.h>
#include <ctk/ctkentry.h>
#include <ctk/ctkspinbutton.h>
#include <ctk/ctkrange.h>
#include <ctk/ctkscale.h>
#include <ctk/ctkhscale.h>
#include <ctk/ctkvscale.h>
#include <ctk/ctkseparator.h>
#include <ctk/ctkhseparator.h>
#include <ctk/ctkvseparator.h>
#include <ctk/ctkprogress.h>
#include <ctk/ctkprogressbar.h>
#include <ctk/ctkdata.h>
#include <ctk/ctkadjustment.h>

#include <ctk/ctkmain.h>
#include <ctk/ctkdraw.h>
#include <ctk/ctkio.h>
#include <ctk/ctkstack.h>
#include <ctk/ctksignal.h>
#include <ctk/ctksize.h>
#include <ctk/ctkassert.h>

/* Object Hierarchy
 *
 * CtkObject
 *     CtkWidget
 *         CtkLabel
 *         CtkContainer
 *             CtkBin
 *                 CtkButton
 *                     CtkToggleButton
 *                         CtkCheckButton
 *                             CtkRadioButton
 *                     CtkOptionMenu
 *                 CtkWindow
 *                 CtkScrolledWindow
 *                 CtkViewport
 *                 CtkItem
 *                     CtkMenuItem
 *             CtkBox
 *                 CtkHbox
 *                     CtkCombo
 *                 CtkVbox
 *             CtkCList
 *             CtkNotebook
 *             CtkMenuShell
 *                 CtkMenu
 *             CtkTable
 * 	   CtkEditable
 *             CtkEntry
 *                 CtkSpinButton
 *         CtkRange
 *             CtkScale
 *                 CtkHScale
 *                 CtkVScale
 *         CtkSeparator
 *             CtkHSeparator
 *             CtkVSeparator
 *         CtkProgress
 *             CtkProgressBar
 *     CtkData
 *         CtkAdjustment
 */

#endif
